/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureBiomeCheck {
    public static boolean checkBiomes(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext, HolderSet<Biome> blacklistedBiomes) {
        int biomeCheckDistance = (int)Math.ceil((double)structureData.getBiomeCheckDistance() / 16.0);
        if (biomeCheckDistance == 0 || generationContext.biomeSource() instanceof CheckerboardColumnBiomeSource) {
            return true;
        }
        StructureData.BiomeCheckMode biomeCheckMode = structureData.getBiomeCheckMode();
        if (biomeCheckMode == StructureData.BiomeCheckMode.BLACKLIST && structureData.getBiomeCheckBlacklistedBiomes().isEmpty()) {
            return true;
        }
        ChunkPos chunkPos = generationContext.chunkPos();
        BiomeSource biomeSource = generationContext.biomeSource();
        RandomState randomState = generationContext.randomState();
        Climate.Sampler biomeSampler = randomState.sampler();
        int blockX = chunkPos.x << 4;
        int blockZ = chunkPos.z << 4;
        int surfaceY = generationContext.chunkGenerator().getFirstFreeHeight(blockX, blockZ, Heightmap.Types.WORLD_SURFACE_WG, generationContext.heightAccessor(), generationContext.randomState());
        for (int curChunkX = chunkPos.x - biomeCheckDistance; curChunkX <= chunkPos.x + biomeCheckDistance; ++curChunkX) {
            block5: for (int curChunkZ = chunkPos.z - biomeCheckDistance; curChunkZ <= chunkPos.z + biomeCheckDistance; ++curChunkZ) {
                blockX = (curChunkX << 4) + 8;
                blockZ = (curChunkZ << 4) + 8;
                Holder biome = biomeSource.getNoiseBiome(QuartPos.fromBlock((int)blockX), QuartPos.fromBlock((int)256), QuartPos.fromBlock((int)blockZ), biomeSampler);
                switch (biomeCheckMode) {
                    case STRICT: {
                        if (generationContext.validBiome().test(biome)) continue block5;
                        return false;
                    }
                    case BLACKLIST: {
                        if (!blacklistedBiomes.contains(biome)) continue block5;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

