/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.renderer;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ScalableItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private final float xScale;
    private final float yScale;
    private final float zScale;

    public ScalableItemStackRenderer(float scale) {
        this.xScale = scale;
        this.yScale = scale;
        this.zScale = scale;
    }

    public void render(GuiGraphics guiGraphics, ItemStack ingredient) {
        if (ingredient != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(this.xScale, this.yScale, this.zScale);
            ScalableItemStackRenderer.drawItemStack(guiGraphics, ingredient, 0, 0, 16.0f, 16.0f, 16.0f);
            guiGraphics.pose().popPose();
        }
    }

    public int getWidth() {
        return (int)(this.xScale * 16.0f);
    }

    public int getHeight() {
        return (int)(this.yScale * 16.0f);
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack itemStack, int xOffset, int yOffset, float xScale, float yScale, float zScale) {
        guiGraphics.renderItem(itemStack, xOffset, yOffset);
    }

    @NotNull
    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        try {
            return ingredient.getTooltipLines(Item.TooltipContext.of((Level)((Player)Objects.requireNonNull(player)).level()), (Player)player, tooltipFlag);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Failed to get tooltip: {}", (Object)ingredient, (Object)e);
            return Collections.emptyList();
        }
    }
}

