/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data.wind;

import io.github.mortuusars.sootychimneys.data.wind.TimeOfDay;
import io.github.mortuusars.sootychimneys.data.wind.Weather;
import io.github.mortuusars.sootychimneys.data.wind.WindData;
import io.github.mortuusars.sootychimneys.data.wind.WindState;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class Wind {
    private static final WindData wind = new WindData(0.0, 0.0f);

    public static WindData getWind() {
        return wind;
    }

    public static void update(Level level) {
        RandomSource random = level.getRandom();
        WindState windState = Wind.getWindState(level);
        double addDegrees = windState.max() * (float)(random.nextInt(2) - 1);
        float targetStrength = Mth.map((float)random.nextFloat(), (float)0.0f, (float)1.0f, (float)windState.min(), (float)windState.max());
        float strength = Mth.lerp((float)0.1f, (float)wind.getStrength(), (float)targetStrength);
        wind.set(wind.getAngleInDegrees() + addDegrees, strength);
    }

    private static WindState getWindState(Level level) {
        int day = (int)(level.getGameTime() / 24000L);
        TimeOfDay timeOfDay = TimeOfDay.of(level);
        Weather weather = Weather.of(level);
        if (weather == Weather.THUNDER) {
            return WindState.STORMY;
        }
        if (weather == Weather.RAIN) {
            return timeOfDay != TimeOfDay.EVENING && day % 3 > 0 ? WindState.WINDY : WindState.BREEZE;
        }
        if (timeOfDay == TimeOfDay.DAY) {
            return day % 5 > 2 ? WindState.BREEZE : WindState.CALM;
        }
        return day % 4 == 0 ? WindState.BREEZE : WindState.CALM;
    }
}

