/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Optional;
import net.caffeinemc.mods.sodium.client.compatibility.environment.OsUtils;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.Workarounds;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptions;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import net.caffeinemc.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.ParticleStatus;
import net.minecraft.network.chat.Component;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();
    private static final Window window = Minecraft.getInstance().getWindow();

    public static OptionPage general() {
        Monitor monitor = window.findBestMonitor();
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.renderDistance")).setTooltip((Component)Component.translatable((String)"sodium.options.view_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> options.renderDistance().set(value), options -> (Integer)options.renderDistance().get()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.simulationDistance")).setTooltip((Component)Component.translatable((String)"sodium.options.simulation_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 5, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> options.simulationDistance().set(value), options -> (Integer)options.simulationDistance().get()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.gamma")).setTooltip((Component)Component.translatable((String)"sodium.options.brightness.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> opts.gamma().set((Object)((double)value.intValue() * 0.01)), opts -> (int)((Double)opts.gamma().get() / 0.01)).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.guiScale")).setTooltip((Component)Component.translatable((String)"sodium.options.gui_scale.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, Minecraft.getInstance().getWindow().calculateScale(0, Minecraft.getInstance().isEnforceUnicode()), 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.guiScale().set(value);
            Minecraft client = Minecraft.getInstance();
            client.resizeDisplay();
        }, opts -> (Integer)opts.guiScale().get()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.fullscreen")).setTooltip((Component)Component.translatable((String)"sodium.options.fullscreen.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.fullscreen().set(value);
            Minecraft client = Minecraft.getInstance();
            Window window = client.getWindow();
            if (window != null && window.isFullscreen() != ((Boolean)opts.fullscreen().get()).booleanValue()) {
                window.toggleFullScreen();
                opts.fullscreen().set((Object)window.isFullscreen());
            }
        }, opts -> (Boolean)opts.fullscreen().get()).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.fullscreen.resolution")).setTooltip((Component)Component.translatable((String)"sodium.options.fullscreen_resolution.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, null != monitor ? monitor.getModeCount() : 0, 1, ControlValueFormatter.resolution())).setBinding((options, value) -> {
            if (null != monitor) {
                window.setPreferredFullscreenVideoMode(0 == value ? Optional.empty() : Optional.of(monitor.getMode(value - 1)));
            }
        }, options -> {
            if (null == monitor) {
                return 0;
            }
            Optional optional = window.getPreferredFullscreenVideoMode();
            return optional.map(videoMode -> monitor.getVideoModeIndex(videoMode) + 1).orElse(0);
        }).setEnabled(() -> OsUtils.getOs() == OsUtils.OperatingSystem.WIN && Minecraft.getInstance().getWindow().findBestMonitor() != null).setFlags(OptionFlag.REQUIRES_VIDEOMODE_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.vsync")).setTooltip((Component)Component.translatable((String)"sodium.options.v_sync.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((OptionInstance<Boolean>)Minecraft.getInstance().options.enableVsync())).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.framerateLimit")).setTooltip((Component)Component.translatable((String)"sodium.options.fps_limit.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 10, 260, 10, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.framerateLimit().set(value);
            Minecraft.getInstance().getWindow().setFramerateLimit(value.intValue());
        }, opts -> (Integer)opts.framerateLimit().get()).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.viewBobbing")).setTooltip((Component)Component.translatable((String)"sodium.options.view_bobbing.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((OptionInstance<Boolean>)Minecraft.getInstance().options.bobView())).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setName((Component)Component.translatable((String)"options.attackIndicator")).setTooltip((Component)Component.translatable((String)"sodium.options.attack_indicator.tooltip")).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new Component[]{Component.translatable((String)"options.off"), Component.translatable((String)"options.attack.crosshair"), Component.translatable((String)"options.attack.hotbar")})).setBinding((opts, value) -> opts.attackIndicator().set(value), opts -> (AttackIndicatorStatus)opts.attackIndicator().get()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.autosaveIndicator")).setTooltip((Component)Component.translatable((String)"sodium.options.autosave_indicator.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.showAutosaveIndicator().set(value), opts -> (Boolean)opts.showAutosaveIndicator().get()).build()).build());
        return new OptionPage((Component)Component.translatable((String)"stat.generalButton"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsStatus.class, vanillaOpts).setName((Component)Component.translatable((String)"options.graphics")).setTooltip((Component)Component.translatable((String)"sodium.options.graphics_quality.tooltip")).setControl(option -> new CyclingControl<GraphicsStatus>((Option<GraphicsStatus>)option, GraphicsStatus.class, new Component[]{Component.translatable((String)"options.graphics.fast"), Component.translatable((String)"options.graphics.fancy"), Component.translatable((String)"options.graphics.fabulous")})).setBinding((opts, value) -> opts.graphicsMode().set(value), opts -> (GraphicsStatus)opts.graphicsMode().get()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(CloudStatus.class, vanillaOpts).setName((Component)Component.translatable((String)"options.renderClouds")).setTooltip((Component)Component.translatable((String)"sodium.options.clouds_quality.tooltip")).setControl(option -> new CyclingControl<CloudStatus>((Option<CloudStatus>)option, CloudStatus.class, new Component[]{Component.translatable((String)"options.off"), Component.translatable((String)"options.graphics.fast"), Component.translatable((String)"options.graphics.fancy")})).setBinding((opts, value) -> {
            RenderTarget framebuffer;
            opts.cloudStatus().set(value);
            if (Minecraft.useShaderTransparency() && (framebuffer = Minecraft.getInstance().levelRenderer.getCloudsTarget()) != null) {
                framebuffer.clear(Minecraft.ON_OSX);
            }
        }, opts -> (CloudStatus)opts.cloudStatus().get()).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((Component)Component.translatable((String)"soundCategory.weather")).setTooltip((Component)Component.translatable((String)"sodium.options.weather_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.leaves_quality.name")).setTooltip((Component)Component.translatable((String)"sodium.options.leaves_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setName((Component)Component.translatable((String)"options.particles")).setTooltip((Component)Component.translatable((String)"sodium.options.particle_quality.tooltip")).setControl(option -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)option, ParticleStatus.class, new Component[]{Component.translatable((String)"options.particles.all"), Component.translatable((String)"options.particles.decreased"), Component.translatable((String)"options.particles.minimal")})).setBinding((opts, value) -> opts.particles().set(value), opts -> (ParticleStatus)opts.particles().get()).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.ao")).setTooltip((Component)Component.translatable((String)"sodium.options.smooth_lighting.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.ambientOcclusion().set(value), opts -> (Boolean)opts.ambientOcclusion().get()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.biomeBlendRadius")).setTooltip((Component)Component.translatable((String)"sodium.options.biome_blend.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 1, 7, 1, ControlValueFormatter.biomeBlend())).setBinding((opts, value) -> opts.biomeBlendRadius().set(value), opts -> (Integer)opts.biomeBlendRadius().get()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.entityDistanceScaling")).setTooltip((Component)Component.translatable((String)"sodium.options.entity_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> opts.entityDistanceScaling().set((Object)((double)value.intValue() / 100.0)), opts -> Math.round(((Double)opts.entityDistanceScaling().get()).floatValue() * 100.0f)).setImpact(OptionImpact.HIGH).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.entityShadows")).setTooltip((Component)Component.translatable((String)"sodium.options.entity_shadows.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.entityShadows().set(value), opts -> (Boolean)opts.entityShadows().get()).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.vignette.name")).setTooltip((Component)Component.translatable((String)"sodium.options.vignette.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.translatable((String)"options.mipmapLevels")).setTooltip((Component)Component.translatable((String)"sodium.options.mipmap_levels.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> opts.mipmapLevels().set(value), opts -> (Integer)opts.mipmapLevels().get()).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage((Component)Component.translatable((String)"sodium.options.pages.quality"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.chunk_update_threads.name")).setTooltip((Component)Component.translatable((String)"sodium.options.chunk_update_threads.tooltip")).setControl(o -> new SliderControl((Option<Integer>)o, 0, Runtime.getRuntime().availableProcessors(), 1, ControlValueFormatter.quantityOrDisabled("threads", "Default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.always_defer_chunk_updates.name")).setTooltip((Component)Component.translatable((String)"sodium.options.always_defer_chunk_updates.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.use_block_face_culling.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_block_face_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useBlockFaceCulling = value;
        }, opts -> opts.performance.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.use_fog_occlusion.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_fog_occlusion.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.performance.useFogOcclusion = value;
        }, opts -> opts.performance.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.use_entity_culling.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_entity_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useEntityCulling = value;
        }, opts -> opts.performance.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.animate_only_visible_textures.name")).setTooltip((Component)Component.translatable((String)"sodium.options.animate_only_visible_textures.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.animateOnlyVisibleTextures = value;
        }, opts -> opts.performance.animateOnlyVisibleTextures).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.use_no_error_context.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_no_error_context.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.LOW).setBinding((opts, value) -> {
            opts.performance.useNoErrorGLContext = value;
        }, opts -> opts.performance.useNoErrorGLContext).setEnabled(SodiumGameOptionPages::supportsNoErrorContext).setFlags(OptionFlag.REQUIRES_GAME_RESTART).build()).build());
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.sort_behavior.name")).setTooltip((Component)Component.translatable((String)"sodium.options.sort_behavior.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                opts.performance.sortingEnabled = value;
            }, opts -> opts.performance.sortingEnabled).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        }
        return new OptionPage((Component)Component.translatable((String)"sodium.options.pages.performance"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    private static boolean supportsNoErrorContext() {
        GLCapabilities capabilities = GL.getCapabilities();
        return (capabilities.OpenGL46 || capabilities.GL_KHR_no_error) && !Workarounds.isWorkaroundEnabled((Workarounds.Reference)Workarounds.Reference.NO_ERROR_CONTEXT_UNSUPPORTED);
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        boolean isPersistentMappingSupported = MappedStagingBuffer.isSupported(RenderDevice.INSTANCE);
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.use_persistent_mapping.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_persistent_mapping.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setEnabled(() -> isPersistentMappingSupported).setBinding((opts, value) -> {
            opts.advanced.useAdvancedStagingBuffers = value;
        }, opts -> opts.advanced.useAdvancedStagingBuffers).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((Component)Component.translatable((String)"sodium.options.cpu_render_ahead_limit.name")).setTooltip((Component)Component.translatable((String)"sodium.options.cpu_render_ahead_limit.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 9, 1, ControlValueFormatter.translateVariable("sodium.options.cpu_render_ahead_limit.value"))).setBinding((opts, value) -> {
            opts.advanced.cpuRenderAheadLimit = value;
        }, opts -> opts.advanced.cpuRenderAheadLimit).build()).build());
        return new OptionPage((Component)Component.translatable((String)"sodium.options.pages.advanced"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

