/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.smithingtemplateviewer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.Level;

public class SmithingTrimWrapper {
    public static final List<SmithingTrimWrapper> INSTANCES = new ArrayList<SmithingTrimWrapper>();
    private SmithingTrimRecipe recipe;
    private ArmorStand armorStand;
    private int[] armorIndex;
    private int colorIndex;
    private List<List<ItemStack>> armors;

    public SmithingTrimWrapper(SmithingTrimRecipe recipe) {
        this.recipe = recipe;
        this.armorIndex = new int[]{1, 1, 1, 1};
        this.colorIndex = 0;
        this.armors = new ArrayList<List<ItemStack>>();
        this.armors.add(new ArrayList());
        this.armors.add(new ArrayList());
        this.armors.add(new ArrayList());
        this.armors.add(new ArrayList());
        for (ItemStack item : this.recipe.base.getItems()) {
            Item item2 = item.getItem();
            if (!(item2 instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item2;
            this.armors.get(3 - armorItem.getType().getSlot().getIndex()).add(item.copy());
        }
        this.recreateArmorStand((Level)Minecraft.getInstance().level);
        INSTANCES.add(this);
    }

    public void recreateArmorStand(Level level) {
        this.armorStand = new ArmorStand(level, 0.0, 0.0, 0.0);
        this.armorStand.setNoBasePlate(true);
        this.armorStand.setShowArms(true);
        this.armorStand.yBodyRot = 210.0f;
        this.armorStand.setXRot(25.0f);
        this.armorStand.yHeadRot = this.armorStand.getYRot();
        this.armorStand.yHeadRotO = this.armorStand.getYRot();
        this.updateArmorStand(level);
    }

    public SmithingTrimRecipe getRecipe() {
        return this.recipe;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public int[] getArmorIndex() {
        return this.armorIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public List<List<ItemStack>> getArmors() {
        return this.armors;
    }

    public void updateArmorStand(Level level) {
        EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        for (int i = 0; i < 4; ++i) {
            int index = this.armorIndex[i];
            if (index != 0) {
                ItemStack stack = this.getArmors().get(i).get(index - 1);
                stack = this.recipe.assemble(new SmithingRecipeInput(this.recipe.template.getItems()[0].copy(), stack.copy(), this.recipe.addition.getItems()[this.getColorIndex()]), (HolderLookup.Provider)level.registryAccess());
                this.armorStand.setItemSlot(slots[i], stack.copy());
                continue;
            }
            this.armorStand.setItemSlot(slots[i], ItemStack.EMPTY);
        }
    }
}

