/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.banner;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerModel;

public class BannerUpgrade
extends Upgrade {
    public ItemStack banner = Items.WHITE_BANNER.getDefaultInstance();
    public float rotation;
    public float prevRotation;

    public BannerUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.BANNER.get(), planeEntity);
        this.prevRotation = planeEntity.yRotO;
        this.rotation = planeEntity.yRotO;
    }

    @Override
    public void tick() {
        this.prevRotation = this.rotation;
        this.rotation = MathUtil.lerpAngle(0.05f, this.rotation, this.planeEntity.yRotO);
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("banner", this.banner.save((HolderLookup.Provider)this.planeEntity.registryAccess()));
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        Tag tag = nbt.get("banner");
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.banner = ItemStack.parseOptional((HolderLookup.Provider)this.planeEntity.registryAccess(), (CompoundTag)compoundTag);
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        BannerModel.renderBanner(this, partialTicks, matrixStack, buffer, this.banner, packedLight);
    }

    @Override
    public void onApply(ItemStack itemStack) {
        if (itemStack.getItem() instanceof BannerItem) {
            this.banner = itemStack.copy();
            this.banner.setCount(1);
            this.updateClient();
        }
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.banner);
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        this.banner = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
    }

    @Override
    public ItemStack getItemStack() {
        return this.banner;
    }
}

