/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class ArmorUpgrade
extends Upgrade {
    private int protectionLevel = 0;

    public ArmorUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.ARMOR.get(), planeEntity);
    }

    @Override
    public void onApply(ItemStack itemStack) {
        this.planeEntity.level().registryAccess().registry(Registries.ENCHANTMENT).flatMap(registry -> registry.getHolder(Enchantments.PROTECTION)).ifPresent(enchant -> {
            this.protectionLevel = itemStack.getEnchantmentLevel((Holder)enchant);
        });
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        EntityType entityType = this.planeEntity.getType();
        UpgradesModels.ModelEntry modelEntry = UpgradesModels.MODEL_ENTRIES.get(this.getType());
        if (entityType == SimplePlanesEntities.PLANE.get()) {
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)modelEntry.normalTexture()), (this.protectionLevel > 0 ? 1 : 0) != 0);
            modelEntry.normal().renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.itemEntityTranslucentCull((ResourceLocation)modelEntry.normalTexture()), (boolean)false);
            UpgradesModels.ARMOR_WINDOW.renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)modelEntry.largeTexture()), (this.protectionLevel > 0 ? 1 : 0) != 0);
            modelEntry.large().renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        } else if (entityType == SimplePlanesEntities.CARGO_PLANE.get()) {
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)modelEntry.cargoTexture()), (this.protectionLevel > 0 ? 1 : 0) != 0);
            modelEntry.cargo().renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        } else {
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)modelEntry.heliTexture()), (this.protectionLevel > 0 ? 1 : 0) != 0);
            modelEntry.heli().renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        buffer.writeByte(this.protectionLevel);
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        this.protectionLevel = buffer.readByte();
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack itemStack = SimplePlanesItems.ARMOR.get().getDefaultInstance();
        if (this.protectionLevel > 0) {
            this.planeEntity.level().registryAccess().registry(Registries.ENCHANTMENT).flatMap(registry -> registry.getHolder(Enchantments.PROTECTION)).ifPresent(enchant -> itemStack.enchant((Holder)enchant, this.protectionLevel));
        }
        return itemStack;
    }

    public float getReducedDamage(float amount) {
        return amount * (1.0f - 0.04f * (float)this.getArmorValue());
    }

    public int getArmorValue() {
        return 15 + this.protectionLevel * 2;
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putByte("protection", (byte)this.protectionLevel);
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.protectionLevel = nbt.getByte("protection");
    }
}

