/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Quaternionf;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;

public record RotationPacket(Quaternionf quaternion) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RotationPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"rotation"));
    public static final StreamCodec<ByteBuf, RotationPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.QUATERNIONF, RotationPacket::quaternion, RotationPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().getVehicle();
            if (patt0$temp instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)patt0$temp;
                planeEntity.setQ(this.quaternion);
                MathUtil.EulerAngles eulerAngles = MathUtil.toEulerAngles(this.quaternion);
                planeEntity.setYRot((float)eulerAngles.yaw);
                planeEntity.setXRot((float)eulerAngles.pitch);
                planeEntity.rotationRoll = (float)eulerAngles.roll;
                planeEntity.setQ_Client(this.quaternion);
            }
        });
    }
}

