/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;

public record CycleItemsPacket(Direction direction) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CycleItemsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"cycle_items"));
    public static final StreamCodec<ByteBuf, CycleItemsPacket> STREAM_CODEC = new StreamCodec<ByteBuf, CycleItemsPacket>(){

        public CycleItemsPacket decode(ByteBuf pBuffer) {
            return new CycleItemsPacket(Direction.values()[pBuffer.readByte()]);
        }

        public void encode(ByteBuf pBuffer, CycleItemsPacket pValue) {
            pBuffer.writeByte(pValue.direction.ordinal());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof PlaneWorkbenchContainer) {
                PlaneWorkbenchContainer workbenchContainer = (PlaneWorkbenchContainer)patt0$temp;
                workbenchContainer.cycleItems(this.direction);
            }
        });
    }

    public static enum Direction {
        CRAFTING_LEFT,
        CRAFTING_RIGHT;

    }
}

