/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.data;

import io.redspace.pvp_flagging.core.PlayerFlagManager;
import io.redspace.pvp_flagging.core.PvpZoneManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber
public class PvpDataStorage
extends SavedData {
    public static PvpDataStorage INSTANCE;

    public static void init(DimensionDataStorage dimensionDataStorage) {
        if (dimensionDataStorage != null) {
            INSTANCE = (PvpDataStorage)dimensionDataStorage.computeIfAbsent(new SavedData.Factory(PvpDataStorage::new, PvpDataStorage::load), "pvp_flagging");
        }
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.put("PvpZoneManager", (Tag)PvpZoneManager.INSTANCE.serializeNBT(null));
        compoundTag.put("PlayerFlagManager", (Tag)PlayerFlagManager.INSTANCE.serializeNBT(null));
        return compoundTag;
    }

    public static PvpDataStorage load(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("PvpZoneManager")) {
            PvpZoneManager.INSTANCE.deserializeNBT(null, (CompoundTag)tag.get("PvpZoneManager"));
        }
        if (tag.contains("PlayerFlagManager")) {
            PlayerFlagManager.INSTANCE.deserializeNBT(null, (CompoundTag)tag.get("PlayerFlagManager"));
        }
        return new PvpDataStorage();
    }

    @SubscribeEvent
    public static void onServerStartedEvent(ServerStartedEvent event) {
        PvpDataStorage.init(event.getServer().overworld().getDataStorage());
    }
}

