/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging;

import com.mojang.logging.LogUtils;
import io.redspace.pvp_flagging.client.FlagIndicatorOverlay;
import io.redspace.pvp_flagging.config.PvpConfig;
import io.redspace.pvp_flagging.core.PlayerFlagManager;
import io.redspace.pvp_flagging.core.PvpZoneManager;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import org.slf4j.Logger;

@Mod(value="pvp_flagging")
public class PvpFlagging {
    public static final String MODID = "pvp_flagging";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PvpFlagging(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(PvpFlagging::init);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)PvpConfig.SERVER.SPEC, String.format("%s-server.toml", MODID));
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PvpConfig.CLIENT.SPEC, String.format("%s-client.toml", MODID));
    }

    public static void init(FMLCommonSetupEvent event) {
        PlayerFlagManager.init();
        PvpZoneManager.init();
    }

    @EventBusSubscriber(modid="pvp_flagging", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerOverlays(RegisterGuiLayersEvent event) {
            event.registerBelowAll(ResourceLocation.fromNamespaceAndPath((String)PvpFlagging.MODID, (String)"flag_status_overlay"), (LayeredDraw.Layer)FlagIndicatorOverlay.INSTANCE);
        }
    }
}

