/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class NotesConfigScreen {
    private static final String[] TAG_OPTIONS = new String[]{"All", "None", "Coordinates", "Description", "Important"};

    public static Screen build(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"text.ntf.all_notes"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        Map<String, String> notes = PlayerNoteStorage.getAllNotes();
        Map<String, String> tags = PlayerNoteStorage.getAllTags();
        String selectedFilter = PlayerNoteStorage.getSelectedFilterTag();
        if (!selectedFilter.equals("All")) {
            notes = notes.entrySet().stream().filter(e -> tags.getOrDefault(e.getKey(), "None").equals(selectedFilter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        ConfigCategory notesCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"text.ntf.player_notes"));
        Map<String, String> allNotes = PlayerNoteStorage.getAllNotes();
        notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"text.ntf.filter_tag"), PlayerNoteStorage.getSelectedFilterTag()).setTooltip(new Component[]{Component.translatable((String)"text.ntf.tag_tooltip")}).setSelections(List.of(TAG_OPTIONS)).setSaveConsumer(PlayerNoteStorage::setSelectedFilterTag).build());
        if (allNotes.isEmpty()) {
            notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.translatable((String)"text.ntf.no_notes")).build());
        } else {
            for (Map.Entry entry : allNotes.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
                String player = (String)entry.getKey();
                String note = (String)entry.getValue();
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.literal((String)player), note).setSaveConsumer(newNote -> PlayerNoteStorage.saveNote(player, newNote)).build());
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"text.ntf.assign_tag"), PlayerNoteStorage.getTag(player)).setTooltip(new Component[]{Component.translatable((String)"text.ntf.assign_tag")}).setSelections(List.of(TAG_OPTIONS)).setSaveConsumer(tag -> PlayerNoteStorage.setTag(player, tag)).build());
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"text.ntf.delete"), false).setTooltip(new Component[]{Component.translatable((String)"text.ntf.del_tooltip")}).setSaveConsumer(shouldRemove -> {
                    if (shouldRemove.booleanValue()) {
                        PlayerNoteStorage.removeNote(player);
                    }
                }).build());
            }
        }
        ConfigCategory globalCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"text.ntf.options"));
        globalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"text.ntf.delete_all"), false).setTooltip(new Component[]{Component.translatable((String)"text.ntf.del_all_tooltip")}).setSaveConsumer(shouldClear -> {
            if (shouldClear.booleanValue()) {
                PlayerNoteStorage.clearAllNotes();
            }
        }).build());
        return builder.build();
    }
}

