/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import com.mojang.blaze3d.platform.Window;
import fudge.notenoughcrashes.gui.InitErrorScreen;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import net.minecraft.CrashReport;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntryPointCatcher {
    private static CrashReport crashReport = null;
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes Entry Points");

    public static boolean crashedDuringStartup() {
        return crashReport != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleEntryPointError(Throwable e) {
        crashReport = CrashReport.forThrowable((Throwable)e, (String)"Initializing game");
        crashReport.addCategory("Initialization");
        Minecraft.fillReport(null, null, (String)DetectedVersion.tryDetectVersion().getName(), null, (CrashReport)crashReport);
        CrashUtils.outputClientReport(crashReport);
        Window.checkGlfwError((integer, stringx) -> {});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayInitErrorScreen() {
        try {
            Minecraft.getInstance().setScreen((Screen)new InitErrorScreen(crashReport));
        }
        catch (Throwable t) {
            CrashReport additionalReport = CrashReport.forThrowable((Throwable)t, (String)"Displaying init error screen");
            LOGGER.error("An uncaught exception occured while displaying the init error screen, making normal report instead", t);
            CrashUtils.outputClientReport(additionalReport);
            System.exit(additionalReport.getSaveFile() != null ? -1 : -2);
        }
    }
}

