/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.config.NecConfig;
import fudge.notenoughcrashes.gui.ProblemScreen;
import fudge.notenoughcrashes.mixinhandlers.InGameCatcher;
import fudge.notenoughcrashes.utils.NecLocalization;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrashScreen
extends ProblemScreen {
    @Override
    public ProblemScreen construct(CrashReport report) {
        return new CrashScreen(report);
    }

    public CrashScreen(CrashReport report) {
        super(report);
    }

    @Override
    public void init() {
        super.init();
        Button mainMenuButton = Button.builder((Component)NecLocalization.translatedText("gui.toTitle"), button -> {
            InGameCatcher.crashScreenActive = true;
            Minecraft.getInstance().setScreen((Screen)new TitleScreen());
        }).bounds(this.width / 2 - 155, this.height / 4 + 120 + 12, 150, 20).build();
        if (NecConfig.getCurrent().disableReturnToMainMenu()) {
            mainMenuButton.active = false;
            mainMenuButton.setMessage(NecLocalization.translatedText("notenoughcrashes.gui.disabledByConfig"));
        }
        this.addRenderableWidget((GuiEventListener)mainMenuButton);
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.title"), this.width / 2, this.height / 4 - 40, 0xFFFFFF);
        int textColor = 0xD0D0D0;
        int x = this.width / 2 - 155;
        int y = this.height / 4;
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.summary"), x, y, textColor);
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph1.line1"), x, y += 18, textColor);
        y += 11;
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph2.line1"), x, y += 11, textColor);
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph2.line2"), x, y += 9, textColor);
        this.drawFileNameString(context, y);
        y += 11;
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph3.line1"), x, y += 12, textColor);
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph3.line2"), x, y += 9, textColor);
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph3.line3"), x, y += 9, textColor);
        context.drawString(this.font, NecLocalization.localize("notenoughcrashes.crashscreen.paragraph3.line4"), x, y + 9, textColor);
    }
}

