/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.processor;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.processor.ProcessorHandler;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BaseProcessor
extends StructureProcessor {
    public static final BaseProcessor INSTANCE = new BaseProcessor();
    public static final MapCodec<BaseProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ProcessorHandler.BASE_PROCESSOR.value();
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, StructureTemplate template) {
        if (blockInfoGlobal.state().is(Blocks.COBBLED_DEEPSLATE)) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().mutable().move(Direction.DOWN);
            BlockState currBlockState = levelReader.getBlockState((BlockPos)mutable);
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), this.chooseRandomState(random), blockInfoGlobal.nbt());
            while (mutable.getY() > levelReader.getMinBuildHeight() && mutable.getY() < levelReader.getMaxBuildHeight() && !currBlockState.isSolid()) {
                levelReader.getChunk((BlockPos)mutable).setBlockState((BlockPos)mutable, this.chooseRandomState(random), false);
                mutable.move(Direction.DOWN);
                currBlockState = levelReader.getBlockState((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    public BlockState chooseRandomState(RandomSource random) {
        float v = random.nextFloat();
        if ((double)v > 0.7) {
            return Blocks.POLISHED_DEEPSLATE.defaultBlockState();
        }
        return Blocks.COBBLED_DEEPSLATE.defaultBlockState();
    }
}

