/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MessageJumpToAbilitySectionServerToClient(int entityId, int index, int sectionIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageJumpToAbilitySectionServerToClient> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"message_jump_to_ability_section"));
    public static final StreamCodec<ByteBuf, MessageJumpToAbilitySectionServerToClient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageJumpToAbilitySectionServerToClient::entityId, (StreamCodec)ByteBufCodecs.INT, MessageJumpToAbilitySectionServerToClient::index, (StreamCodec)ByteBufCodecs.INT, MessageJumpToAbilitySectionServerToClient::sectionIndex, MessageJumpToAbilitySectionServerToClient::new);

    public static void handleClient(MessageJumpToAbilitySectionServerToClient packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.entityId());
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                AbilityData data = DataHandler.getData((Entity)living, DataHandler.ABILITY_DATA);
                AbilityType<?, ?> abilityType = data.getAbilityTypesOnEntity(living)[packet.index()];
                Ability<?> instance = data.getAbilityMap().get(abilityType);
                if (instance.isUsing()) {
                    instance.jumpToSection(packet.sectionIndex());
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

