/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class AnimationFWNAttackAI
extends AnimationAI<EntityWroughtnaut> {
    protected float applyKnockback = 1.0f;
    protected float range;
    private final float arc;

    public AnimationFWNAttackAI(EntityWroughtnaut entity, float applyKnockback, float range, float arc) {
        super(entity);
        this.applyKnockback = applyKnockback;
        this.range = range;
        this.arc = arc;
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == EntityWroughtnaut.ATTACK_ANIMATION || animation == EntityWroughtnaut.ATTACK_TWICE_ANIMATION || animation == EntityWroughtnaut.ATTACK_THRICE_ANIMATION;
    }

    @Override
    public void start() {
        super.start();
        if (((EntityWroughtnaut)this.entity).getAnimation() == EntityWroughtnaut.ATTACK_ANIMATION) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_PRE_SWING_1.get(), 1.5f, 1.0f);
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    private boolean shouldFollowUp(float bonusRange) {
        LivingEntity entityTarget = ((EntityWroughtnaut)this.entity).getTarget();
        if (entityTarget != null && entityTarget.isAlive()) {
            Vec3 betweenEntitiesVec;
            Vec3 targetMoveVec = entityTarget.getDeltaMovement();
            boolean targetComingCloser = targetMoveVec.dot(betweenEntitiesVec = ((EntityWroughtnaut)this.entity).position().subtract(entityTarget.position())) > 0.0;
            return ((EntityWroughtnaut)this.entity).targetDistance < this.range + bonusRange || ((EntityWroughtnaut)this.entity).targetDistance < this.range + 5.0f + bonusRange && targetComingCloser;
        }
        return false;
    }

    public void tick() {
        LivingEntity entityTarget = ((EntityWroughtnaut)this.entity).getTarget();
        ((EntityWroughtnaut)this.entity).setDeltaMovement(0.0, ((EntityWroughtnaut)this.entity).getDeltaMovement().y, 0.0);
        if (((EntityWroughtnaut)this.entity).getAnimation() == EntityWroughtnaut.ATTACK_ANIMATION) {
            if (((EntityWroughtnaut)this.entity).getAnimationTick() < 23 && entityTarget != null) {
                ((EntityWroughtnaut)this.entity).lookAt((Entity)entityTarget, 30.0f, 30.0f);
            } else {
                ((EntityWroughtnaut)this.entity).setYRot(((EntityWroughtnaut)this.entity).yRotO);
            }
            if (((EntityWroughtnaut)this.entity).getAnimationTick() == 6) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_CREAK.get(), 0.5f, 1.0f);
            } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 25) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 1.2f, 1.0f);
            } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 27) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_SWING_1.get(), 1.5f, 1.0f);
                List<LivingEntity> entitiesHit = ((EntityWroughtnaut)this.entity).getEntityLivingBaseNearby(this.range, 3.0, this.range, this.range);
                float damage = (float)((EntityWroughtnaut)this.entity).getAttribute(Attributes.ATTACK_DAMAGE).getValue();
                boolean hit = false;
                for (LivingEntity entityHit : entitiesHit) {
                    float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ(), entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingAngle = ((EntityWroughtnaut)this.entity).yBodyRot % 360.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) * (entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) + (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX())) - entityHit.getBbWidth() / 2.0f;
                    if (!(entityHitDistance <= this.range && entityRelativeAngle <= this.arc / 2.0f && entityRelativeAngle >= -this.arc / 2.0f || entityRelativeAngle >= 360.0f - this.arc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.arc / 2.0f)) continue;
                    entityHit.hurt(((EntityWroughtnaut)this.entity).damageSources().mobAttack((LivingEntity)this.entity), damage);
                    if (entityHit.isBlocking()) {
                        entityHit.getUseItem().hurtAndBreak(400, entityHit, LivingEntity.getSlotForHand((InteractionHand)entityHit.getUsedItemHand()));
                    }
                    entityHit.setDeltaMovement(entityHit.getDeltaMovement().x * (double)this.applyKnockback, entityHit.getDeltaMovement().y, entityHit.getDeltaMovement().z * (double)this.applyKnockback);
                    hit = true;
                }
                if (hit) {
                    ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_HIT.get(), 1.0f, 0.5f);
                }
            } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 37 && this.shouldFollowUp(2.5f) && (double)((EntityWroughtnaut)this.entity).getHealthRatio() <= 0.9 && ((EntityWroughtnaut)this.entity).getRandom().nextFloat() < 0.6f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((EntityWroughtnaut)this.entity, EntityWroughtnaut.ATTACK_TWICE_ANIMATION);
            }
        } else if (((EntityWroughtnaut)this.entity).getAnimation() == EntityWroughtnaut.ATTACK_TWICE_ANIMATION) {
            if (((EntityWroughtnaut)this.entity).getAnimationTick() < 7 && entityTarget != null) {
                ((EntityWroughtnaut)this.entity).lookAt((Entity)entityTarget, 30.0f, 30.0f);
            } else {
                ((EntityWroughtnaut)this.entity).setYRot(((EntityWroughtnaut)this.entity).yRotO);
            }
            if (((EntityWroughtnaut)this.entity).getAnimationTick() == 10) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 1.2f, 1.0f);
            } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 12) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_SWING_3.get(), 1.5f, 1.0f);
                List<LivingEntity> entitiesHit = ((EntityWroughtnaut)this.entity).getEntityLivingBaseNearby((double)this.range - 0.3, 3.0, (double)this.range - 0.3, (double)this.range - 0.3);
                float damage = (float)((EntityWroughtnaut)this.entity).getAttribute(Attributes.ATTACK_DAMAGE).getValue();
                boolean hit = false;
                for (LivingEntity entityHit : entitiesHit) {
                    float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ(), entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingAngle = ((EntityWroughtnaut)this.entity).yBodyRot % 360.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) * (entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) + (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()));
                    if (!((double)entityHitDistance <= (double)this.range - 0.3 && entityRelativeAngle <= this.arc / 2.0f && entityRelativeAngle >= -this.arc / 2.0f || entityRelativeAngle >= 360.0f - this.arc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.arc / 2.0f)) continue;
                    entityHit.hurt(((EntityWroughtnaut)this.entity).damageSources().mobAttack((LivingEntity)this.entity), damage);
                    if (entityHit.isBlocking()) {
                        entityHit.getUseItem().hurtAndBreak(400, entityHit, LivingEntity.getSlotForHand((InteractionHand)entityHit.getUsedItemHand()));
                    }
                    entityHit.setDeltaMovement(entityHit.getDeltaMovement().x * (double)this.applyKnockback, entityHit.getDeltaMovement().y, entityHit.getDeltaMovement().z * (double)this.applyKnockback);
                    hit = true;
                }
                if (hit) {
                    ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_HIT.get(), 1.0f, 0.5f);
                }
            } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 23 && this.shouldFollowUp(3.5f) && (double)((EntityWroughtnaut)this.entity).getHealthRatio() <= 0.6 && ((EntityWroughtnaut)this.entity).getRandom().nextFloat() < 0.6f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((EntityWroughtnaut)this.entity, EntityWroughtnaut.ATTACK_THRICE_ANIMATION);
            }
        } else if (((EntityWroughtnaut)this.entity).getAnimation() == EntityWroughtnaut.ATTACK_THRICE_ANIMATION) {
            if (((EntityWroughtnaut)this.entity).getAnimationTick() == 1) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_PRE_SWING_3.get(), 1.2f, 1.0f);
            }
            if (((EntityWroughtnaut)this.entity).getAnimationTick() < 22 && entityTarget != null) {
                ((EntityWroughtnaut)this.entity).lookAt((Entity)entityTarget, 30.0f, 30.0f);
            } else {
                ((EntityWroughtnaut)this.entity).setYRot(((EntityWroughtnaut)this.entity).yRotO);
            }
            if (((EntityWroughtnaut)this.entity).getAnimationTick() == 20) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_WHOOSH.get(), 1.2f, 0.9f);
            } else if (((EntityWroughtnaut)this.entity).getAnimationTick() == 24) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_GRUNT_3.get(), 1.5f, 1.13f);
                ((EntityWroughtnaut)this.entity).move(MoverType.SELF, new Vec3(Math.cos(Math.toRadians(((EntityWroughtnaut)this.entity).getYRot() + 90.0f)), 0.0, Math.sin(Math.toRadians(((EntityWroughtnaut)this.entity).getYRot() + 90.0f))));
                List<LivingEntity> entitiesHit = ((EntityWroughtnaut)this.entity).getEntityLivingBaseNearby((double)this.range + 0.2, 3.0, (double)this.range + 0.2, (double)this.range + 0.2);
                float damage = (float)((EntityWroughtnaut)this.entity).getAttribute(Attributes.ATTACK_DAMAGE).getValue();
                boolean hit = false;
                for (LivingEntity entityHit : entitiesHit) {
                    float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) * (entityHit.getZ() - ((EntityWroughtnaut)this.entity).getZ()) + (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()) * (entityHit.getX() - ((EntityWroughtnaut)this.entity).getX()));
                    if (!((double)entityHitDistance <= (double)this.range + 0.2)) continue;
                    entityHit.hurt(((EntityWroughtnaut)this.entity).damageSources().mobAttack((LivingEntity)this.entity), damage);
                    if (entityHit.isBlocking()) {
                        entityHit.getUseItem().hurtAndBreak(400, entityHit, LivingEntity.getSlotForHand((InteractionHand)entityHit.getUsedItemHand()));
                    }
                    entityHit.setDeltaMovement(entityHit.getDeltaMovement().x * (double)this.applyKnockback, entityHit.getDeltaMovement().y, entityHit.getDeltaMovement().z * (double)this.applyKnockback);
                    hit = true;
                }
                if (hit) {
                    ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_AXE_HIT.get(), 1.0f, 0.5f);
                }
            }
        }
    }
}

