/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynResourceGenerator<T extends DynamicResourcePack>
implements PreparableReloadListener {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    public final T dynamicPack;
    protected final String modId;
    private boolean hasBeenInitialized;
    private static final Set<DynResourceGenerator<?>> GENERATORS = new HashSet();

    protected DynResourceGenerator(T pack, String modId) {
        this.dynamicPack = pack;
        this.modId = modId;
        ((DynamicResourcePack)this.dynamicPack).addNamespaces(this.additionalNamespaces().toArray(new String[0]));
        ((DynamicResourcePack)this.dynamicPack).addNamespaces(modId);
        ((DynamicResourcePack)this.dynamicPack).registerPack();
        GENERATORS.add(this);
    }

    public final void register() {
    }

    public abstract Logger getLogger();

    public Collection<String> additionalNamespaces() {
        return List.of();
    }

    public T getPack() {
        return this.dynamicPack;
    }

    public boolean shouldClearOnReload() {
        return this.runsOnEveryReload();
    }

    public boolean runsOnEveryReload() {
        return true;
    }

    @Deprecated(forRemoval=true)
    public void regenerateDynamicAssets(ResourceManager manager) {
        ArrayList tasks = new ArrayList();
        this.regenerateDynamicAssets(tasks::add);
        Stopwatch watch = Stopwatch.createStarted();
        List<CompletableFuture> futures = tasks.stream().map(task -> CompletableFuture.supplyAsync(() -> {
            ResourceSink localSink = new ResourceSink(this.modId, this.dynamicPack.packId());
            task.accept(manager, localSink);
            return localSink;
        }, this.getExecutors())).toList();
        CompletableFuture<Void> allDone = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            HashMultimap tags = HashMultimap.create();
            allDone.join();
            for (CompletableFuture future : futures) {
                ResourceSink sink = (ResourceSink)future.join();
                sink.resources.forEach((arg_0, arg_1) -> this.dynamicPack.addBytes(arg_0, arg_1));
                sink.notClearable.forEach(arg_0 -> this.dynamicPack.markNotClearable(arg_0));
                for (Map.Entry<TagKey<?>, SimpleTagBuilder> e : sink.tags.entrySet()) {
                    tags.put(e.getKey(), (Object)e.getValue());
                }
            }
            for (TagKey key : tags.keySet()) {
                Iterator it = tags.get((Object)key).iterator();
                if (!it.hasNext()) continue;
                SimpleTagBuilder tag = (SimpleTagBuilder)((Object)it.next());
                while (it.hasNext()) {
                    tag.merge((SimpleTagBuilder)((Object)it.next()));
                }
                ((DynamicResourcePack)this.dynamicPack).addTag(tag, key.registry());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Task failed", e);
        }
        this.getLogger().info("Generated runtime {} for pack {} ({}) in: {} ms{} (multithreaded)", (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)this.dynamicPack.packId(), (Object)this.modId, (Object)watch.elapsed().toMillis(), (Object)(((DynamicResourcePack)this.dynamicPack).generateDebugResources ? " (debug resource dump on)" : ""));
    }

    @NotNull
    protected ExecutorService getExecutors() {
        return EXECUTOR_SERVICE;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
    }

    @NotNull
    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller workerProfiler, ProfilerFiller mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        if (PlatHelper.isModLoadingValid()) {
            this.onNormalReload(manager);
        } else {
            Moonlight.LOGGER.error("Cowardly refusing generate assets for a broken mod state");
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void onNormalReload(ResourceManager manager) {
    }

    protected final void onEarlyReload(EarlyPackReloadEvent event) {
        if (event.type() == ((DynamicResourcePack)this.dynamicPack).packType) {
            try {
                this.reloadResources(event.manager());
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("An error occurred while trying to generate dynamic assets for {}:", this.dynamicPack, (Object)e);
            }
        }
    }

    protected final void reloadResources(ResourceManager manager) {
        boolean wasFirstReload = false;
        if (!this.hasBeenInitialized) {
            wasFirstReload = true;
            this.hasBeenInitialized = true;
            T t = this.dynamicPack;
            if (t instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t;
                tp.addPackLogo();
            }
        }
        if (this.runsOnEveryReload() || wasFirstReload) {
            this.regenerateDynamicAssets(manager);
        }
    }

    @Nullable
    protected abstract PackRepository getRepository();

    @Deprecated(forRemoval=true)
    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    @Deprecated(forRemoval=true)
    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res) {
        Optional resource = manager.getResource(res);
        return resource.filter(value -> !value.sourcePackId().equals(this.dynamicPack.packId())).isPresent();
    }

    @Deprecated(forRemoval=true)
    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    @Deprecated(forRemoval=true)
    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    @Deprecated(forRemoval=true)
    public void addSimilarJsonResource(ResourceManager manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        ResourceLocation fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.getPath().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        ResourceLocation newRes = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = new String(resource.data, StandardCharsets.UTF_8);
            fullText = textTransform.apply(fullText);
            ((DynamicResourcePack)this.dynamicPack).addBytes(newRes, fullText.getBytes());
        }
    }

    @Deprecated(forRemoval=true)
    public void addResourceIfNotPresent(ResourceManager manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            ((DynamicResourcePack)this.dynamicPack).addResource(resource);
        }
    }

    @ApiStatus.Internal
    public static void clearAfterReload(PackType targetType) {
        HashSet packs = new HashSet();
        for (DynResourceGenerator<?> g : GENERATORS) {
            if (((DynamicResourcePack)g.dynamicPack).packType != targetType || !g.shouldClearOnReload()) continue;
            packs.add(g.dynamicPack);
        }
        for (DynamicResourcePack p : packs) {
            p.clearNonStatic();
        }
    }

    @ApiStatus.Internal
    public static void clearBeforeReload(PackType targetType) {
        HashSet packs = new HashSet();
        for (DynResourceGenerator<?> g : GENERATORS) {
            if (((DynamicResourcePack)g.dynamicPack).packType != targetType || !g.shouldClearOnReload()) continue;
            packs.add(g.dynamicPack);
        }
        for (DynamicResourcePack p : packs) {
            p.clearAllContent();
        }
    }

    static {
        MoonlightEventsHelper.addListener(earlyPackReloadEvent -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            for (DynResourceGenerator<?> gen : GENERATORS) {
                if (((DynamicResourcePack)gen.dynamicPack).packType != earlyPackReloadEvent.type()) continue;
                gen.onEarlyReload((EarlyPackReloadEvent)earlyPackReloadEvent);
            }
            Moonlight.LOGGER.info("Generated runtime resources for {} packs in a total of: {} ms", (Object)GENERATORS.size(), (Object)stopwatch.elapsed().toMillis());
        }, EarlyPackReloadEvent.class);
    }
}

