/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.misc.RollingBuffer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleTrailEmitter {
    private final double idealSpacing;
    private final int maxParticlesPerTick;
    private final double minSpeed;
    private Vec3 lastEmittedPos = null;
    private double accumulatedDistanceSinceLastParticle;
    private final RollingBuffer<Vec3> previousVelocities = new RollingBuffer(3);
    private final RollingBuffer<Vec3> previousPositions = new RollingBuffer(3);

    private ParticleTrailEmitter(Builder builder) {
        this.idealSpacing = builder.idealSpacing;
        this.maxParticlesPerTick = builder.maxParticlesPerTick;
        this.minSpeed = builder.minSpeed;
        this.accumulatedDistanceSinceLastParticle = -this.idealSpacing;
    }

    public void tick(Entity obj, ParticleOptions particleOptions) {
        this.tick(obj, particleOptions, true);
    }

    public void tick(Entity obj, ParticleOptions particleOptions, boolean followSpeed) {
        this.tick(obj, (Vec3 position, Vec3 velocity) -> {
            Level level = obj.level();
            if (followSpeed) {
                level.addParticle(particleOptions, position.x, position.y, position.z, velocity.x, velocity.y, velocity.z);
            } else {
                level.addParticle(particleOptions, position.x, position.y, position.z, 0.0, 0.0, 0.0);
            }
        });
    }

    public void tick(Entity obj, Emitter emitter) {
        Vec3 currentVel = obj.getDeltaMovement();
        Vec3 currentPos = obj.position();
        this.previousVelocities.push(currentVel);
        this.previousPositions.push(currentPos);
        if (this.previousPositions.size() < 2) {
            return;
        }
        Vec3 prevPos = this.previousPositions.get(0);
        Vec3 currentPosBuf = this.previousPositions.get(1);
        Vec3 prevVel = this.previousVelocities.get(0);
        double segmentLength = prevPos.distanceTo(currentPosBuf);
        if (segmentLength < this.minSpeed) {
            return;
        }
        float h = obj.getBbHeight() / 2.0f;
        double totalAvailable = this.accumulatedDistanceSinceLastParticle + segmentLength;
        int particlesToEmit = (int)(totalAvailable / this.idealSpacing);
        if ((particlesToEmit = Math.min(particlesToEmit, this.maxParticlesPerTick)) == 0) {
            this.accumulatedDistanceSinceLastParticle += segmentLength;
            return;
        }
        Vec3 lastPos = this.lastEmittedPos != null ? this.lastEmittedPos : prevPos;
        double spacingSum = 0.0;
        for (int i = 1; i <= particlesToEmit; ++i) {
            double targetDist = (double)i * this.idealSpacing - this.accumulatedDistanceSinceLastParticle;
            double t = targetDist / segmentLength;
            t = Math.max(0.0, Math.min(1.0, t));
            Vec3 emitPos = prevPos.lerp(currentPosBuf, t);
            Vec3 emitVel = prevVel.lerp(this.previousVelocities.get(1), t);
            Vec3 direction = emitPos.subtract(lastPos).normalize();
            Vec3 perfectPos = lastPos.add(direction.scale(this.idealSpacing)).add(0.0, (double)h, 0.0);
            emitter.emitParticle(perfectPos, emitVel);
            lastPos = perfectPos;
            spacingSum += this.idealSpacing;
        }
        this.lastEmittedPos = lastPos;
        this.accumulatedDistanceSinceLastParticle = totalAvailable - spacingSum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double idealSpacing = 0.5;
        private int maxParticlesPerTick = 5;
        private double minSpeed = 0.0;

        public Builder spacing(double spacing) {
            this.idealSpacing = spacing;
            return this;
        }

        public Builder maxParticlesPerTick(int max) {
            this.maxParticlesPerTick = max;
            return this;
        }

        public Builder minSpeed(double speed) {
            this.minSpeed = speed;
            return this;
        }

        public ParticleTrailEmitter build() {
            return new ParticleTrailEmitter(this);
        }
    }

    public static interface Emitter {
        public void emitParticle(Vec3 var1, Vec3 var2);
    }
}

