/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class TeleportHelper {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;

    private TeleportHelper() {
    }

    public static boolean teleportCitizen(AbstractEntityCitizen citizen, Level world, BlockPos location) {
        if (citizen == null || world == null || world.isClientSide) {
            return false;
        }
        BlockPos spawnPoint = EntityUtils.getSpawnPoint(world, location);
        if (spawnPoint == null) {
            return false;
        }
        if (citizen.getCitizenSleepHandler().isAsleep()) {
            citizen.getCitizenSleepHandler().onWakeUp();
        }
        citizen.getNavigation().stop();
        citizen.stopRiding();
        citizen.moveTo((double)spawnPoint.getX() + 0.5, spawnPoint.getY(), (double)spawnPoint.getZ() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        return true;
    }

    public static void homeTeleport(@NotNull ServerPlayer player) {
        IColony colony = IColonyManager.getInstance().getIColonyByOwner(player.getCommandSenderWorld(), (Player)player);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.colonyidnotfound", new Object[0]).sendTo(new Player[]{player});
            return;
        }
        TeleportHelper.colonyTeleport(player, colony);
    }

    public static void surfaceTeleport(@NotNull ServerPlayer player) {
        BlockPos position = BlockPos.containing((double)player.getX(), (double)250.0, (double)player.getZ());
        position = BlockPosUtil.findLand(position, (Level)player.serverLevel());
        ChunkPos chunkpos = new ChunkPos(position);
        player.serverLevel().getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getId());
        player.stopRiding();
        if (player.isSleeping()) {
            player.stopSleepInBed(true, true);
        }
        player.teleportTo(player.serverLevel(), (double)position.getX(), (double)position.getY() + 2.0, (double)position.getZ(), player.getYRot(), player.getXRot());
    }

    public static void colonyTeleportByID(@NotNull ServerPlayer player, int id, ResourceKey<Level> dimension) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(id, dimension);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.colonyidnotfound", new Object[0]).sendTo(new Player[]{player});
            return;
        }
        TeleportHelper.colonyTeleport(player, colony);
    }

    public static void colonyTeleport(@NotNull ServerPlayer player, @NotNull IColony colony) {
        BlockPos position = colony.getBuildingManager().getTownHall() != null ? colony.getBuildingManager().getTownHall().getPosition() : colony.getCenter();
        ServerLevel world = player.getServer().getLevel(colony.getDimension());
        position = BlockPosUtil.findAround((Level)world, position, 5, 5, (predWorld, predPos) -> predWorld.getBlockState(predPos).isAir() && predWorld.getBlockState(predPos.above()).isAir());
        if (position == null) {
            return;
        }
        ChunkPos chunkpos = new ChunkPos(position);
        world.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getId());
        player.stopRiding();
        if (player.isSleeping()) {
            player.stopSleepInBed(true, true);
        }
        player.teleportTo(world, (double)position.getX(), (double)position.getY(), (double)position.getZ(), player.getYRot(), player.getXRot());
        MessageUtils.format("com.minecolonies.command.teleport.success", colony.getName()).sendTo(new Player[]{player});
    }
}

