/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.WarehouseModule;
import com.minecolonies.core.tileentities.TileEntityRack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWareHouse
extends AbstractTileEntityWareHouse {
    private long lastNotification = 0L;

    public TileEntityWareHouse(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityWareHouse>)((BlockEntityType)MinecoloniesTileEntities.WAREHOUSE.get()), pos, state);
        this.inWarehouse = true;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate, int count) {
        int totalCount = 0;
        if (this.getBuilding() != null) {
            for (BlockPos pos : this.getBuilding().getContainers()) {
                TileEntityRack rack;
                BlockEntity entity;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.level, pos) || !((entity = this.getLevel().getBlockEntity(pos)) instanceof TileEntityRack) || (rack = (TileEntityRack)entity).isEmpty() || (totalCount += rack.getItemCount(itemStackSelectionPredicate)) < count) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT) {
        return this.hasMatchingItemStackInWarehouse(itemStack, count, ignoreNBT, 0);
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        int totalCountFound = 0 - leftOver;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.level, pos) || !((entity = this.getLevel().getBlockEntity(pos)) instanceof TileEntityRack) || ((AbstractTileEntityRack)entity).isEmpty() || (totalCountFound += ((AbstractTileEntityRack)entity).getCount(itemStack, ignoreDamage, ignoreNBT)) < count) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT, int leftOver) {
        return this.hasMatchingItemStackInWarehouse(itemStack, count, ignoreNBT, true, leftOver);
    }

    @Override
    @NotNull
    public List<Tuple<ItemStack, BlockPos>> getMatchingItemStacksInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<Tuple<ItemStack, BlockPos>> found = new ArrayList<Tuple<ItemStack, BlockPos>>();
        if (this.getBuilding() != null) {
            for (BlockPos pos : this.getBuilding().getContainers()) {
                TileEntityRack rack;
                BlockEntity entity;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.level, pos) || !((entity = this.getLevel().getBlockEntity(pos)) instanceof TileEntityRack) || (rack = (TileEntityRack)entity).isEmpty() || rack.getItemCount(itemStackSelectionPredicate) <= 0) continue;
                for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)rack.getInventory(), itemStackSelectionPredicate)) {
                    found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                }
            }
        }
        return found;
    }

    @Override
    public void dumpInventoryIntoWareHouse(@NotNull InventoryCitizen inventoryCitizen) {
        for (int i = 0; i < inventoryCitizen.getSlots(); ++i) {
            ItemStack stack = inventoryCitizen.getStackInSlot(i);
            if (ItemStackUtils.isEmpty(stack)) continue;
            @Nullable AbstractTileEntityRack chest = this.getRackForStack(stack);
            if (chest == null) {
                if (this.level.getGameTime() - this.lastNotification > 6000L) {
                    this.lastNotification = this.level.getGameTime();
                    if (this.getBuilding().getBuildingLevel() == this.getBuilding().getMaxBuildingLevel()) {
                        if (((WarehouseModule)this.getBuilding().getModule(BuildingModules.WAREHOUSE_OPTIONS)).getStorageUpgrade() < 3) {
                            MessageUtils.format("com.minecolonies.coremod.warehouse.full.level5", new Object[0]).sendTo(this.getColony()).forAllPlayers();
                        } else {
                            MessageUtils.format("com.minecolonies.coremod.warehouse.full.max", new Object[0]).sendTo(this.getColony()).forAllPlayers();
                        }
                    } else {
                        MessageUtils.format("com.minecolonies.coremod.warehouse.full", new Object[0]).sendTo(this.getColony()).forAllPlayers();
                    }
                }
                return;
            }
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((IItemHandler)inventoryCitizen, i, chest.getItemHandlerCap());
        }
    }

    public AbstractTileEntityRack getRackForStack(ItemStack stack) {
        AbstractTileEntityRack rack = this.getPositionOfChestWithItemStack(stack);
        if (rack == null && (rack = this.getPositionOfChestWithSimilarItemStack(stack)) == null) {
            rack = this.searchMostEmptyRack();
        }
        return rack;
    }

    @Nullable
    private AbstractTileEntityRack getPositionOfChestWithItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            AbstractTileEntityRack rack;
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.level, pos) || !((entity = this.getLevel().getBlockEntity(pos)) instanceof AbstractTileEntityRack) || (rack = (AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !rack.hasItemStack(stack, 1, true)) continue;
            return rack;
        }
        return null;
    }

    @Nullable
    private AbstractTileEntityRack getPositionOfChestWithSimilarItemStack(ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            AbstractTileEntityRack rack;
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.level, pos) || !((entity = this.getLevel().getBlockEntity(pos)) instanceof AbstractTileEntityRack) || (rack = (AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !rack.hasSimilarStack(stack)) continue;
            return rack;
        }
        return null;
    }

    @Nullable
    private AbstractTileEntityRack searchMostEmptyRack() {
        int freeSlots = 0;
        TileEntityRack emptiestChest = null;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            BlockEntity entity = this.getLevel().getBlockEntity(pos);
            if (!(entity instanceof TileEntityRack)) continue;
            TileEntityRack rack = (TileEntityRack)entity;
            if (rack.isEmpty()) {
                return rack;
            }
            int tempFreeSlots = rack.getFreeSlots();
            if (tempFreeSlots <= freeSlots) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = rack;
        }
        return emptiestChest;
    }
}

