/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.registry.IResearchEffectRegistry;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import com.minecolonies.api.research.factories.IGlobalResearchFactory;
import com.minecolonies.api.research.registry.IResearchRequirementRegistry;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.research.GlobalResearch;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchFactory
implements IGlobalResearchFactory {
    @Override
    @NotNull
    public TypeToken<GlobalResearch> getFactoryOutputType() {
        return TypeToken.of(GlobalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public IGlobalResearch getNewInstance(ResourceLocation id, ResourceLocation branch, ResourceLocation parent, TranslatableContents desc, int universityLevel, int sortOrder, ResourceLocation iconTexture, ItemStack iconStack, TranslatableContents subtitle, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        return new GlobalResearch(id, branch, parent, desc, universityLevel, sortOrder, iconTexture, iconStack, subtitle, onlyChild, hidden, autostart, instant, immutable);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull IGlobalResearch research) {
        CompoundTag compound = new CompoundTag();
        compound.putString("parent", research.getParent().toString());
        compound.putString("id", research.getId().toString());
        compound.putString("branch", research.getBranch().toString());
        compound.putString("name", research.getName().getKey());
        compound.putInt("depth", research.getDepth());
        compound.putInt("sort", research.getSortOrder());
        compound.putBoolean("onlyChild", research.hasOnlyChild());
        compound.putString("icon_tex", research.getIconTextureResourceLocation().toString());
        compound.putString("icon_is", String.valueOf(BuiltInRegistries.ITEM.getKey((Object)research.getIconItemStack().getItem())) + ":" + research.getIconItemStack().getCount());
        compound.putString("subtitle", research.getSubtitle().getKey());
        compound.putBoolean("instant", research.isInstant());
        compound.putBoolean("autostart", research.isAutostart());
        compound.putBoolean("immutable", research.isImmutable());
        compound.putBoolean("hidden", research.isHidden());
        compound.put("cost", Utils.serializeCodecMess(SizedIngredient.FLAT_CODEC.listOf(), provider, research.getCostList()));
        @NotNull ListTag reqTagList = research.getResearchRequirement().stream().map(req -> {
            CompoundTag reqCompound = new CompoundTag();
            reqCompound.putString("requirement-type", req.getRegistryEntry().getRegistryName().toString());
            reqCompound.put("requirement-item", (Tag)req.writeToNBT());
            return reqCompound;
        }).collect(NBTUtils.toListNBT());
        compound.put("requirements", (Tag)reqTagList);
        @NotNull ListTag effectTagList = research.getEffects().stream().map(eff -> {
            CompoundTag effectCompound = new CompoundTag();
            effectCompound.putString("effect-type", eff.getRegistryEntry().getRegistryName().toString());
            effectCompound.put("effect-item", (Tag)eff.writeToNBT());
            return effectCompound;
        }).collect(NBTUtils.toListNBT());
        compound.put("effects", (Tag)effectTagList);
        @NotNull ListTag childTagList = research.getChildren().stream().map(child -> {
            CompoundTag childCompound = new CompoundTag();
            childCompound.putString("child", child.toString());
            return childCompound;
        }).collect(NBTUtils.toListNBT());
        compound.put("hasResearchedChild", (Tag)childTagList);
        return compound;
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ResourceLocation parent = ResourceLocation.parse((String)nbt.getString("parent"));
        ResourceLocation id = ResourceLocation.parse((String)nbt.getString("id"));
        ResourceLocation branch = ResourceLocation.parse((String)nbt.getString("branch"));
        TranslatableContents desc = new TranslatableContents(nbt.getString("name"), null, TranslatableContents.NO_ARGS);
        int depth = nbt.getInt("depth");
        int sortOrder = nbt.getInt("sort");
        boolean onlyChild = nbt.getBoolean("onlyChild");
        ResourceLocation iconTexture = ResourceLocation.parse((String)nbt.getString("icon_tex"));
        String[] iconStackParts = nbt.getString("icon_is").split(":");
        ItemStack iconStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(iconStackParts[0], iconStackParts[1])));
        iconStack.setCount(Integer.parseInt(iconStackParts[2]));
        TranslatableContents subtitle = new TranslatableContents(nbt.getString("subtitle"), null, TranslatableContents.NO_ARGS);
        boolean instant = nbt.getBoolean("instant");
        boolean autostart = nbt.getBoolean("autostart");
        boolean immutable = nbt.getBoolean("immutable");
        boolean hidden = nbt.getBoolean("hidden");
        IGlobalResearch research = this.getNewInstance(id, branch, parent, desc, depth, sortOrder, iconTexture, iconStack, subtitle, onlyChild, hidden, autostart, instant, immutable);
        List costs = (List)Utils.deserializeCodecMess(SizedIngredient.FLAT_CODEC.listOf(), provider, nbt.get("cost"));
        research.addCosts(costs);
        NBTUtils.streamCompound(nbt.getList("requirements", 10)).forEach(compound -> research.addRequirement(Objects.requireNonNull((ResearchRequirementEntry)IResearchRequirementRegistry.getInstance().get(ResourceLocation.tryParse((String)compound.getString("requirement-type")))).readFromNBT(compound.getCompound("requirement-item"))));
        NBTUtils.streamCompound(nbt.getList("effects", 10)).forEach(compound -> research.addEffect(Objects.requireNonNull((ResearchEffectEntry)IResearchEffectRegistry.getInstance().get(ResourceLocation.tryParse((String)compound.getString("effect-type")))).readFromNBT(compound.getCompound("effect-item"))));
        NBTUtils.streamCompound(nbt.getList("hasResearchedChild", 10)).forEach(compound -> research.addChild(ResourceLocation.parse((String)compound.getString("child"))));
        return research;
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, IGlobalResearch input, RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeResourceLocation(input.getParent());
        packetBuffer.writeResourceLocation(input.getId());
        packetBuffer.writeResourceLocation(input.getBranch());
        packetBuffer.writeUtf(input.getName().getKey());
        packetBuffer.writeVarInt(input.getDepth());
        packetBuffer.writeVarInt(input.getSortOrder());
        packetBuffer.writeBoolean(input.hasOnlyChild());
        Utils.serializeCodecMess(packetBuffer, input.getIconItemStack());
        packetBuffer.writeResourceLocation(input.getIconTextureResourceLocation());
        packetBuffer.writeUtf(input.getSubtitle().getKey());
        packetBuffer.writeBoolean(input.isInstant());
        packetBuffer.writeBoolean(input.isAutostart());
        packetBuffer.writeBoolean(input.isImmutable());
        packetBuffer.writeBoolean(input.isHidden());
        Utils.serializeCodecMess(SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), packetBuffer, input.getCostList());
        packetBuffer.writeVarInt(input.getResearchRequirement().size());
        for (IResearchRequirement iResearchRequirement : input.getResearchRequirement()) {
            packetBuffer.writeResourceLocation(iResearchRequirement.getRegistryEntry().getRegistryName());
            packetBuffer.writeNbt((Tag)iResearchRequirement.writeToNBT());
        }
        packetBuffer.writeVarInt(input.getEffects().size());
        for (IResearchEffect iResearchEffect : input.getEffects()) {
            packetBuffer.writeResourceLocation(iResearchEffect.getRegistryEntry().getRegistryName());
            packetBuffer.writeNbt((Tag)iResearchEffect.writeToNBT());
        }
        packetBuffer.writeVarInt(input.getChildren().size());
        for (ResourceLocation resourceLocation : input.getChildren()) {
            packetBuffer.writeResourceLocation(resourceLocation);
        }
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        ResourceLocation parent = buffer.readResourceLocation();
        ResourceLocation id = buffer.readResourceLocation();
        ResourceLocation branch = buffer.readResourceLocation();
        TranslatableContents desc = new TranslatableContents(buffer.readUtf(), null, TranslatableContents.NO_ARGS);
        int depth = buffer.readVarInt();
        int sortOrder = buffer.readVarInt();
        boolean hasOnlyChild = buffer.readBoolean();
        ItemStack iconStack = Utils.deserializeCodecMess(buffer);
        ResourceLocation iconTexture = buffer.readResourceLocation();
        TranslatableContents subtitle = new TranslatableContents(buffer.readUtf(), null, TranslatableContents.NO_ARGS);
        boolean instant = buffer.readBoolean();
        boolean autostart = buffer.readBoolean();
        boolean immutable = buffer.readBoolean();
        boolean hidden = buffer.readBoolean();
        IGlobalResearch research = this.getNewInstance(id, branch, parent, desc, depth, sortOrder, iconTexture, iconStack, subtitle, hasOnlyChild, hidden, autostart, instant, immutable);
        List costs = (List)Utils.deserializeCodecMess(SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), buffer);
        research.addCosts(costs);
        int reqCount = buffer.readVarInt();
        for (int i = 0; i < reqCount; ++i) {
            ResourceLocation reqId = buffer.readResourceLocation();
            research.addRequirement(Objects.requireNonNull((ResearchRequirementEntry)IResearchRequirementRegistry.getInstance().get(reqId)).readFromNBT(buffer.readNbt()));
        }
        int effectCount = buffer.readVarInt();
        for (int i = 0; i < effectCount; ++i) {
            ResourceLocation effectId = buffer.readResourceLocation();
            research.addEffect(Objects.requireNonNull((ResearchEffectEntry)IResearchEffectRegistry.getInstance().get(effectId)).readFromNBT(buffer.readNbt()));
        }
        int childCount = buffer.readVarInt();
        for (int i = 0; i < childCount; ++i) {
            research.addChild(buffer.readResourceLocation());
        }
        return research;
    }

    @Override
    public short getSerializationId() {
        return 28;
    }
}

