/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AlternateBuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDINGS_LIST = "building-list";
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private final Map<String, Integer> buildings = new HashMap<String, Integer>();

    public AlternateBuildingResearchRequirement add(String building, int level) {
        if (this.buildings.containsKey(building)) {
            this.buildings.put(building, this.buildings.get(building) + level);
        } else {
            this.buildings.put(building, level);
        }
        return this;
    }

    public AlternateBuildingResearchRequirement() {
    }

    public AlternateBuildingResearchRequirement(CompoundTag nbt) {
        ListTag buildingsNBT = nbt.getList(TAG_BUILDINGS_LIST, 10);
        for (int i = 0; i < buildingsNBT.size(); ++i) {
            CompoundTag indNBT = buildingsNBT.getCompound(i);
            this.buildings.put(indNBT.getString(TAG_BUILDING_NAME), indNBT.getInt(TAG_BUILDING_LVL));
        }
    }

    public Map<String, Integer> getBuildings() {
        return this.buildings;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        for (Map.Entry<String, Integer> requirement : this.buildings.entrySet()) {
            if (!colony.hasBuilding(requirement.getKey(), requirement.getValue(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent getDesc() {
        MutableComponent requirementList = Component.translatableEscape((String)"", (Object[])new Object[0]);
        Iterator<Map.Entry<String, Integer>> iterator = this.buildings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> kvp = iterator.next();
            requirementList.append((Component)Component.translatableEscape((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{Component.translatableEscape((String)("block.minecolonies.blockhut" + kvp.getKey()), (Object[])new Object[0]), kvp.getValue()}));
            if (!iterator.hasNext()) continue;
            requirementList.append((Component)Component.translatableEscape((String)"com.minecolonies.coremod.research.requirement.building.or", (Object[])new Object[0]));
        }
        return requirementList;
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return (ResearchRequirementEntry)ModResearchRequirements.alternateBuildingResearchRequirement.get();
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag buildingsNBT = new ListTag();
        for (Map.Entry<String, Integer> build : this.buildings.entrySet()) {
            CompoundTag indNBT = new CompoundTag();
            indNBT.putString(TAG_BUILDING_NAME, build.getKey());
            indNBT.putInt(TAG_BUILDING_LVL, build.getValue().intValue());
            buildingsNBT.add((Object)indNBT);
        }
        nbt.put(TAG_BUILDINGS_LIST, (Tag)buildingsNBT);
        return nbt;
    }
}

