/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class TransferItemsRequestMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"transfer_items_request", TransferItemsRequestMessage::new);
    private final ItemStack itemStack;
    private final int quantity;
    private final boolean attemptResolve;

    public TransferItemsRequestMessage(@NotNull IBuildingView building, ItemStack itemStack, int quantity, boolean attemptResolve) {
        super(TYPE, building);
        this.itemStack = itemStack;
        this.quantity = quantity;
        this.attemptResolve = attemptResolve;
    }

    protected TransferItemsRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.itemStack = Utils.deserializeCodecMess(buf);
        this.quantity = buf.readInt();
        this.attemptResolve = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        Utils.serializeCodecMess(buf, this.itemStack);
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.attemptResolve);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        int amountToTake;
        if (this.quantity <= 0) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        boolean isCreative = player.isCreative();
        Map<ItemStorage, ItemStorage> previousContent = null;
        if (isCreative) {
            amountToTake = this.quantity;
        } else {
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).debugInventories.get()).booleanValue()) {
                previousContent = InventoryUtils.getAllItemsForProviders(building.getTileEntity(), new IItemHandler[]{new InvWrapper((Container)player.getInventory())});
            }
            amountToTake = Math.min(this.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack, true, true)));
        }
        ItemStack remainingItemStack = ItemStack.EMPTY;
        int tempAmount = amountToTake;
        int i = 0;
        while ((double)i < Math.max(1.0, Math.ceil((double)amountToTake / (double)this.itemStack.getMaxStackSize()))) {
            ItemStack itemStackToTake = this.itemStack.copy();
            int insertAmount = Math.min(this.itemStack.getMaxStackSize(), tempAmount);
            itemStackToTake.setCount(insertAmount);
            tempAmount -= insertAmount;
            remainingItemStack = InventoryUtils.addItemStackToProviderWithResult(building.getTileEntity(), itemStackToTake);
            if (!remainingItemStack.isEmpty()) {
                tempAmount += remainingItemStack.getCount();
                break;
            }
            ++i;
        }
        if (!ItemStackUtils.isEmpty(remainingItemStack)) {
            MessageUtils.format((Component)Component.translatableEscape((String)"entity.builder.inventoryfull", (Object[])new Object[]{remainingItemStack.getDisplayName()}).withStyle(ChatFormatting.RED)).sendTo(new Player[]{player});
        }
        if (ItemStackUtils.isEmpty(remainingItemStack) || ItemStackUtils.getSize(remainingItemStack) != amountToTake) {
            building.getTileEntity().setChanged();
        }
        if (ItemStackUtils.isEmpty(remainingItemStack) || ItemStackUtils.getSize(remainingItemStack) != amountToTake) {
            if (!isCreative) {
                ItemStack itemsTaken;
                for (int amountToRemoveFromPlayer = amountToTake - tempAmount; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                    int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.getInventory()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack, true, true));
                    itemsTaken = player.getInventory().removeItem(slot, amountToRemoveFromPlayer);
                }
            }
            if (this.attemptResolve) {
                building.overruleNextOpenRequestWithStack(this.itemStack);
            }
        }
        if (!isCreative && previousContent != null && ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).debugInventories.get()).booleanValue()) {
            InventoryUtils.doStorageSetsMatch(previousContent, InventoryUtils.getAllItemsForProviders(building.getTileEntity(), new IItemHandler[]{new InvWrapper((Container)player.getInventory())}), true);
        }
    }
}

