/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.Stash;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ChangeDeliveryPriorityMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"change_delivery_priority", ChangeDeliveryPriorityMessage::new);
    private boolean up;

    public ChangeDeliveryPriorityMessage(@NotNull IBuildingView building, boolean up) {
        super(TYPE, building);
        this.up = up;
    }

    protected ChangeDeliveryPriorityMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.up = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.up);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        if (building != null && building.hasModule(WorkerBuildingModule.class) || building instanceof Stash) {
            if (this.up) {
                building.alterPickUpPriority(1);
            } else {
                building.alterPickUpPriority(-1);
            }
            building.markDirty();
        }
    }
}

