/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.fields.registry.FieldDataManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewFieldsUpdateMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_fields_update", ColonyViewFieldsUpdateMessage::new);
    private final int colonyId;
    private final ResourceKey<Level> dimension;
    private final Map<IField, IField> fields;

    public ColonyViewFieldsUpdateMessage(@NotNull IColony colony, @NotNull Set<IField> fields) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.fields = new HashMap<IField, IField>();
        fields.forEach(field -> this.fields.put((IField)field, (IField)field));
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeInt(this.fields.size());
        for (IField field : this.fields.keySet()) {
            RegistryFriendlyByteBuf fieldBuffer = FieldDataManager.fieldToBuffer(field, buf.registryAccess());
            fieldBuffer.resetReaderIndex();
            buf.writeByteArray(fieldBuffer.array());
        }
    }

    protected ColonyViewFieldsUpdateMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.fields = new HashMap<IField, IField>();
        int fieldCount = buf.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            IField parsedField = FieldDataManager.bufferToField(new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray()), buf.registryAccess()));
            this.fields.put(parsedField, parsedField);
        }
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyView view = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (view != null) {
            HashSet<IField> updatedFields = new HashSet<IField>();
            view.getFields(field -> true).forEach(existingField -> {
                if (this.fields.containsKey(existingField)) {
                    RegistryFriendlyByteBuf copyBuffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.level().registryAccess());
                    this.fields.get(existingField).serialize(copyBuffer);
                    existingField.deserialize(copyBuffer);
                    updatedFields.add((IField)existingField);
                }
            });
            updatedFields.addAll(this.fields.keySet());
            view.handleColonyFieldViewUpdateMessage(updatedFields);
        } else {
            Log.getLogger().error("Colony view does not exist for ID #{}", (Object)this.colonyId);
        }
    }
}

