/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SaveStructureNBTMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"save_structure_nbt", SaveStructureNBTMessage::new);
    private static final String TAG_MILLIS = "millies";
    public static final String TAG_SCHEMATIC = "schematic";
    private final CompoundTag compoundNBT;
    private final String fileName;

    public SaveStructureNBTMessage(CompoundTag CompoundNBT, String fileName) {
        super(TYPE);
        this.fileName = fileName;
        this.compoundNBT = CompoundNBT;
    }

    protected SaveStructureNBTMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf((ByteBuf)buf), buf.registryAccess());
        CompoundTag compoundNBT = null;
        String fileName = null;
        try (ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)buffer);){
            CompoundTag wrapperCompound = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            compoundNBT = wrapperCompound.getCompound(TAG_SCHEMATIC);
            fileName = wrapperCompound.getString(TAG_MILLIS);
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Structure too big to be processed", (Throwable)e);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
        this.compoundNBT = compoundNBT;
        this.fileName = fileName;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        CompoundTag wrapperCompound = new CompoundTag();
        wrapperCompound.putString(TAG_MILLIS, this.fileName);
        wrapperCompound.put(TAG_SCHEMATIC, (Tag)this.compoundNBT);
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf((ByteBuf)buf), buf.registryAccess());
        try (ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buffer);){
            NbtIo.writeCompressed((CompoundTag)wrapperCompound, (OutputStream)stream);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        if (this.compoundNBT != null) {
            String packName = Minecraft.getInstance().getUser().getName().toLowerCase(Locale.US);
            RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").setBlueprintFuture(StructurePacks.storeBlueprint((String)packName, (CompoundTag)this.compoundNBT, (Path)Minecraft.getInstance().gameDirectory.toPath().resolve("blueprints").resolve(Minecraft.getInstance().getUser().getName().toLowerCase(Locale.US)).resolve("scans").resolve(this.fileName), (HolderLookup.Provider)player.registryAccess()));
            player.displayClientMessage((Component)Component.translatableEscape((String)"Scan successfully saved as %s", (Object[])new Object[]{this.fileName}), false);
        }
    }
}

