/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.network.messages.client.StopMusicMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PlayAudioMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"play_audio", PlayAudioMessage::new);
    private final ResourceLocation soundEvent;
    private final SoundSource category;

    public PlayAudioMessage(SoundEvent event) {
        this(event, SoundSource.MUSIC);
    }

    public PlayAudioMessage(SoundEvent event, SoundSource category) {
        super(TYPE);
        this.soundEvent = event.getLocation();
        this.category = category;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.category.ordinal());
        buf.writeResourceLocation(this.soundEvent);
    }

    protected PlayAudioMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.category = SoundSource.values()[buf.readVarInt()];
        this.soundEvent = buf.readResourceLocation();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void onExecute(IPayloadContext ctxIn, Player player) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(this.soundEvent, this.category, 1.0f, 1.0f, RandomSource.create(), false, 0, SoundInstance.Attenuation.NONE, player.getX(), player.getY(), player.getZ(), true));
    }

    public static void sendToAll(IColony col, boolean important, boolean stop, PlayAudioMessage ... messages) {
        List<Player> players = important ? col.getImportantMessageEntityPlayers() : col.getMessagePlayerEntities();
        for (Player player : players) {
            if (stop) {
                new StopMusicMessage().sendToPlayer((ServerPlayer)player);
            }
            for (PlayAudioMessage pam : messages) {
                pam.sendToPlayer((ServerPlayer)player);
            }
        }
    }
}

