/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.component.Timestamp;
import com.minecolonies.core.client.gui.WindowSchematicAnalyzer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ItemScanAnalyzer
extends AbstractItemWithPosSelector {
    public static String TEMP_SCAN = "selection.blueprint";
    private static final int TIMEOUT_DELAY = 2400;
    private static BlockPos lastPos = BlockPos.ZERO;
    private static BlockPos lastPos2 = BlockPos.ZERO;
    public static Blueprint blueprint = null;

    public ItemScanAnalyzer(@NotNull String name, Item.Properties properties) {
        super(properties.durability(0).setNoRepair().rarity(Rarity.UNCOMMON).component((Supplier)ModDataComponents.POS_SELECTION, (Object)AbstractItemWithPosSelector.PosSelection.EMPTY));
    }

    public ItemScanAnalyzer(Item.Properties properties) {
        super(properties);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        this.checkTimeout(player.getMainHandItem(), worldIn);
        boolean result = super.canAttackBlock(state, worldIn, pos, player);
        this.openAreaBox(player.getMainHandItem());
        return result;
    }

    public InteractionResult useOn(UseOnContext context) {
        this.checkTimeout(context.getItemInHand(), context.getLevel());
        InteractionResult result = super.useOn(context);
        this.openAreaBox(context.getItemInHand());
        return result;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        this.checkTimeout(playerIn.getItemInHand(handIn), worldIn);
        return super.use(worldIn, playerIn, handIn);
    }

    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        if (worldIn.isClientSide) {
            if (!(start == null || end == null || lastPos.equals((Object)start) && lastPos2.equals((Object)end))) {
                lastPos = start;
                lastPos2 = end;
                AbstractItemWithPosSelector.PosSelection data = AbstractItemWithPosSelector.PosSelection.readFromItemStack((ItemStack)itemStack);
                blueprint = ItemScanAnalyzer.saveStructure(worldIn, playerIn, AABB.encapsulatingFullBlocks((BlockPos)data.startPos().orElse(null), (BlockPos)data.endPos().orElse(null)));
            }
            new WindowSchematicAnalyzer().open();
        }
        return InteractionResult.SUCCESS;
    }

    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.scanAnalyzer;
    }

    private void openAreaBox(ItemStack tool) {
        AbstractItemWithPosSelector.PosSelection component = AbstractItemWithPosSelector.PosSelection.readFromItemStack((ItemStack)tool);
        BlockPos start = component.startPos().orElse(null);
        BlockPos end = component.endPos().orElse(null);
        if (start != null && end != null) {
            RenderingCache.queue((String)"analyzer", (BoxPreviewData)new BoxPreviewData(start, end, Optional.empty()));
        }
    }

    protected void checkTimeout(ItemStack stack, Level level) {
        if (stack == null || level == null) {
            return;
        }
        Timestamp.updateItemStack(stack, component -> {
            if (component.hasTime() && level.getGameTime() - component.time() > 2400L) {
                AbstractItemWithPosSelector.PosSelection.EMPTY.writeToItemStack(stack);
            }
            return new Timestamp(level.getGameTime());
        });
    }

    public static Blueprint saveStructure(Level world, Player player, AABB box) {
        if (box.getXsize() * box.getYsize() * box.getZsize() > (double)((Integer)((ServerConfiguration)Structurize.getConfig().getServer()).schematicBlockLimit.get()).intValue()) {
            player.displayClientMessage((Component)Component.translatableEscape((String)"item.sceptersteel.toobig", (Object[])new Object[]{((ServerConfiguration)Structurize.getConfig().getServer()).schematicBlockLimit.get()}), false);
            return null;
        }
        String fileName = TEMP_SCAN;
        BlockPos zero = new BlockPos((int)box.minX, (int)box.minY, (int)box.minZ);
        Blueprint bp = BlueprintUtil.createBlueprint((Level)world, (BlockPos)zero, (boolean)false, (short)((short)(box.getXsize() + 1.0)), (short)((short)(box.getYsize() + 1.0)), (short)((short)(box.getZsize() + 1.0)), (String)fileName, Optional.empty());
        return bp;
    }
}

