/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.items.component.RallyData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.WindowBannerRallyGuards;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.core.colony.requestsystem.locations.StaticLocation;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBannerRallyGuards
extends AbstractItemMinecolonies {
    public ItemBannerRallyGuards(Item.Properties properties) {
        super("banner_rally_guards", properties.stacksTo(1).durability(0));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack banner = context.getPlayer().getItemInHand(context.getHand());
        RallyData rallyData = RallyData.readFromItemStack(banner);
        if (ItemBannerRallyGuards.isGuardBuilding(context.getLevel(), context.getClickedPos())) {
            if (context.getLevel().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            IGuardBuilding building = ItemBannerRallyGuards.getGuardBuilding(context.getLevel(), context.getClickedPos());
            if (!building.getColony().getPermissions().hasPermission(player, Action.RALLY_GUARDS)) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            building.getColony().writeToItemStack(banner);
            ILocation location = building.getLocation();
            if (ItemBannerRallyGuards.removeGuardTowerAtLocation(banner, location.getInDimensionLocation())) {
                MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.deselected", building.getSchematicName(), location.toString()).sendTo(player);
            } else {
                rallyData.withPosAddition(location.getInDimensionLocation()).writeToItemStack(banner);
                MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.selected", building.getSchematicName(), location.toString()).sendTo(player);
            }
        } else if (context.getLevel().getBlockState(context.getClickedPos()).getBlock().equals(ModBlocks.blockColonyBanner)) {
            if (context.getLevel().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            IColony colony = ItemBannerRallyGuards.getColony(banner, context.getLevel());
            if (colony != null && colony.getPermissions().hasPermission(player, Action.RALLY_GUARDS)) {
                if (colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.STANDARD) <= 0.0) {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated.needsresearch", new Object[0]).sendTo(context.getPlayer());
                    return InteractionResult.FAIL;
                }
                rallyData.withActive(true).writeToItemStack(banner);
                int numGuards = ItemBannerRallyGuards.broadcastPlayerToRally(banner, context.getPlayer().getCommandSenderWorld(), new StaticLocation(context.getClickedPos(), (ResourceKey<Level>)context.getLevel().dimension()));
                if (numGuards > 0) {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated", numGuards).sendTo(context.getPlayer());
                } else {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated.noguards", new Object[0]).sendTo(context.getPlayer());
                }
            }
        } else {
            this.handleRightClick(banner, context.getPlayer());
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated(forRemoval=true, since="1.21")
    @Nullable
    private static IColony getColony(ItemStack stack, Level world) {
        return ColonyId.readColonyFromItemStack(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack banner = playerIn.getItemInHand(handIn);
        this.handleRightClick(banner, playerIn);
        return InteractionResultHolder.success((Object)banner);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        if (!player.getCommandSenderWorld().isClientSide()) {
            RallyData.updateItemStack(item, rally -> rally.withActive(false));
            ItemBannerRallyGuards.broadcastPlayerToRally(item, player.getCommandSenderWorld(), null);
        }
        return super.onDroppedByPlayer(item, player);
    }

    private void handleRightClick(ItemStack banner, Player playerIn) {
        if (playerIn.isShiftKeyDown() && !playerIn.getCommandSenderWorld().isClientSide()) {
            ItemBannerRallyGuards.toggleBanner(banner, playerIn);
        } else if (!playerIn.isShiftKeyDown() && playerIn.getCommandSenderWorld().isClientSide()) {
            if (ItemBannerRallyGuards.getGuardTowerLocations(banner).isEmpty()) {
                MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", new Object[0]).sendTo(playerIn);
            } else {
                new WindowBannerRallyGuards(banner).open();
            }
        }
    }

    public static void toggleBanner(ItemStack banner, Player playerIn) {
        if (playerIn.getCommandSenderWorld().isClientSide()) {
            Log.getLogger().error("Tried to run server-side function #toggleBanner() on the client-side!");
            return;
        }
        RallyData rallyData = RallyData.readFromItemStack(banner);
        if (rallyData == null) {
            Log.getLogger().error("Compound corrupt, missing TAG_RALLIED_GUARDTOWERS");
            return;
        }
        if (rallyData.towers().isEmpty()) {
            rallyData.withActive(false).writeToItemStack(banner);
            MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", new Object[0]).sendTo(playerIn);
        } else if (rallyData.active()) {
            rallyData.withActive(false).writeToItemStack(banner);
            ItemBannerRallyGuards.broadcastPlayerToRally(banner, playerIn.getCommandSenderWorld(), null);
            MessageUtils.format("item.minecolonies.banner_rally_guards.deactivated", new Object[0]).sendTo(playerIn);
        } else {
            rallyData.withActive(true).writeToItemStack(banner);
            IColony colony = ItemBannerRallyGuards.getColony(banner, playerIn.level());
            if (colony != null && colony.getPermissions().hasPermission(playerIn, Action.RALLY_GUARDS)) {
                int numGuards = ItemBannerRallyGuards.broadcastPlayerToRally(banner, playerIn.getCommandSenderWorld(), playerIn == null ? null : new EntityLocation(playerIn.getUUID()));
                if (numGuards > 0) {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated", numGuards).sendTo(playerIn);
                } else {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated.noguards", new Object[0]).sendTo(playerIn);
                }
            }
        }
    }

    public static int broadcastPlayerToRally(ItemStack banner, Level worldIn, @Nullable ILocation rallyLocation) {
        if (worldIn.isClientSide()) {
            Log.getLogger().error("Tried to run server-side function #broadcastPlayerToRally() on the client-side!");
            return 0;
        }
        @Nullable ILocation rallyTarget = null;
        rallyTarget = !ItemBannerRallyGuards.isActive(banner) || rallyLocation == null ? null : rallyLocation;
        int numGuards = 0;
        for (BlockPos guardTowerLocation : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            IBuilding building = ItemBannerRallyGuards.getColony(banner, worldIn).getBuildingManager().getBuilding(guardTowerLocation);
            if (!(building instanceof IGuardBuilding)) continue;
            IGuardBuilding iGuardBuilding = (IGuardBuilding)building;
            iGuardBuilding.setRallyLocation(rallyTarget);
            numGuards += building.getAllAssignedCitizen().size();
        }
        return numGuards;
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static List<BlockPos> getGuardTowerLocations(ItemStack banner) {
        return RallyData.readFromItemStack(banner).towers();
    }

    public static boolean isGuardBuilding(Level worldIn, BlockPos position) {
        if (worldIn.isClientSide()) {
            return IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.dimension(), position) instanceof AbstractBuildingGuards.View;
        }
        return IColonyManager.getInstance().getBuilding(worldIn, position) instanceof IGuardBuilding;
    }

    @Nullable
    public static AbstractBuildingGuards.View getGuardBuildingView(Level worldIn, BlockPos position) {
        if (!worldIn.isClientSide()) {
            Log.getLogger().error("Tried to run client-side function #getGuardBuildingView() on the server-side!");
            return null;
        }
        return ItemBannerRallyGuards.isGuardBuilding(worldIn, position) ? (AbstractBuildingGuards.View)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.dimension(), position) : null;
    }

    @Nullable
    public static IGuardBuilding getGuardBuilding(Level worldIn, BlockPos position) {
        if (worldIn.isClientSide()) {
            Log.getLogger().error("Tried to run server-side function #getGuardBuilding() on the client-side!");
            return null;
        }
        return ItemBannerRallyGuards.isGuardBuilding(worldIn, position) ? (IGuardBuilding)IColonyManager.getInstance().getBuilding(worldIn, position) : null;
    }

    public static List<Pair<BlockPos, AbstractBuildingGuards.View>> getGuardTowerViews(ItemStack banner, Level level) {
        LinkedList<Pair> result = new LinkedList<Pair>();
        for (BlockPos guardTowerLocation : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            result.add(new Pair((Object)guardTowerLocation, (Object)ItemBannerRallyGuards.getGuardBuildingView(level, guardTowerLocation)));
        }
        return ImmutableList.copyOf(result);
    }

    public boolean isActiveForGuardTower(ItemStack banner, IGuardBuilding guardTower) {
        if (!ItemBannerRallyGuards.isActive(banner)) {
            return false;
        }
        for (BlockPos existingTower : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            if (!existingTower.equals((Object)guardTower.getLocation().getInDimensionLocation())) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static boolean isActive(ItemStack stack) {
        return RallyData.readFromItemStack(stack).active();
    }

    public static boolean removeGuardTowerAtLocation(ItemStack banner, BlockPos guardTowerLocation) {
        RallyData modified;
        RallyData old = RallyData.readFromItemStack(banner);
        if (old != (modified = old.withPosRemoval(guardTowerLocation))) {
            modified.writeToItemStack(banner);
        }
        return old != modified;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return ItemBannerRallyGuards.isActive(stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"com.minecolonies.coremod.item.bannerrallyguards.gui", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        tooltip.add((Component)guiHint);
        MutableComponent rallyHint = Component.translatableEscape((String)"com.minecolonies.coremod.item.bannerrallyguards.rally", (Object[])new Object[0]);
        rallyHint.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        tooltip.add((Component)rallyHint);
        List<BlockPos> guardTowerPositions = ItemBannerRallyGuards.getGuardTowerLocations(stack);
        if (guardTowerPositions.isEmpty()) {
            MutableComponent emptyTooltip = Component.translatableEscape((String)"com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", (Object[])new Object[0]);
            emptyTooltip.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
            tooltip.add((Component)emptyTooltip);
        } else {
            MutableComponent numGuardTowers = Component.translatableEscape((String)"com.minecolonies.coremod.item.bannerrallyguards.tooltip", (Object[])new Object[]{guardTowerPositions.size()});
            numGuardTowers.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)numGuardTowers);
        }
        super.appendHoverText(stack, ctx, tooltip, flagIn);
    }
}

