/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.generation.CustomRecipeAndLootTableProvider;
import com.minecolonies.core.generation.CustomRecipeProvider;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultSifterCraftingProvider
extends CustomRecipeAndLootTableProvider {
    public static final String SIFTER = ModJobs.SIFTER_ID.getPath();
    private final Map<Item, List<SifterMeshDetails>> inputs = new HashMap<Item, List<SifterMeshDetails>>();

    public DefaultSifterCraftingProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
        this.inputs.put(Items.DIRT, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(71)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).setWeight(25)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_SAPLING).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_SAPLING).setWeight(1)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(28)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_SAPLING).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_SAPLING).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARROT).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.POTATO).setWeight(1)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.025f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARROT).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.POTATO).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PUMPKIN_SEEDS).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MELON_SEEDS).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEETROOT_SEEDS).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_SAPLING).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ACACIA_SAPLING).setWeight(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.035f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).setWeight(25)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_SAPLING).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARROT).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.POTATO).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PUMPKIN_SEEDS).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MELON_SEEDS).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEETROOT_SEEDS).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_SAPLING).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ACACIA_SAPLING).setWeight(5))))));
        this.inputs.put(Items.GRAVEL, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(85)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_NUGGET).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(60)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_NUGGET).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.025f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(46)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_NUGGET).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LAPIS_LAZULI).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.035f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(40)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_NUGGET).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LAPIS_LAZULI).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(2))))));
        this.inputs.put(Items.SAND, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(95)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUGAR_CANE).setWeight(2)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(85)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUGAR_CANE).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_NUGGET).setWeight(5)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.025f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(60)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUGAR_CANE).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_NUGGET).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COCOA_BEANS).setWeight(10)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.035f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(40)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUGAR_CANE).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_NUGGET).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COCOA_BEANS).setWeight(15))))));
        this.inputs.put(Items.SOUL_SAND, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(90)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).setWeight(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(70)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE_DUST).setWeight(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.025f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE_DUST).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLAZE_POWDER).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MAGMA_CREAM).setWeight(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.lootTable().withPool(LootPool.lootPool().setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.035f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(40)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.QUARTZ).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE_DUST).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLAZE_POWDER).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MAGMA_CREAM).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PLAYER_HEAD).setWeight(5))))));
    }

    @NotNull
    public String getName() {
        return "SifterCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        for (Map.Entry<Item, List<SifterMeshDetails>> inputEntry : this.inputs.entrySet()) {
            for (SifterMeshDetails mesh : inputEntry.getValue()) {
                String name = mesh.getName() + "/" + BuiltInRegistries.ITEM.getKey((Object)inputEntry.getKey()).getPath();
                List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops(this.provider, (Holder<LootTable>)Holder.direct((Object)mesh.getLootTable().build()));
                Stream loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().sorted(Comparator.comparing(ItemStack::getCount).reversed().thenComparing(ItemStack::getDescriptionId)).map(ItemStack::getItem));
                this.recipe(SIFTER, "custom", name).inputs(Stream.of(new ItemStorage(new ItemStack((ItemLike)inputEntry.getKey())), new ItemStorage(new ItemStack((ItemLike)mesh.getMesh()), true, false)).collect(Collectors.toList())).secondaryOutputs(Stream.concat(Stream.of(mesh.getMesh()), loot).map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + name)).minBuildingLevel(mesh.getMinBuildingLevel()).build(consumer);
            }
        }
        this.mesh(consumer, ModJobs.FLETCHER_ID, (ItemLike)Items.STRING, (ItemLike)ModItems.sifterMeshString, ResearchConstants.SIFTER_STRING);
        this.mesh(consumer, ModJobs.STONEMASON_ID, (ItemLike)Items.FLINT, (ItemLike)ModItems.sifterMeshFlint, ResearchConstants.SIFTER_FLINT);
        this.mesh(consumer, ModJobs.BLACKSMITH_ID, (ItemLike)Items.IRON_INGOT, (ItemLike)ModItems.sifterMeshIron, ResearchConstants.SIFTER_IRON);
        this.mesh(consumer, ModJobs.MECHANIC_ID, (ItemLike)Items.DIAMOND, (ItemLike)ModItems.sifterMeshDiamond, ResearchConstants.SIFTER_DIAMOND);
    }

    private void mesh(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer, @NotNull ResourceLocation job, @NotNull ItemLike input, @NotNull ItemLike output, @NotNull ResourceLocation research) {
        this.recipe(job.getPath(), "crafting", BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath()).inputs(List.of(new ItemStorage(new ItemStack(input)))).result(new ItemStack(output)).minResearchId(research).showTooltip(true).build(consumer);
    }

    @Override
    @NotNull
    protected List<LootTableProvider.SubProviderEntry> registerTables() {
        return List.of(new LootTableProvider.SubProviderEntry(provider -> builder -> {
            for (Map.Entry<Item, List<SifterMeshDetails>> inputEntry : this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + BuiltInRegistries.ITEM.getKey((Object)inputEntry.getKey()).getPath();
                    builder.accept(DefaultSifterCraftingProvider.table(new ResourceLocation("minecolonies", "recipes/" + name)), mesh.getLootTable());
                }
            }
        }, LootContextParamSets.ALL_PARAMS));
    }

    private static class SifterMeshDetails {
        private final String name;
        private final Item mesh;
        private final int minBuildingLevel;
        private final LootTable.Builder lootTable;

        public SifterMeshDetails(@NotNull Item mesh, int minBuildingLevel, @NotNull LootTable.Builder lootTable) {
            this.name = BuiltInRegistries.ITEM.getKey((Object)mesh).getPath().replace("sifter_mesh_", "");
            this.mesh = mesh;
            this.minBuildingLevel = minBuildingLevel;
            this.lootTable = lootTable;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Item getMesh() {
            return this.mesh;
        }

        public int getMinBuildingLevel() {
            return this.minBuildingLevel;
        }

        @NotNull
        public LootTable.Builder getLootTable() {
            return this.lootTable;
        }
    }
}

