/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.loot.EntityInBiomeTag;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.api.loot.ResearchUnlocked;
import com.minecolonies.api.research.util.ResearchConstants;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class DefaultFishermanLootProvider
implements LootTableSubProvider {
    private static Field weightField = null;

    public DefaultFishermanLootProvider(@NotNull HolderLookup.Provider provider) {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> generator) {
        this.registerStandardLoot(generator);
        this.registerBonusLoot(generator);
    }

    private void registerStandardLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> generator) {
        generator.accept(ModLootTables.FISHING, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(ModLootTables.FISHING_JUNK).setWeight(10).setQuality(-2)).add(NestedLootTable.lootTableReference(ModLootTables.FISHING_TREASURE).setWeight(5).setQuality(2).when((LootItemCondition.Builder)new AnyOfCondition.Builder(new LootItemCondition.Builder[]{EntityInBiomeTag.of((TagKey<Biome>)BiomeTags.IS_OCEAN), ResearchUnlocked.effect(ResearchConstants.FISH_TREASURE)}))).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(ModLootTables.FISHING_FISH).setWeight(85).setQuality(-1))));
        generator.accept(ModLootTables.FISHING_JUNK, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.FISHING_JUNK).setWeight(1))));
        generator.accept(ModLootTables.FISHING_TREASURE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.FISHING_TREASURE).setWeight(1))));
        generator.accept(ModLootTables.FISHING_FISH, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.FISHING_FISH).setWeight(1))));
    }

    private void registerBonusLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> generator) {
        boolean skillBonus = true;
        boolean spongeWeight = true;
        int shardWeight = 25;
        int crystalWeight = 25;
        LootTable.Builder noBonus = LootTable.lootTable();
        LootTable.Builder level3 = DefaultFishermanLootProvider.makeLoot(1000, LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).setWeight(25).setQuality(1), LootItem.lootTableItem((ItemLike)Items.PRISMARINE_CRYSTALS).setWeight(25).setQuality(1));
        LootTable.Builder level45 = DefaultFishermanLootProvider.makeLoot(1000, LootItem.lootTableItem((ItemLike)Items.SPONGE).setWeight(1).setQuality(1), LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).setWeight(25).setQuality(1), LootItem.lootTableItem((ItemLike)Items.PRISMARINE_CRYSTALS).setWeight(25).setQuality(1));
        generator.accept(ModLootTables.FISHERMAN_BONUS.get(1), noBonus);
        generator.accept(ModLootTables.FISHERMAN_BONUS.get(2), noBonus);
        generator.accept(ModLootTables.FISHERMAN_BONUS.get(3), level3);
        generator.accept(ModLootTables.FISHERMAN_BONUS.get(4), level45);
        generator.accept(ModLootTables.FISHERMAN_BONUS.get(5), level45);
    }

    private static LootTable.Builder makeLoot(int emptyWeight, LootPoolSingletonContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.lootPool();
        for (LootPoolSingletonContainer.Builder<?> entry : entries) {
            pool.add(entry);
            emptyWeight -= DefaultFishermanLootProvider.getWeightForEntry(entry);
        }
        pool.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(emptyWeight));
        return LootTable.lootTable().withPool(pool);
    }

    private static int getWeightForEntry(@NotNull LootPoolSingletonContainer.Builder<?> entry) {
        if (weightField == null) {
            try {
                weightField = LootPoolSingletonContainer.Builder.class.getDeclaredField("weight");
                weightField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return weightField.getInt(entry);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

