/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.AbstractResearchProvider;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.util.ResearchConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class DefaultResearchProvider
extends AbstractResearchProvider {
    private static final ResourceLocation CIVIL = new ResourceLocation("minecolonies", "civilian");
    private static final ResourceLocation COMBAT = new ResourceLocation("minecolonies", "combat");
    private static final ResourceLocation TECH = new ResourceLocation("minecolonies", "technology");
    private static final ResourceLocation UNLOCK = new ResourceLocation("minecolonies", "unlockable");

    public DefaultResearchProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    @Override
    public Collection<AbstractResearchProvider.ResearchBranch> getResearchBranchCollection() {
        ArrayList<AbstractResearchProvider.ResearchBranch> branches = new ArrayList<AbstractResearchProvider.ResearchBranch>();
        branches.add(new AbstractResearchProvider.ResearchBranch(CIVIL).setTranslatedBranchName("Civilian").setBranchTimeMultiplier(1.0).setBranchSortOrder(50));
        branches.add(new AbstractResearchProvider.ResearchBranch(COMBAT).setTranslatedBranchName("Combat").setBranchTimeMultiplier(1.0).setBranchSortOrder(100));
        branches.add(new AbstractResearchProvider.ResearchBranch(TECH).setTranslatedBranchName("Technology").setBranchTimeMultiplier(1.0).setBranchSortOrder(150));
        branches.add(new AbstractResearchProvider.ResearchBranch(UNLOCK).setTranslatedBranchName("Unlockables").setBranchTimeMultiplier(0.0).setBranchSortOrder(200).setBranchType(ResearchBranchType.UNLOCKABLES).setHidden(true));
        return branches;
    }

    @Override
    public Collection<AbstractResearchProvider.ResearchEffect> getResearchEffectCollection() {
        ArrayList<AbstractResearchProvider.ResearchEffect> effects = new ArrayList<AbstractResearchProvider.ResearchEffect>();
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARCHER_ARMOR).setTranslatedName("Archer Armor +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARCHER_DAMAGE).setTranslatedName("Archer Damage +%s").setLevels(new double[]{0.5, 1.0, 1.5, 2.0, 4.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARMOR_DURABILITY).setTranslatedName("Guard Armor +%3$s%% Durability").setLevels(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BLOCK_ATTACKS).setTranslatedName("Knight Shield Blocking Chance +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BLOCK_BREAK_SPEED).setTranslatedName("Citizen Block Break Speed +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BLOCK_PLACE_SPEED).setTranslatedName("Citizen Block Place Speed +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.CITIZEN_CAP).setTranslatedName("Max Citizens to %2$s").setLevels(new double[]{25.0, 50.0, 100.0, 150.0, 500.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.CITIZEN_INV_SLOTS).setTranslatedName("Citizen Inventory +%s Slots").setLevels(new double[]{9.0, 18.0, 27.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.DOUBLE_ARROWS).setTranslatedName("Archer Multishot +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MECHANIC_ENHANCED_GATES).setTranslatedName("Gates Gain +100% Raider Swarm Resistance").setLevels(new double[]{5.0, 15.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FARMING).setTranslatedName("Farmers Harvest +%3$s%% Crops").setLevels(new double[]{0.1, 0.25, 0.5, 0.75, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FLEEING_DAMAGE).setTranslatedName("Guards Take -%3$s%% Damage When Fleeing").setLevels(new double[]{0.2, 0.3, 0.4, 0.75}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FLEEING_SPEED).setTranslatedName("Fleeing Guards Gain Swiftness %2$s").setLevels(new double[]{1.0, 2.0, 3.0, 5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.GROWTH).setTranslatedName("Child Growth Rate +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.HAPPINESS).setTranslatedName("Citizen Happiness +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.15, 0.2, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SATLIMIT).setTranslatedName("Healing Saturation Min %s").setLevels(new double[]{-0.5, -1.0, -1.5, -2.0, -5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.HEALTH_BOOST).setTranslatedName("Citizen HP +%s").setLevels(new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 20.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.LEVELING).setTranslatedName("Citizen XP Growth +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MELEE_ARMOR).setTranslatedName("Knights Armor +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MELEE_DAMAGE).setTranslatedName("Knight Damage +%s").setLevels(new double[]{0.5, 1.0, 1.5, 2.0, 4.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MINIMUM_STOCK).setTranslatedName("Buildings Can Minimum Stock %3$s%% More").setLevels(new double[]{0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MORE_ORES).setTranslatedName("Miners Find +%3$s%% More Ores").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PODZOL_CHANCE).setTranslatedName("Composters Get +%3$s%% More Podzol").setLevels(new double[]{1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RECIPES).setTranslatedName("Workers Can Learn +%3$s%% More Recipes").setLevels(new double[]{0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.REGENERATION).setTranslatedName("Citizen Regeneration +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SATURATION).setTranslatedName("Citizen Saturation Per Meal +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.TEACHING).setTranslatedName("XP Gain When Studying +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.TOOL_DURABILITY).setTranslatedName("Citizen Tools +%3$s%% Durability").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 0.9}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.WALKING).setTranslatedName("Citizen Walk Speed +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.15, 0.25}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.WORK_LONGER).setTranslatedName("Citizen Work Day +%sH").setLevels(new double[]{1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RESURRECT_CHANCE).setTranslatedName("Improve Resurrection Chance by +%3$s%%").setLevels(new double[]{0.01, 0.03}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.GRAVE_DECAY_BONUS).setTranslatedName("Citizen Graves Take %s More Minutes to Decay").setLevels(new double[]{2.0, 5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARCHER_USE_ARROWS).setTranslatedName("Archers Use Arrows For +2 Damage"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.DRUID_USE_POTIONS).setTranslatedName("Druids request Magic Potions to unlock new Abilities"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.CRUSHING_11).setTranslatedName("Crusher Recipes Cost -50%"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.KNIGHT_TAUNT).setTranslatedName("Knights Force Mobs to Target Them"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FIRE_RES).setTranslatedName("Miners Have Fire and Lava Immunity"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARROW_PIERCE).setTranslatedName("Archers Gain Piercing II"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLANTATION_LARGE).setTranslatedName("Plantations Unlock 1 Additional Field"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLANTATION_JUNGLE).setTranslatedName("Plantations Unlock Fields For: Bamboo, Cocoa and Vines"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLANTATION_SEA).setTranslatedName("Plantations Unlock Fields For: Kelp, Seagrass and Sea pickles"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLANTATION_EXOTIC).setTranslatedName("Plantations Unlock Fields For: Glowberries"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLANTATION_NETHER).setTranslatedName("Plantations Unlock Fields For: Crimson/Warped fungi, roots and vines"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BEEKEEP_2).setTranslatedName("Beekeepers Can Harvest Both Honey Bottles and Combs at Once"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RAILS).setTranslatedName("Citizens use Rails"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.VINES).setTranslatedName("Citizens can climb Vines"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RETREAT).setTranslatedName("Guards Flee Under 20% HP"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SHIELD_USAGE).setTranslatedName("Knights Unlock Shield Use"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SLEEP_LESS).setTranslatedName("Guards Need Less Sleep"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.GUARD_CRIT).setTranslatedName("Guards have a chance to score critical hits").setLevels(new double[]{0.2, 0.3, 0.4, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.KNIGHT_WHIRLWIND).setTranslatedName("Knights Learn Special Attack That Damages and Knocks Back Nearby Enemies"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.WORKING_IN_RAIN).setTranslatedName("Citizens Work in Rain"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.UNDERTAKER_RUN).setTranslatedName("Undertaker unlocks run ability").setTranslatedSubtitle("Teach Undertaker the ability to run towards graves"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.USE_TOTEM).setTranslatedName("Undertaker gains the ability to use Totems of Undying to assist in Resurrection"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RECIPE_MODE).setTranslatedName("Add the option to select recipes based on Warehouse stock"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BUILDER_MODE).setTranslatedName("Add the option to select different build-modes for your builders"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SOFT_SHOES).setTranslatedName("Farmers will no longer trample crops"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FISH_TREASURE).setTranslatedName("Fishers can find treasure outside the ocean"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.NETHER_LOG).setTranslatedName("Adds expedition log to Nether Mine"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MASKS).setTranslatedName("Reduce disease transmission"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.VACCINES).setTranslatedName("Citizens are immune for longer after treatment"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.TELESCOPE).setTranslatedName("Farther rallying banner range"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.STANDARD).setTranslatedName("Place Rallying Banner at location"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MORE_AIR).setTranslatedName("Citizens can stay longer underwater"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MIN_ORDER).setTranslatedName("Buildings wait a bit longer before placing orders"));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.archery.get()).getBuildingBlock()).setTranslatedName("Unlocks Archery").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.barracks.get()).getBuildingBlock()).setTranslatedName("Unlocks Barracks").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.blacksmith.get()).getBuildingBlock()).setTranslatedName("Unlocks Blacksmith's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.combatAcademy.get()).getBuildingBlock()).setTranslatedName("Unlocks Combat Academy").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.composter.get()).getBuildingBlock()).setTranslatedName("Unlocks Composter's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.concreteMixer.get()).getBuildingBlock()).setTranslatedName("Unlocks Concrete Mixer's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.crusher.get()).getBuildingBlock()).setTranslatedName("Unlocks Crusher's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.dyer.get()).getBuildingBlock()).setTranslatedName("Unlocks Dyer's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.fletcher.get()).getBuildingBlock()).setTranslatedName("Unlocks Fletcher's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.florist.get()).getBuildingBlock()).setTranslatedName("Unlocks Flower Shop").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.graveyard.get()).getBuildingBlock()).setTranslatedName("Unlocks Graveyard").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.glassblower.get()).getBuildingBlock()).setTranslatedName("Unlocks Glassblower's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.hospital.get()).getBuildingBlock()).setTranslatedName("Unlocks Hospital").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.library.get()).getBuildingBlock()).setTranslatedName("Unlocks Library").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.mechanic.get()).getBuildingBlock()).setTranslatedName("Unlocks Mechanic's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.mysticalSite.get()).getBuildingBlock()).setTranslatedName("Unlocks Mystical Site").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.plantation.get()).getBuildingBlock()).setTranslatedName("Unlocks Plantation").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.sawmill.get()).getBuildingBlock()).setTranslatedName("Unlocks Sawmill").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.school.get()).getBuildingBlock()).setTranslatedName("Unlocks School").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.sifter.get()).getBuildingBlock()).setTranslatedName("Unlocks Sifter's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.smeltery.get()).getBuildingBlock()).setTranslatedName("Unlocks Smeltery").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.stoneMason.get()).getBuildingBlock()).setTranslatedName("Unlocks Stonemason's Hut").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.stoneSmelter.get()).getBuildingBlock()).setTranslatedName("Unlocks Stone Smeltery").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.netherWorker.get()).getBuildingBlock()).setTranslatedName("Unlocks Nether Mine").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(((BuildingEntry)ModBuildings.alchemist.get()).getBuildingBlock()).setTranslatedName("Unlocks Alchemist").setLevels(new double[]{5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.THE_END).setTranslatedName("Stonemasons Learn Endstone Recipe and Bakers Learn Chorus Bread Recipe"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.THE_DEPTHS).setTranslatedName("Crusher Learns Deepslate and Tuff Recipes"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MORE_SCROLLS).setTranslatedName("Enchanter Learns Scroll Recipes to Locate Workers and Summon Guards"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLATE_ARMOR).setTranslatedName("Blacksmith Learns Plate Armor Recipes"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SIFTER_STRING).setTranslatedName("Fletcher Learns How to Make String Meshes for the Sifter"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SIFTER_FLINT).setTranslatedName("Stonemason Learns How to Make Flint Meshes for the Sifter"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SIFTER_IRON).setTranslatedName("Blacksmith Learns How to Make Iron Meshes for the Sifter"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SIFTER_DIAMOND).setTranslatedName("Mechanic Learns How to Make Diamond Meshes for the Sifter"));
        return effects;
    }

    @Override
    public Collection<AbstractResearchProvider.Research> getResearchCollection() {
        ArrayList<AbstractResearchProvider.Research> researches = new ArrayList<AbstractResearchProvider.Research>();
        researches.addAll(this.getCivilResearch(researches));
        researches.addAll(this.getCombatResearch(researches));
        researches.addAll(this.getTechnologyResearch(researches));
        researches.addAll(this.getAchievementResearch(researches));
        return researches;
    }

    public Collection<AbstractResearchProvider.Research> getCivilResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research stamina = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/stamina"), CIVIL).setTranslatedName("Stamina").setOnlyChild().setIcon(ModBlocks.blockHutHospital.asItem()).addItemCost(Items.CARROT, 1, this.provider).addEffect(((BuildingEntry)ModBuildings.hospital.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research bandAid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bandaid"), CIVIL).setParentResearch(stamina).setTranslatedName("Band Aid").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/regeneration1.png")).addBuildingRequirement("library", 2).addItemCost(Items.GOLDEN_CARROT, 1, this.provider).addEffect(ResearchConstants.REGENERATION, 1).addToList(r);
        AbstractResearchProvider.Research healingCream = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/healingcream"), CIVIL).setParentResearch(bandAid).setTranslatedName("Healing Cream").setTranslatedSubtitle("You missed a spot...").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/regeneration2.png")).addBuildingRequirement("library", 3).addItemCost(Items.GOLDEN_CARROT, 8, this.provider).addEffect(ResearchConstants.REGENERATION, 2).addToList(r);
        AbstractResearchProvider.Research bandages = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bandages"), CIVIL).setParentResearch(healingCream).setTranslatedName("Bandages").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/regeneration3.png")).addBuildingRequirement("library", 4).addItemCost(Items.GOLDEN_CARROT, 16, this.provider).addEffect(ResearchConstants.REGENERATION, 3).addToList(r);
        AbstractResearchProvider.Research compress = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/compress"), CIVIL).setParentResearch(bandages).setTranslatedName("Compress").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/regeneration4.png")).addBuildingRequirement("library", 5).addItemCost(Items.GOLDEN_CARROT, 32, this.provider).addEffect(ResearchConstants.REGENERATION, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/cast"), CIVIL).setParentResearch(compress).setTranslatedName("Cast").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/regeneration5.png")).addItemCost(Items.GOLDEN_CARROT, 64, this.provider).addEffect(ResearchConstants.REGENERATION, 5).addToList(r);
        AbstractResearchProvider.Research resistance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resistance"), CIVIL).setParentResearch(stamina).setTranslatedName("Resistance").setSortOrder(2).setIcon(Items.GLASS_BOTTLE).addBuildingRequirement("cook", 2).addItemCost(Items.GOLDEN_APPLE, 1, this.provider).addEffect(ResearchConstants.SATLIMIT, 1).addToList(r);
        AbstractResearchProvider.Research resilience = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resilience"), CIVIL).setParentResearch(resistance).setTranslatedName("Resilience").setIcon(Items.POTION).addBuildingRequirement("cook", 3).addItemCost(Items.GOLDEN_APPLE, 8, this.provider).addEffect(ResearchConstants.SATLIMIT, 2).addToList(r);
        AbstractResearchProvider.Research vitality = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/vitality"), CIVIL).setParentResearch(resilience).setTranslatedName("Vitality").setIcon(Items.SPLASH_POTION).addBuildingRequirement("cook", 4).addItemCost(Items.GOLDEN_APPLE, 16, this.provider).addEffect(ResearchConstants.SATLIMIT, 3).addToList(r);
        AbstractResearchProvider.Research fortitude = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/fortitude"), CIVIL).setParentResearch(vitality).setTranslatedName("Fortitude").setIcon(Items.HONEY_BOTTLE).addBuildingRequirement("cook", 5).addItemCost(Items.GOLDEN_APPLE, 32, this.provider).addEffect(ResearchConstants.SATLIMIT, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/indefatigability"), CIVIL).setParentResearch(fortitude).setTranslatedName("Indefatigability").setIcon(Items.EXPERIENCE_BOTTLE).addItemCost(Items.GOLDEN_APPLE, 64, this.provider).addEffect(ResearchConstants.SATLIMIT, 5).addToList(r);
        AbstractResearchProvider.Research keen = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/keen"), CIVIL).setTranslatedName("Keen").setSortOrder(2).setIcon(ModBlocks.blockHutLibrary.asItem()).addBuildingRequirement("residence", 3).addItemCost(Items.BOOK, 3, this.provider).addEffect(((BuildingEntry)ModBuildings.library.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research outpost = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/outpost"), CIVIL).setParentResearch(keen).setTranslatedName("Outpost").setIcon(ModBlocks.blockHutHome.asItem(), 50).addBuildingRequirement("residence", 4).addItemCost(Items.COOKED_BEEF, 64, this.provider).addEffect(ResearchConstants.CITIZEN_CAP, 2).addToList(r);
        AbstractResearchProvider.Research hamlet = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/hamlet"), CIVIL).setParentResearch(outpost).setTranslatedName("Hamlet").setIcon(ModBlocks.blockHutHome.asItem(), 75).addBuildingRequirement("residence", 5).addItemCost(Items.COOKED_BEEF, 128, this.provider).addEffect(ResearchConstants.CITIZEN_CAP, 3).addToList(r);
        AbstractResearchProvider.Research village = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/village"), CIVIL).setParentResearch(hamlet).setTranslatedName("Village").setIcon(ModBlocks.blockHutHome.asItem(), 100).addBuildingRequirement("townhall", 4).addItemCost(Items.COOKED_BEEF, 256, this.provider).addEffect(ResearchConstants.CITIZEN_CAP, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/city"), CIVIL).setParentResearch(village).setTranslatedName("City").setIcon(ModBlocks.blockHutHome.asItem(), 200).addBuildingRequirement("townhall", 5).addItemCost(Items.COOKED_BEEF, 512, this.provider).addEffect(ResearchConstants.CITIZEN_CAP, 5).addToList(r);
        AbstractResearchProvider.Research diligent = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/diligent"), CIVIL).setParentResearch(keen).setTranslatedName("Diligent").setSortOrder(2).setIcon(Items.EXPERIENCE_BOTTLE).addBuildingRequirement("library", 2).addItemCost(Items.BOOK, 6, this.provider).addEffect(ResearchConstants.LEVELING, 1).addToList(r);
        AbstractResearchProvider.Research studious = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/studious"), CIVIL).setParentResearch(diligent).setTranslatedName("Studious").setIcon(Items.EXPERIENCE_BOTTLE, 2).addBuildingRequirement("library", 3).addItemCost(Items.BOOK, 12, this.provider).addEffect(ResearchConstants.LEVELING, 2).addToList(r);
        AbstractResearchProvider.Research scholarly = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/scholarly"), CIVIL).setParentResearch(studious).setTranslatedName("Scholarly").setTranslatedSubtitle("Homework for the next decade... check!").setIcon(Items.EXPERIENCE_BOTTLE, 3).addBuildingRequirement("library", 4).addItemCost(Items.BOOK, 24, this.provider).addEffect(ResearchConstants.LEVELING, 3).addToList(r);
        AbstractResearchProvider.Research reflective = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/reflective"), CIVIL).setParentResearch(scholarly).setTranslatedName("Reflective").setTranslatedSubtitle("Let me think about that for a moment.").setIcon(Items.EXPERIENCE_BOTTLE, 4).addBuildingRequirement("library", 5).addItemCost(Items.BOOK, 48, this.provider).addEffect(ResearchConstants.LEVELING, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/academic"), CIVIL).setParentResearch(reflective).setTranslatedName("Academic").setTranslatedSubtitle("Think about what you thought when you thought of what you will think now.").setIcon(Items.EXPERIENCE_BOTTLE, 5).addItemCost(Items.BOOK, 128, this.provider).addEffect(ResearchConstants.LEVELING, 5).addToList(r);
        AbstractResearchProvider.Research rails = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/rails"), CIVIL).setParentResearch(keen).setTranslatedName("Rails").setTranslatedSubtitle("Research is progressing right on track.").setSortOrder(3).setIcon(Items.DETECTOR_RAIL).addBuildingRequirement("deliveryman", 3).addItemCost(Items.RAIL, 64, this.provider).addEffect(ResearchConstants.RAILS, 1).addToList(r);
        AbstractResearchProvider.Research nimble = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nimble"), CIVIL).setParentResearch(rails).setTranslatedName("Nimble").setTranslatedSubtitle("Not that we get time to exercise. It must be the morning commute.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/speed1.png")).addBuildingRequirement("townhall", 3).addItemCost(Items.RABBIT_FOOT, 1, this.provider).addEffect(ResearchConstants.WALKING, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/vines"), CIVIL).setParentResearch(keen).setTranslatedName("Aaaiooooiooo").setTranslatedSubtitle("Me Tarzan, you Jane.").setSortOrder(4).setIcon(Items.VINE).addBuildingRequirement("residence", 3).addItemCost(Items.VINE, 64, this.provider).addEffect(ResearchConstants.VINES, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/moq"), CIVIL).setParentResearch(rails).setTranslatedName("Minimum Order Quantity").setTranslatedSubtitle("Work smarter, not harder.").setSortOrder(10).setIcon(ModItems.clipboard).addBuildingRequirement("deliveryman", 9).addItemCost(ModItems.clipboard, 1, this.provider).addItemCost(Items.BOOK, 16, this.provider).addEffect(ResearchConstants.MIN_ORDER, 1).addToList(r);
        AbstractResearchProvider.Research agile = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/agile"), CIVIL).setParentResearch(nimble).setTranslatedName("Agile").setTranslatedSubtitle("So this is how it feels to be young again...").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/speed2.png")).addBuildingRequirement("townhall", 4).addItemCost(Items.RABBIT_FOOT, 10, this.provider).addEffect(ResearchConstants.WALKING, 2).addToList(r);
        AbstractResearchProvider.Research swift = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/swift"), CIVIL).setParentResearch(agile).setTranslatedName("Swift").setTranslatedSubtitle("They'll never see me coming.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/speed3.png")).addBuildingRequirement("townhall", 5).addItemCost(Items.RABBIT_FOOT, 32, this.provider).addEffect(ResearchConstants.WALKING, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/athlete"), CIVIL).setParentResearch(swift).setTranslatedName("Athlete").setTranslatedSubtitle("Try thinking as fast as your feet now!").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/speed4.png")).addItemCost(Items.RABBIT_FOOT, 64, this.provider).addEffect(ResearchConstants.WALKING, 4).addToList(r);
        AbstractResearchProvider.Research firstAid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/firstaid"), CIVIL).setTranslatedName("First Aid").setTranslatedSubtitle("First aid, second hand.").setSortOrder(3).setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp1.png")).addBuildingRequirement("townhall", 1).addItemCost(Items.HAY_BLOCK, 8, this.provider).addEffect(ResearchConstants.HEALTH_BOOST, 1).addToList(r);
        AbstractResearchProvider.Research firstAid2 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/firstaid2"), CIVIL).setParentResearch(firstAid).setTranslatedName("First Aid II").setTranslatedSubtitle("Second Aid?").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp2.png")).addBuildingRequirement("townhall", 2).addItemCost(Items.HAY_BLOCK, 16, this.provider).addEffect(ResearchConstants.HEALTH_BOOST, 2).addToList(r);
        AbstractResearchProvider.Research lifesaver = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/lifesaver"), CIVIL).setParentResearch(firstAid2).setTranslatedName("Lifesaver").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp3.png")).addBuildingRequirement("townhall", 3).addItemCost(Items.HAY_BLOCK, 32, this.provider).addEffect(ResearchConstants.HEALTH_BOOST, 3).addToList(r);
        AbstractResearchProvider.Research lifesaver2 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/lifesaver2"), CIVIL).setParentResearch(lifesaver).setTranslatedName("Lifesaver II").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp4.png")).addBuildingRequirement("townhall", 4).addItemCost(Items.HAY_BLOCK, 64, this.provider).addEffect(ResearchConstants.HEALTH_BOOST, 4).addToList(r);
        AbstractResearchProvider.Research guardianAngel = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/guardianangel"), CIVIL).setParentResearch(lifesaver2).setTranslatedName("Guardian Angel").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp5.png")).addBuildingRequirement("townhall", 5).addItemCost(Items.HAY_BLOCK, 128, this.provider).addEffect(ResearchConstants.HEALTH_BOOST, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/guardianangel2"), CIVIL).setParentResearch(guardianAngel).setTranslatedName("Guardian Angel II").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp6.png")).addItemCost(Items.HAY_BLOCK, 256, this.provider).addEffect(ResearchConstants.HEALTH_BOOST, 6).addToList(r);
        AbstractResearchProvider.Research masks = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/masks"), CIVIL).setParentResearch(firstAid2).setTranslatedName("Masks").setTranslatedSubtitle("Solidarity").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp4.png")).addBuildingRequirement("library", 3).addItemCost(Items.WHITE_WOOL, 32, this.provider).addEffect(ResearchConstants.MASKS, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/vaccines"), CIVIL).setParentResearch(masks).setTranslatedName("Vaccines").setTranslatedSubtitle("Obvious Measures").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/hp5.png")).addBuildingRequirement("hospital", 3).addItemCost(Items.EGG, 64, this.provider).addEffect(ResearchConstants.VACCINES, 1).addToList(r);
        AbstractResearchProvider.Research circus = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/circus"), CIVIL).setParentResearch(firstAid).setTranslatedName("Circus").setSortOrder(2).setIcon(new ResourceLocation("minecolonies", "textures/icons/research/happy1.png")).addBuildingRequirement("cook", 2).addItemCost(Items.CAKE, 1, this.provider).addEffect(ResearchConstants.HAPPINESS, 1).addToList(r);
        AbstractResearchProvider.Research festival = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/festival"), CIVIL).setParentResearch(circus).setTranslatedName("Festival").setTranslatedSubtitle("We Researchers may not be there, so don't look for us.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/happy2.png")).addBuildingRequirement("cook", 3).addItemCost(Items.CAKE, 9, this.provider).addEffect(ResearchConstants.HAPPINESS, 2).addToList(r);
        AbstractResearchProvider.Research spectacle = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/spectacle"), CIVIL).setParentResearch(festival).setTranslatedName("Spectacle").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/happy3.png")).addBuildingRequirement("cook", 4).addItemCost(Items.CAKE, 18, this.provider).addEffect(ResearchConstants.HAPPINESS, 3).addToList(r);
        AbstractResearchProvider.Research opera = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/opera"), CIVIL).setParentResearch(spectacle).setTranslatedName("Opera").setTranslatedSubtitle("Ear plugs not included.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/happy4.png")).addBuildingRequirement("cook", 5).addItemCost(Items.CAKE, 27, this.provider).addEffect(ResearchConstants.HAPPINESS, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/theater"), CIVIL).setParentResearch(opera).setTranslatedName("Theater").setTranslatedSubtitle("Oh don't be so dramatic!").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/happy5.png")).addItemCost(Items.ENCHANTED_GOLDEN_APPLE, 16, this.provider).addEffect(ResearchConstants.HAPPINESS, 5).addToList(r);
        AbstractResearchProvider.Research night_owl = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nightowl"), CIVIL).setParentResearch(circus).setTranslatedName("Night Owl").setTranslatedSubtitle("Overtime penalty rates need not apply.").setSortOrder(2).setIcon(Items.CLOCK, 1).addBuildingRequirement("library", 2).addItemCost(Items.GOLDEN_CARROT, 25, this.provider).addEffect(ResearchConstants.WORK_LONGER, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nightowl2"), CIVIL).setParentResearch(night_owl).setTranslatedName("Night Owl II").setTranslatedSubtitle("Got any coffee?").setSortOrder(2).setIcon(Items.CLOCK, 2).addBuildingRequirement("townhall", 3).addItemCost(Items.GOLDEN_CARROT, 75, this.provider).addEffect(ResearchConstants.WORK_LONGER, 2).addToList(r);
        AbstractResearchProvider.Research gourmand = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gourmand"), CIVIL).setParentResearch(firstAid).setTranslatedName("Gourmand").setSortOrder(3).setIcon(new ResourceLocation("minecolonies", "textures/icons/research/saturation1.png")).addBuildingRequirement("cook", 2).addItemCost(Items.COOKIE, 32, this.provider).addEffect(ResearchConstants.SATURATION, 1).addToList(r);
        AbstractResearchProvider.Research gorger = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gorger"), CIVIL).setParentResearch(gourmand).setTranslatedName("Gorger").setTranslatedSubtitle("MORE!???").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/saturation2.png")).addBuildingRequirement("cook", 3).addItemCost(Items.COOKIE, 64, this.provider).addEffect(ResearchConstants.SATURATION, 2).addToList(r);
        AbstractResearchProvider.Research stuffer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/stuffer"), CIVIL).setParentResearch(gorger).setTranslatedName("Stuffer").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/saturation3.png")).addBuildingRequirement("cook", 4).addItemCost(Items.COOKIE, 128, this.provider).addEffect(ResearchConstants.SATURATION, 3).addToList(r);
        AbstractResearchProvider.Research epicure = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/epicure"), CIVIL).setParentResearch(stuffer).setTranslatedName("Epicure").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/saturation4.png")).addBuildingRequirement("cook", 5).addItemCost(Items.COOKIE, 256, this.provider).addEffect(ResearchConstants.SATURATION, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/glutton"), CIVIL).setParentResearch(epicure).setTranslatedName("Glutton").setTranslatedSubtitle("I think I'm finally satisfied... so what's for next course?").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/saturation5.png")).addItemCost(Items.COOKIE, 512, this.provider).addEffect(ResearchConstants.SATURATION, 5).addToList(r);
        AbstractResearchProvider.Research higherLearning = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/higherlearning"), CIVIL).setTranslatedName("Higher Learning").setTranslatedSubtitle("Well, we had to find something to occupy them.").setSortOrder(4).setOnlyChild().setIcon(ModBlocks.blockHutSchool.asItem()).addBuildingRequirement("residence", 3).addItemCost(Items.BOOK, 3, this.provider).addEffect(((BuildingEntry)ModBuildings.school.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research moreBooks = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/morebooks"), CIVIL).setParentResearch(higherLearning).setTranslatedName("More Books").setTranslatedSubtitle("Of course I'm right, I read it in a book!").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/xpgain1.png")).addBuildingRequirement("school", 1).addItemCost(Items.BOOK, 6, this.provider).addEffect(ResearchConstants.TEACHING, 1).addToList(r);
        AbstractResearchProvider.Research bookworm = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bookworm"), CIVIL).setParentResearch(moreBooks).setTranslatedName("Bookworm").setTranslatedSubtitle("We all know the early bird gets the book!").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/xpgain2.png")).addBuildingRequirement("school", 3).addItemCost(Items.BOOKSHELF, 6, this.provider).addEffect(ResearchConstants.TEACHING, 2).addToList(r);
        AbstractResearchProvider.Research bachelor = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bachelor"), CIVIL).setParentResearch(bookworm).setTranslatedName("Bachelor").setTranslatedSubtitle("They now look like they know a lot, whether they do or not.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/xpgain3.png")).addBuildingRequirement("library", 3).addItemCost(Items.BOOKSHELF, 12, this.provider).addEffect(ResearchConstants.TEACHING, 3).addToList(r);
        AbstractResearchProvider.Research master = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/master"), CIVIL).setParentResearch(bachelor).setTranslatedName("Master").setTranslatedSubtitle("At least they get a fancy title this time.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/xpgain4.png")).addBuildingRequirement("library", 5).addItemCost(Items.BOOKSHELF, 32, this.provider).addEffect(ResearchConstants.TEACHING, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/phd"), CIVIL).setParentResearch(master).setTranslatedName("PhD").setTranslatedSubtitle("Not that sort of doctor.").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/xpgain5.png")).addItemCost(Items.BOOKSHELF, 64, this.provider).addEffect(ResearchConstants.TEACHING, 5).addToList(r);
        AbstractResearchProvider.Research nurture = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nurture"), CIVIL).setParentResearch(higherLearning).setTranslatedName("Nurture").setTranslatedSubtitle("It's just part of our nature now.").setSortOrder(2).setIcon(new ResourceLocation("minecolonies", "textures/icons/research/childgrowth1.png")).addBuildingRequirement("school", 1).addItemCost(Items.COOKED_CHICKEN, 32, this.provider).addEffect(ResearchConstants.GROWTH, 1).addToList(r);
        AbstractResearchProvider.Research hormones = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/hormones"), CIVIL).setParentResearch(nurture).setTranslatedName("Hormones").setTranslatedSubtitle("These are safe, right?").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/childgrowth2.png")).addBuildingRequirement("school", 3).addItemCost(Items.COOKED_CHICKEN, 64, this.provider).addEffect(ResearchConstants.GROWTH, 2).addToList(r);
        AbstractResearchProvider.Research puberty = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/puberty"), CIVIL).setParentResearch(hormones).setTranslatedName("Puberty").setTranslatedSubtitle("My voice sounds weird...").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/childgrowth3.png")).addBuildingRequirement("library", 3).addItemCost(Items.COOKED_CHICKEN, 128, this.provider).addEffect(ResearchConstants.GROWTH, 3).addToList(r);
        AbstractResearchProvider.Research growth = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/growth"), CIVIL).setParentResearch(puberty).setTranslatedName("Growth").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/childgrowth4.png")).addBuildingRequirement("library", 5).addItemCost(Items.COOKED_CHICKEN, 256, this.provider).addEffect(ResearchConstants.GROWTH, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/beanstalk"), CIVIL).setParentResearch(growth).setTranslatedName("Beanstalk").setTranslatedSubtitle("That's one heck of a growth spurt!").setIcon(new ResourceLocation("minecolonies", "textures/icons/research/childgrowth5.png")).addItemCost(Items.COOKED_CHICKEN, 512, this.provider).addEffect(ResearchConstants.GROWTH, 5).addToList(r);
        AbstractResearchProvider.Research ambition = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/ambition"), CIVIL).setTranslatedName("Ambition").setSortOrder(5).setIcon(ModBlocks.blockHutMysticalSite.asItem()).addItemCost(Items.DIAMOND, 1, this.provider).addEffect(((BuildingEntry)ModBuildings.mysticalSite.get()).getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/air"), CIVIL).setTranslatedName("Scuba").setParentResearch(ambition).setSortOrder(1).setIcon(Items.POTION).addItemCost(Items.HEART_OF_THE_SEA, 1, this.provider).addEffect(ResearchConstants.MORE_AIR, 1).addToList(r);
        AbstractResearchProvider.Research remembrance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/remembrance"), CIVIL).setTranslatedName("Remembrance").setSortOrder(6).setIcon(ModBlocks.blockHutGraveyard.asItem()).addEffect(((BuildingEntry)ModBuildings.graveyard.get()).getBuildingBlock(), 1).addBuildingRequirement("townhall", 2).addItemCost(Items.BONE, 8, this.provider).setTranslatedSubtitle("Our fallen shall not be forgotten!").addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/undertakeremergency"), CIVIL).setParentResearch(remembrance).setTranslatedName("Undertaker Emergency").setSortOrder(3).setIcon(ModBlocks.blockHutGraveyard.asItem()).addBuildingRequirement("graveyard", 2).addItemCost(Items.IRON_BOOTS, 1, this.provider).addEffect(ResearchConstants.UNDERTAKER_RUN, 1).addToList(r);
        AbstractResearchProvider.Research resurrectChance1 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resurrectchance1"), CIVIL).setParentResearch(remembrance).setTranslatedName("Resurrection Chance I").setTranslatedSubtitle("Use the right words").setSortOrder(1).setIcon(ModBlocks.blockHutGraveyard.asItem()).addBuildingRequirement("graveyard", 3).addItemCost(Items.GHAST_TEAR, 1, this.provider).addEffect(ResearchConstants.RESURRECT_CHANCE, 1).addToList(r);
        AbstractResearchProvider.Research resurrectChance2 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resurrectchance2"), CIVIL).setParentResearch(resurrectChance1).setTranslatedName("Resurrection Chance II").setTranslatedSubtitle("Dance around and wave your hands").setSortOrder(1).setIcon(ModBlocks.blockHutGraveyard.asItem()).addBuildingRequirement("graveyard", 5).addItemCost(Items.CHORUS_FRUIT, 16, this.provider).addEffect(ResearchConstants.RESURRECT_CHANCE, 2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/raisingthedead"), CIVIL).setParentResearch(resurrectChance2).setTranslatedName("Raising The Dead").setTranslatedSubtitle("Magic totems are for more than just looks").setSortOrder(1).setIcon(Items.TOTEM_OF_UNDYING.asItem()).addBuildingRequirement("graveyard", 5).addItemCost(Items.TOTEM_OF_UNDYING, 1, this.provider).addEffect(ResearchConstants.USE_TOTEM, 1).addToList(r);
        AbstractResearchProvider.Research decayBonus1 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gravedecaybonus1"), CIVIL).setParentResearch(remembrance).setTranslatedName("Grave Decay I").setTranslatedSubtitle("Dig deeper before death").setSortOrder(2).setIcon(ModBlocks.blockGrave.asItem()).addBuildingRequirement("graveyard", 3).addItemCost(Items.ROTTEN_FLESH, 64, this.provider).addEffect(ResearchConstants.GRAVE_DECAY_BONUS, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gravedecaybonus2"), CIVIL).setParentResearch(decayBonus1).setTranslatedName("Grave Decay II").setTranslatedSubtitle("I don't want to leave yet!").setSortOrder(2).setIcon(ModBlocks.blockGrave.asItem()).addBuildingRequirement("graveyard", 5).addItemCost(Items.NETHER_WART_BLOCK, 8, this.provider).addEffect(ResearchConstants.GRAVE_DECAY_BONUS, 2).addToList(r);
        return r;
    }

    public Collection<AbstractResearchProvider.Research> getCombatResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research accuracy = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/accuracy"), COMBAT).setTranslatedName("Accuracy").setOnlyChild().setIcon(Items.IRON_SWORD).addBuildingRequirement("guardtower", 1).addItemCost(Items.IRON_INGOT, 16, this.provider).addEffect(ResearchConstants.GUARD_CRIT, 1).addToList(r);
        AbstractResearchProvider.Research quickDraw = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/quickdraw"), COMBAT).setParentResearch(accuracy).setTranslatedName("Quick Draw").setIcon(Items.WOODEN_SWORD).addBuildingRequirement("barracks", 3).addItemCost(Items.IRON_BLOCK, 2, this.provider).addEffect(ResearchConstants.MELEE_DAMAGE, 1).addToList(r);
        AbstractResearchProvider.Research powerAttack = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/powerattack"), COMBAT).setParentResearch(quickDraw).setTranslatedName("Power Attack").setIcon(Items.STONE_SWORD).addBuildingRequirement("combatacademy", 3).addItemCost(Items.IRON_BLOCK, 4, this.provider).addEffect(ResearchConstants.MELEE_DAMAGE, 2).addToList(r);
        AbstractResearchProvider.Research cleave = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/cleave"), COMBAT).setParentResearch(powerAttack).setTranslatedName("Cleave").setIcon(Items.IRON_SWORD).addBuildingRequirement("guardtower", 10).addItemCost(Items.IRON_BLOCK, 8, this.provider).addEffect(ResearchConstants.MELEE_DAMAGE, 3).addToList(r);
        AbstractResearchProvider.Research mightyCleave = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/mightycleave"), COMBAT).setParentResearch(cleave).setTranslatedName("Mighty Cleave").setIcon(Items.GOLDEN_SWORD).addBuildingRequirement("barracks", 5).addItemCost(Items.IRON_BLOCK, 16, this.provider).addEffect(ResearchConstants.MELEE_DAMAGE, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/savagestrike"), COMBAT).setParentResearch(mightyCleave).setTranslatedName("Savage Strike").setIcon(Items.DIAMOND_SWORD).addItemCost(Items.IRON_BLOCK, 32, this.provider).addEffect(ResearchConstants.MELEE_DAMAGE, 5).addToList(r);
        AbstractResearchProvider.Research preciseShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/preciseshot"), COMBAT).setParentResearch(accuracy).setTranslatedName("Precise Shot").setSortOrder(2).setIcon(Items.ARROW).addBuildingRequirement("barracks", 3).addItemCost(Items.FLINT, 16, this.provider).addEffect(ResearchConstants.ARCHER_DAMAGE, 1).addToList(r);
        AbstractResearchProvider.Research penetratingShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/penetratingshot"), COMBAT).setParentResearch(preciseShot).setTranslatedName("Penetrating Shot").setIcon(Items.BOW).addBuildingRequirement("archery", 3).addItemCost(Items.FLINT, 32, this.provider).addEffect(ResearchConstants.ARCHER_DAMAGE, 2).addToList(r);
        AbstractResearchProvider.Research piercingShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/piercingshot"), COMBAT).setParentResearch(penetratingShot).setTranslatedName("Piercing Shot").setIcon(Items.CROSSBOW).addBuildingRequirement("guardtower", 10).addItemCost(Items.FLINT, 64, this.provider).addEffect(ResearchConstants.ARCHER_DAMAGE, 3).addToList(r);
        AbstractResearchProvider.Research woundingShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/woundingshot"), COMBAT).setParentResearch(piercingShot).setTranslatedName("Wounding Shot").setIcon(ModItems.firearrow).addBuildingRequirement("barracks", 5).addItemCost(Items.FLINT, 128, this.provider).addEffect(ResearchConstants.ARCHER_DAMAGE, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/deadlyaim"), COMBAT).setParentResearch(woundingShot).setTranslatedName("Deadly Aim").setTranslatedSubtitle("Just don't aim at me!").setIcon(Items.TIPPED_ARROW).addItemCost(Items.FLINT, 256, this.provider).addEffect(ResearchConstants.ARCHER_DAMAGE, 5).addToList(r);
        AbstractResearchProvider.Research tacticTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/tactictraining"), COMBAT).setTranslatedName("Tactic Training").setSortOrder(2).setIcon(ModBlocks.blockHutBarracksTower.asItem()).addBuildingRequirement("guardtower", 3).addItemCost(Items.IRON_BLOCK, 3, this.provider).addEffect(((BuildingEntry)ModBuildings.barracks.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research improvedSwords = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedswords"), COMBAT).setParentResearch(tacticTraining).setTranslatedName("Improved Swords").setTranslatedSubtitle("Pointy end goes into the zombie.").setIcon(ModBlocks.blockHutCombatAcademy.asItem()).addBuildingRequirement("barracks", 3).addItemCost(Items.IRON_BLOCK, 6, this.provider).addEffect(((BuildingEntry)ModBuildings.combatAcademy.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research squireTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/squiretraining"), COMBAT).setParentResearch(improvedSwords).setTranslatedName("Squire Training").setTranslatedSubtitle("First lesson: how to mop the floors.").setIcon(Items.IRON_INGOT).addBuildingRequirement("combatacademy", 3).addItemCost(Items.SHIELD, 4, this.provider).addEffect(ResearchConstants.BLOCK_ATTACKS, 1).addToList(r);
        AbstractResearchProvider.Research knightTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/knighttraining"), COMBAT).setParentResearch(squireTraining).setTranslatedName("Knight Training").setIcon(Items.BARREL).addBuildingRequirement("combatacademy", 4).addItemCost(Items.SHIELD, 8, this.provider).addEffect(ResearchConstants.BLOCK_ATTACKS, 2).addToList(r);
        AbstractResearchProvider.Research captainTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/captaintraining"), COMBAT).setParentResearch(knightTraining).setTranslatedName("Captain Training").setIcon(Items.IRON_BARS).addBuildingRequirement("combatacademy", 5).addItemCost(Items.SHIELD, 16, this.provider).addEffect(ResearchConstants.BLOCK_ATTACKS, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/captainoftheguard"), COMBAT).setParentResearch(captainTraining).setTranslatedName("Captain of the Guard").setIcon(Items.IRON_BLOCK).addItemCost(Items.SHIELD, 27, this.provider).addEffect(ResearchConstants.BLOCK_ATTACKS, 4).addToList(r);
        AbstractResearchProvider.Research improvedBows = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedbows"), COMBAT).setParentResearch(tacticTraining).setTranslatedName("Improved Bows").setTranslatedSubtitle("How far back can this bend before snapping?").setSortOrder(2).setIcon(ModBlocks.blockHutArchery.asItem()).addBuildingRequirement("barracks", 3).addItemCost(Items.IRON_BLOCK, 6, this.provider).addEffect(((BuildingEntry)ModBuildings.archery.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research trickShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/trickshot"), COMBAT).setParentResearch(improvedBows).setTranslatedName("Trick Shot").setIcon(Items.ARROW).addBuildingRequirement("archery", 3).addItemCost(Items.BOW, 5, this.provider).addEffect(ResearchConstants.DOUBLE_ARROWS, 1).addToList(r);
        AbstractResearchProvider.Research multiShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/multishot"), COMBAT).setParentResearch(trickShot).setTranslatedName("Multishot").setTranslatedSubtitle("Known side effects include double vision double vision.").setIcon(Items.TIPPED_ARROW).addBuildingRequirement("archery", 4).addItemCost(Items.BOW, 9, this.provider).addEffect(ResearchConstants.DOUBLE_ARROWS, 2).addToList(r);
        AbstractResearchProvider.Research rapidShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/rapidshot"), COMBAT).setParentResearch(multiShot).setTranslatedName("Rapid Shot").setTranslatedSubtitle("Please leave the bow with more than you brought in.").setIcon(ModItems.firearrow).addBuildingRequirement("archery", 5).addItemCost(Items.BOW, 18, this.provider).addEffect(ResearchConstants.DOUBLE_ARROWS, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/masterbowman"), COMBAT).setParentResearch(rapidShot).setTranslatedName("Master Bowman").setIcon(Items.BLAZE_ROD).addItemCost(Items.BOW, 27, this.provider).addEffect(ResearchConstants.DOUBLE_ARROWS, 4).addToList(r);
        AbstractResearchProvider.Research coffee = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/coffee"), COMBAT).setParentResearch(tacticTraining).setTranslatedName("Coffee").setTranslatedSubtitle("Keeps guards awake").setIcon(Items.LIME_BED).addItemCost(Items.GOLDEN_CARROT, 4, this.provider).addEffect(ResearchConstants.SLEEP_LESS, 1).addToList(r);
        AbstractResearchProvider.Research avoidance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/avoidance"), COMBAT).setTranslatedName("Avoidance").setSortOrder(3).setOnlyChild().setIcon(Items.SHIELD).addBuildingRequirement("guardtower", 3).addItemCost(Items.IRON_BLOCK, 3, this.provider).addEffect(ResearchConstants.SHIELD_USAGE, 1).addToList(r);
        AbstractResearchProvider.Research parry = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/parry"), COMBAT).setParentResearch(avoidance).setTranslatedName("Parry").setIcon(Items.LEATHER_CHESTPLATE).addBuildingRequirement("smeltery", 1).addItemCost(Items.IRON_INGOT, 16, this.provider).addEffect(ResearchConstants.MELEE_ARMOR, 1).addToList(r);
        AbstractResearchProvider.Research riposte = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/riposte"), COMBAT).setParentResearch(parry).setTranslatedName("Riposte").setTranslatedSubtitle("Oh yeah? Well, I, uh, um...").setIcon(Items.IRON_CHESTPLATE).addBuildingRequirement("combatacademy", 1).addItemCost(Items.IRON_INGOT, 32, this.provider).addEffect(ResearchConstants.MELEE_ARMOR, 2).addToList(r);
        AbstractResearchProvider.Research duelist = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/duelist"), COMBAT).setParentResearch(riposte).setTranslatedName("Duelist").setIcon(Items.CHAINMAIL_CHESTPLATE).addBuildingRequirement("smeltery", 3).addItemCost(Items.IRON_INGOT, 64, this.provider).addEffect(ResearchConstants.MELEE_ARMOR, 3).addToList(r);
        AbstractResearchProvider.Research provost = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/provost"), COMBAT).setParentResearch(duelist).setTranslatedName("Provost").setIcon(Items.GOLDEN_CHESTPLATE).addBuildingRequirement("combatacademy", 5).addItemCost(Items.DIAMOND, 16, this.provider).addEffect(ResearchConstants.MELEE_ARMOR, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/masterswordsman"), COMBAT).setParentResearch(provost).setTranslatedName("Master Swordsman").setIcon(Items.DIAMOND_CHESTPLATE).addItemCost(Items.DIAMOND, 64, this.provider).addEffect(ResearchConstants.MELEE_ARMOR, 5).addToList(r);
        AbstractResearchProvider.Research dodge = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/dodge"), COMBAT).setParentResearch(avoidance).setTranslatedName("Dodge").setTranslatedSubtitle("If you can dodge a hammer...").setSortOrder(2).setIcon(ModItems.pirateBoots_2.asItem()).addBuildingRequirement("smeltery", 1).addItemCost(Items.LEATHER, 16, this.provider).addEffect(ResearchConstants.ARCHER_ARMOR, 1).addToList(r);
        AbstractResearchProvider.Research improvedDodge = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improveddodge"), COMBAT).setParentResearch(dodge).setTranslatedName("Improved Dodge").setTranslatedSubtitle("Dip").setIcon(ModItems.pirateBoots_1).addBuildingRequirement("archery", 1).addItemCost(Items.LEATHER, 32, this.provider).addEffect(ResearchConstants.ARCHER_ARMOR, 2).addToList(r);
        AbstractResearchProvider.Research evasion = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/evasion"), COMBAT).setParentResearch(improvedDodge).setTranslatedName("Evasion").setTranslatedSubtitle("\"Duck!\" \"No, that's a goose.\"").setIcon(Items.IRON_BOOTS).addBuildingRequirement("smeltery", 3).addItemCost(Items.LEATHER, 64, this.provider).addEffect(ResearchConstants.ARCHER_ARMOR, 3).addToList(r);
        AbstractResearchProvider.Research improvedEvasion = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedevasion"), COMBAT).setParentResearch(evasion).setTranslatedName("Improved Evasion").setTranslatedSubtitle("Dive").setIcon(Items.GOLDEN_BOOTS).addBuildingRequirement("archery", 5).addItemCost(Items.DIAMOND, 16, this.provider).addEffect(ResearchConstants.ARCHER_ARMOR, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/agilearcher"), COMBAT).setParentResearch(improvedEvasion).setTranslatedName("Agile Archer").setTranslatedSubtitle("Dodge... Again!").setIcon(Items.DIAMOND_BOOTS).addItemCost(Items.DIAMOND, 64, this.provider).addEffect(ResearchConstants.ARCHER_ARMOR, 5).addToList(r);
        AbstractResearchProvider.Research improvedLeather = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedleather"), COMBAT).setTranslatedName("Improved Leather").setTranslatedSubtitle("Becoming more like the real thing every day.").setSortOrder(4).setIcon(Items.LEATHER_HELMET).addBuildingRequirement("townhall", 1).addItemCost(Items.LEATHER, 32, this.provider).addEffect(ResearchConstants.ARMOR_DURABILITY, 1).addToList(r);
        AbstractResearchProvider.Research boiledLeather = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/boiledleather"), COMBAT).setParentResearch(improvedLeather).setTranslatedName("Boiled Leather").setTranslatedSubtitle("Extra leathery!").setIcon(Items.TURTLE_HELMET).addBuildingRequirement("townhall", 2).addItemCost(Items.LEATHER, 64, this.provider).addEffect(ResearchConstants.ARMOR_DURABILITY, 2).addToList(r);
        AbstractResearchProvider.Research ironSkin = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/ironskin"), COMBAT).setParentResearch(boiledLeather).setTranslatedName("Iron Skin").setIcon(Items.CHAINMAIL_HELMET).addBuildingRequirement("townhall", 3).addItemCost(Items.IRON_INGOT, 16, this.provider).addEffect(ResearchConstants.ARMOR_DURABILITY, 3).addToList(r);
        AbstractResearchProvider.Research ironArmor = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/ironarmor"), COMBAT).setParentResearch(ironSkin).setTranslatedName("Iron Armor").setIcon(Items.IRON_HELMET).addBuildingRequirement("townhall", 4).addItemCost(Items.IRON_INGOT, 32, this.provider).addEffect(ResearchConstants.ARMOR_DURABILITY, 4).addToList(r);
        AbstractResearchProvider.Research steelArmor = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/steelarmor"), COMBAT).setParentResearch(ironArmor).setTranslatedName("Steel Armor").setSortOrder(1).setIcon(Items.GOLDEN_HELMET).addBuildingRequirement("townhall", 5).addItemCost(Items.IRON_INGOT, 64, this.provider).addEffect(ResearchConstants.ARMOR_DURABILITY, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/platearmor"), COMBAT).setParentResearch(ironArmor).setTranslatedName("Plate Armor").setSortOrder(2).setIcon(ModItems.plateArmorHelmet).addMandatoryBuildingRequirement("blacksmith", 4).addItemCost(Items.IRON_INGOT, 32, this.provider).addEffect(ResearchConstants.PLATE_ARMOR, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/diamondskin"), COMBAT).setParentResearch(steelArmor).setTranslatedName("Diamond Skin").setIcon(Items.DIAMOND_HELMET).addItemCost(Items.DIAMOND, 64, this.provider).addEffect(ResearchConstants.ARMOR_DURABILITY, 6).addToList(r);
        AbstractResearchProvider.Research telescope = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/telescope"), COMBAT).setParentResearch(ironSkin).setTranslatedName("Telescope").setIcon(ModItems.bannerRallyGuards).addBuildingRequirement("barracks", 3).addItemCost(Items.EMERALD, 16, this.provider).addEffect(ResearchConstants.TELESCOPE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/standard"), COMBAT).setParentResearch(telescope).setTranslatedName("Standard").setIcon(ModItems.bannerRallyGuards).addBuildingRequirement("barracks", 4).addItemCost(Items.EMERALD, 32, this.provider).addEffect(ResearchConstants.STANDARD, 1).addToList(r);
        AbstractResearchProvider.Research regeneration = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/regeneration"), COMBAT).setParentResearch(improvedLeather).setTranslatedName("Regeneration").setSortOrder(2).setOnlyChild().setIcon(Items.GLISTERING_MELON_SLICE).addBuildingRequirement("guardtower", 2).addItemCost(Items.EMERALD, 1, this.provider).addEffect(ResearchConstants.RETREAT, 1).addToList(r);
        AbstractResearchProvider.Research feint = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/feint"), COMBAT).setParentResearch(regeneration).setTranslatedName("Feint").setIcon(Items.LEATHER_BOOTS).addBuildingRequirement("guardtower", 4).addItemCost(Items.EMERALD, 8, this.provider).addEffect(ResearchConstants.FLEEING_DAMAGE, 1).addToList(r);
        AbstractResearchProvider.Research fear = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/fear"), COMBAT).setParentResearch(feint).setTranslatedName("Fear").setIcon(Items.IRON_BOOTS).addBuildingRequirement("guardtower", 8).addItemCost(Items.EMERALD, 16, this.provider).addEffect(ResearchConstants.FLEEING_DAMAGE, 2).addToList(r);
        AbstractResearchProvider.Research retreat = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/retreat"), COMBAT).setParentResearch(fear).setTranslatedName("Retreat").setTranslatedSubtitle("For strategic purposes, I assure you.").setIcon(Items.GOLDEN_BOOTS).addBuildingRequirement("guardtower", 12).addItemCost(Items.EMERALD, 32, this.provider).addEffect(ResearchConstants.FLEEING_DAMAGE, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/fullretreat"), COMBAT).setParentResearch(retreat).setTranslatedName("Full Retreat").setIcon(Items.DIAMOND_BOOTS).addItemCost(Items.EMERALD, 64, this.provider).addEffect(ResearchConstants.FLEEING_DAMAGE, 4).addToList(r);
        AbstractResearchProvider.Research avoid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/avoid"), COMBAT).setParentResearch(regeneration).setTranslatedName("Avoid").setSortOrder(2).setIcon(Items.FEATHER).addBuildingRequirement("guardtower", 4).addItemCost(Items.EMERALD, 8, this.provider).addEffect(ResearchConstants.FLEEING_SPEED, 1).addToList(r);
        AbstractResearchProvider.Research evade = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/evade"), COMBAT).setParentResearch(avoid).setTranslatedName("Evade").setIcon(Items.FEATHER, 2).addBuildingRequirement("guardtower", 8).addItemCost(Items.EMERALD, 16, this.provider).addEffect(ResearchConstants.FLEEING_SPEED, 2).addToList(r);
        AbstractResearchProvider.Research flee = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/flee"), COMBAT).setParentResearch(evade).setTranslatedName("Flee").setTranslatedSubtitle("Sometimes it's better just to run.").setIcon(Items.FEATHER, 3).addBuildingRequirement("guardtower", 12).addItemCost(Items.EMERALD, 32, this.provider).addEffect(ResearchConstants.FLEEING_SPEED, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/hotfoot"), COMBAT).setParentResearch(flee).setTranslatedName("Hotfoot").setIcon(Items.CHICKEN).addItemCost(Items.EMERALD, 64, this.provider).addEffect(ResearchConstants.FLEEING_SPEED, 4).addToList(r);
        AbstractResearchProvider.Research taunt = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/taunt"), COMBAT).setTranslatedName("Taunt").setTranslatedSubtitle("Your mother was a hamster and your father smelt of elderberries!").setSortOrder(5).setIcon(Items.CHAIN).addBuildingRequirement("guardtower", 1).addItemCost(Items.ROTTEN_FLESH, 8, this.provider).addItemCost(Items.BONE, 8, this.provider).addItemCost(Items.SPIDER_EYE, 8, this.provider).addEffect(ResearchConstants.KNIGHT_TAUNT, 1).addToList(r);
        AbstractResearchProvider.Research arrowUse = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/arrowuse"), COMBAT).setParentResearch(taunt).setTranslatedName("Consume Arrows").setTranslatedSubtitle("They work better with ammo.").setIcon(Items.ARROW).addBuildingRequirement("guardtower", 2).addItemCost(Items.ARROW, 64, this.provider).addEffect(ResearchConstants.ARCHER_USE_ARROWS, 1).addToList(r);
        AbstractResearchProvider.Research arrowPierce = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/arrowpierce"), COMBAT).setParentResearch(arrowUse).setTranslatedName("Arrow Piercing").setIcon(Items.ENCHANTED_BOOK).addBuildingRequirement("archery", 1).addItemCost(Items.ARROW, 64, this.provider).addItemCost(Items.REDSTONE, 64, this.provider).addEffect(ResearchConstants.ARROW_PIERCE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/druidpotion"), COMBAT).setParentResearch(arrowUse).setTranslatedName("Panoramix").setIcon(ModItems.mistletoe).addBuildingRequirement("barracks", 3).addItemCost(ModItems.mistletoe, 64, this.provider).addEffect(ResearchConstants.DRUID_USE_POTIONS, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/whirlwind"), COMBAT).setParentResearch(arrowPierce).setTranslatedName("Whirlwind").setIcon(ModItems.scimitar).addBuildingRequirement("barracks", 4).addItemCost(Items.REDSTONE, 64, this.provider).addItemCost(Items.GOLD_INGOT, 64, this.provider).addItemCost(Items.LAPIS_LAZULI, 128, this.provider).addEffect(ResearchConstants.KNIGHT_WHIRLWIND, 1).addToList(r);
        return r;
    }

    public Collection<AbstractResearchProvider.Research> getTechnologyResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research biodegradable = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/biodegradable"), TECH).setTranslatedName("Biodegradable").setTranslatedSubtitle("Where science meets dirt.").setIcon(ModBlocks.blockHutComposter.asItem()).addBuildingRequirement("farmer", 3).addItemCost(Items.BONE_MEAL, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.composter.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research podzolChance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/podzolchance"), TECH).setParentResearch(biodegradable).setTranslatedName("Podzol Chance").setTranslatedSubtitle("Eww, sticky!").setIcon(Items.PODZOL).addBuildingRequirement("composter", 2).addItemCost(Items.PODZOL, 8, this.provider).addEffect(ResearchConstants.PODZOL_CHANCE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/podzolchance2"), TECH).setParentResearch(podzolChance).setTranslatedName("Podzol Chance II").setTranslatedSubtitle("Much easier than Silk Touch.").setIcon(Items.PODZOL).addBuildingRequirement("composter", 3).addItemCost(Items.PODZOL, 32, this.provider).addEffect(ResearchConstants.PODZOL_CHANCE, 2).addToList(r);
        AbstractResearchProvider.Research flowerPower = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/flowerpower"), TECH).setParentResearch(biodegradable).setTranslatedName("Flower Power").setIcon(ModBlocks.blockHutFlorist.asItem()).addBuildingRequirement("composter", 3).addItemCost(ModItems.compost, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.florist.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research rainbowHeaven = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rainbowheaven"), TECH).setParentResearch(biodegradable).setTranslatedName("Rainbow Heaven").setTranslatedSubtitle("Now in color! And 3D!").setIcon(ModBlocks.blockHutComposter.asItem()).addBuildingRequirement("composter", 3).addItemCost(Items.POPPY, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.dyer.get()).getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/honeypot"), TECH).setParentResearch(rainbowHeaven).setTranslatedName("Honey Pot").setTranslatedSubtitle("Wasn't going to eat it. Just going to taste it.").setIcon(Items.HONEYCOMB.asItem()).addBuildingRequirement("beekeeper", 3).addItemCost(Items.BEEHIVE, 16, this.provider).addEffect(ResearchConstants.BEEKEEP_2, 1).addToList(r);
        AbstractResearchProvider.Research letItGrow = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/letitgrow"), TECH).setParentResearch(biodegradable).setTranslatedName("Let It Grow").setTranslatedSubtitle("Just one tiny seed is all we really need.").setSortOrder(2).setIcon(ModBlocks.blockHutPlantation.asItem()).addBuildingRequirement("farmer", 3).addItemCost(ModItems.compost, 16, this.provider).addEffect(((BuildingEntry)ModBuildings.plantation.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research cropRotation = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/croprotation"), TECH).setParentResearch(letItGrow).setTranslatedName("Crop Rotation").setTranslatedSubtitle("Bigger = better").setIcon(Items.GREEN_DYE).addBuildingRequirement("plantation", 3).addItemCost(Items.SUGAR_CANE, 32, this.provider).addItemCost(Items.CACTUS, 32, this.provider).addEffect(ResearchConstants.PLANTATION_LARGE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/junglemaster"), TECH).setParentResearch(letItGrow).setTranslatedName("Jungle Master").setTranslatedSubtitle("Wimoweh Wimoweh Wimoweh").setIcon(Items.VINE).addBuildingRequirement("plantation", 2).addItemCost(Items.BAMBOO, 16, this.provider).addItemCost(Items.COCOA_BEANS, 16, this.provider).addItemCost(Items.VINE, 16, this.provider).addEffect(ResearchConstants.PLANTATION_JUNGLE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/takingdivinglessons"), TECH).setParentResearch(letItGrow).setTranslatedName("Taking Diving Lessons").setTranslatedSubtitle("*Drowning Noises*").setIcon(Items.KELP).addBuildingRequirement("plantation", 2).addItemCost(Items.KELP, 16, this.provider).addItemCost(Items.SEAGRASS, 16, this.provider).addItemCost(Items.SEA_PICKLE, 16, this.provider).addEffect(ResearchConstants.PLANTATION_SEA, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/exoticfruits"), TECH).setParentResearch(letItGrow).setTranslatedName("Exotic Fruits").setTranslatedSubtitle("Too Dark Here").setIcon(Items.GLOW_BERRIES).addBuildingRequirement("plantation", 3).addItemCost(Items.GLOW_BERRIES, 32, this.provider).addEffect(ResearchConstants.PLANTATION_EXOTIC, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/gargamel"), TECH).setParentResearch(cropRotation).setTranslatedName("Gargamel").setTranslatedSubtitle("The Root of all Evil").setIcon(Items.CRIMSON_FUNGUS).addBuildingRequirement("plantation", 3).addBuildingRequirement("netherworker", 3).addItemCost(Items.CRIMSON_FUNGUS, 16, this.provider).addItemCost(Items.WARPED_FUNGUS, 16, this.provider).addEffect(ResearchConstants.PLANTATION_NETHER, 1).addToList(r);
        AbstractResearchProvider.Research bonemeal = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/bonemeal"), TECH).setParentResearch(biodegradable).setTranslatedName("Bonemeal").setTranslatedSubtitle("And to think this stuff feeds our plants...").setSortOrder(3).setIcon(Items.WHEAT_SEEDS).addBuildingRequirement("miner", 3).addItemCost(Items.WHEAT_SEEDS, 64, this.provider).addEffect(ResearchConstants.FARMING, 1).addToList(r);
        AbstractResearchProvider.Research dung = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/dung"), TECH).setParentResearch(bonemeal).setTranslatedName("Dung").setTranslatedSubtitle("Fresh or not, here it comes!").setIcon(Items.BONE_MEAL).addBuildingRequirement("miner", 4).addItemCost(Items.WHEAT_SEEDS, 128, this.provider).addEffect(ResearchConstants.FARMING, 2).addToList(r);
        AbstractResearchProvider.Research compost = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/compost"), TECH).setParentResearch(dung).setTranslatedName("Compost").setIcon(Items.BONE).addBuildingRequirement("miner", 5).addItemCost(Items.WHEAT_SEEDS, 256, this.provider).addEffect(ResearchConstants.FARMING, 3).addToList(r);
        AbstractResearchProvider.Research fertilizer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/fertilizer"), TECH).setParentResearch(compost).setTranslatedName("Fertilizer").setTranslatedSubtitle("Ah, that's the stuff!").setIcon(Items.BONE_BLOCK).addBuildingRequirement("smeltery", 3).addItemCost(Items.WHEAT_SEEDS, 512, this.provider).addEffect(ResearchConstants.FARMING, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/magiccompost"), TECH).setParentResearch(fertilizer).setTranslatedName("Magic Compost").setIcon(ModBlocks.blockBarrel.asItem()).addItemCost(Items.WHEAT_SEEDS, 2048, this.provider).addEffect(ResearchConstants.FARMING, 5).addToList(r);
        AbstractResearchProvider.Research softShoes = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/softshoes"), TECH).setTranslatedName("Soft Shoes").setTranslatedSubtitle("Tiptoe through the tulips.").setSortOrder(2).setIcon(Items.LEATHER_BOOTS).addItemCost(Items.WHITE_WOOL, 16, this.provider).addItemCost(Items.FEATHER, 16, this.provider).addEffect(ResearchConstants.SOFT_SHOES, 1).addToList(r);
        AbstractResearchProvider.Research moreScrolls = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/morescrolls"), TECH).setTranslatedName("More Scrolls").setSortOrder(3).setIcon(ModItems.scrollHighLight).addBuildingRequirement("enchanter", 3).addItemCost(Items.PAPER, 64, this.provider).addItemCost(ModItems.ancientTome, 1, this.provider).addItemCost(Items.LAPIS_LAZULI, 64, this.provider).addEffect(new ResourceLocation("minecolonies", "effects/morescrollsunlock"), 1).addToList(r);
        AbstractResearchProvider.Research netherminer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/opennether"), TECH).setParentResearch(moreScrolls).setTranslatedName("Open the Nether").setTranslatedSubtitle("It's a dangerous job, but it must be done!").setSortOrder(1).setIcon(ModBlocks.blockHutNetherWorker.asItem()).addItemCost(Items.GILDED_BLACKSTONE, 3, this.provider).addEffect(((BuildingEntry)ModBuildings.netherWorker.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research alchemist = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/alchemist"), TECH).setParentResearch(netherminer).setTranslatedName("Magic Potions").setTranslatedSubtitle("These Romans are crazy").setIcon(ModBlocks.blockHutAlchemist.asItem()).addItemCost(Items.NETHER_WART, 16, this.provider).addEffect(((BuildingEntry)ModBuildings.alchemist.get()).getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/netherlog"), TECH).setParentResearch(netherminer).setTranslatedName("Gaze into the Pits").setTranslatedSubtitle("Always use proper lenses to avoid eye damage").setSortOrder(4).setIcon(Items.ENDER_EYE).addItemCost(Items.ENDER_EYE, 16, this.provider).addItemCost(ModItems.ancientTome, 1, this.provider).addBuildingRequirement("netherworker", 1).addEffect(ResearchConstants.NETHER_LOG, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/oceanheart"), TECH).setParentResearch(alchemist).setTranslatedName("Ocean's Heart").setTranslatedSubtitle("With great mystic power comes great mystic loot!").setSortOrder(4).setIcon(Items.FISHING_ROD).addBuildingRequirement("fisherman", 4).addItemCost(Items.HEART_OF_THE_SEA, 1, this.provider).addEffect(ResearchConstants.FISH_TREASURE, 1).addToList(r);
        AbstractResearchProvider.Research stoneCake = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/stonecake"), TECH).setTranslatedName("Stone Cake").setTranslatedSubtitle("Don't break a tooth!").setSortOrder(4).setIcon(ModBlocks.blockHutStonemason.asItem()).addBuildingRequirement("miner", 3).addItemCost(Items.CHISELED_STONE_BRICKS, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.stoneMason.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research rockingRoll = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rockingroll"), TECH).setParentResearch(stoneCake).setTranslatedName("Rocking Roll").setIcon(ModBlocks.blockHutCrusher.asItem()).addBuildingRequirement("stonemason", 1).addItemCost(Items.STONE, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.crusher.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research theFlintstones = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/theflintstones"), TECH).setParentResearch(stoneCake).setTranslatedName("The Flintstones").setTranslatedSubtitle("Yabba Dabba Doo!").setIcon(ModBlocks.blockHutStoneSmeltery.asItem()).addBuildingRequirement("stonemason", 1).addItemCost(Items.BRICK, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.stoneSmelter.get()).getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/knowtheend"), TECH).setParentResearch(theFlintstones).setTranslatedName("Know the End").setTranslatedSubtitle("Unlock the secrets of the most mysterious dimension.").setIcon(ModItems.chorusBread).addBuildingRequirement("baker", 3).addItemCost(Items.CHORUS_FRUIT, 64, this.provider).addEffect(new ResourceLocation("minecolonies", "effects/knowledgeoftheendunlock"), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/gildedhammer"), TECH).setParentResearch(rockingRoll).setTranslatedName("Gilded Hammer").setTranslatedSubtitle("When in doubt, cover in shiny stuff.").setIcon(Items.GOLD_BLOCK).addBuildingRequirement("crusher", 3).addItemCost(Items.GRAVEL, 64, this.provider).addItemCost(Items.SAND, 64, this.provider).addItemCost(Items.CLAY, 64, this.provider).addEffect(ResearchConstants.CRUSHING_11, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/depthknowledge"), TECH).setParentResearch(rockingRoll).setTranslatedName("Knowledge of the Depth").setTranslatedSubtitle("Gotta go deep for that one.").setIcon(Items.COBBLED_DEEPSLATE).addBuildingRequirement("crusher", 3).addItemCost(Items.DEEPSLATE, 64, this.provider).addEffect(ResearchConstants.THE_DEPTHS, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/pavetheroad"), TECH).setParentResearch(rockingRoll).setTranslatedName("Pave the Road").setTranslatedSubtitle("Not something you want to get mixed up in.").setSortOrder(2).setIcon(ModBlocks.blockHutConcreteMixer.asItem()).addBuildingRequirement("crusher", 1).addItemCost(ModTags.concreteItems, 32, this.provider).addEffect(((BuildingEntry)ModBuildings.concreteMixer.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research woodwork = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/woodwork"), TECH).setTranslatedName("Woodwork").setTranslatedSubtitle("Where oh where would a wood worker work if a wood worker would work wood?").setSortOrder(5).setIcon(ModBlocks.blockHutSawmill.asItem()).addBuildingRequirement("lumberjack", 3).addItemCost((TagKey<Item>)ItemTags.PLANKS, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.sawmill.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research stringWork = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/stringwork"), TECH).setParentResearch(woodwork).setTranslatedName("Stringwork").setIcon(ModBlocks.blockHutFletcher.asItem()).addBuildingRequirement("sawmill", 1).addItemCost(Items.STRING, 16, this.provider).addEffect(((BuildingEntry)ModBuildings.fletcher.get()).getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hotboots"), TECH).setParentResearch(stringWork).setTranslatedName("Hot Boots").setTranslatedSubtitle("Warmer on the outside.").setIcon(Items.CAMPFIRE).addBuildingRequirement("fletcher", 1).addItemCost(Items.LEATHER, 32, this.provider).addItemCost(Items.IRON_INGOT, 16, this.provider).addEffect(ResearchConstants.FIRE_RES, 1).addToList(r);
        AbstractResearchProvider.Research sieving = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/sieving"), TECH).setParentResearch(woodwork).setTranslatedName("Sieving").setTranslatedSubtitle("How did that get in there?").setSortOrder(2).setIcon(ModBlocks.blockHutSifter.asItem()).addBuildingRequirement("fisherman", 3).addItemCost(Items.STRING, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.sifter.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research space = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/space"), TECH).setParentResearch(sieving).setTranslatedName("Space").setTranslatedSubtitle("Antidisinterdimensionalitarianism!").setIcon(Items.CHEST).addBuildingRequirement("miner", 3).addItemCost(ModBlocks.blockRack.asItem(), 16, this.provider).addEffect(ResearchConstants.MINIMUM_STOCK, 1).addToList(r);
        AbstractResearchProvider.Research capacity = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/capacity"), TECH).setParentResearch(space).setTranslatedName("Capacity").setTranslatedSubtitle("Don't ask how we fit it all.").setIcon(Items.CHEST_MINECART).addBuildingRequirement("miner", 4).addItemCost(ModBlocks.blockRack.asItem(), 32, this.provider).addEffect(ResearchConstants.MINIMUM_STOCK, 2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/fullstock"), TECH).setParentResearch(capacity).setTranslatedName("Full Stock!").setTranslatedSubtitle("We might be able to squeeze in one more.").setIcon(Items.ENDER_CHEST).addBuildingRequirement("miner", 5).addItemCost(ModBlocks.blockRack.asItem(), 64, this.provider).addEffect(ResearchConstants.MINIMUM_STOCK, 3).addToList(r);
        AbstractResearchProvider.Research memoryAid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/memoryaid"), TECH).setParentResearch(woodwork).setTranslatedName("Memory Aid").setTranslatedSubtitle("It's the thought that counts.").setSortOrder(3).setIcon(Items.PAPER).addBuildingRequirement("sawmill", 1).addItemCost(Items.PAPER, 32, this.provider).addEffect(ResearchConstants.RECIPES, 1).addToList(r);
        AbstractResearchProvider.Research cheatSheet = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/cheatsheet"), TECH).setParentResearch(memoryAid).setTranslatedName("Cheat Sheet").setTranslatedSubtitle("So THAT's what I should be making!").setIcon(Items.BOOK).addBuildingRequirement("sawmill", 2).addItemCost(Items.PAPER, 64, this.provider).addEffect(ResearchConstants.RECIPES, 2).setSortOrder(1).addToList(r);
        AbstractResearchProvider.Research recipeBook = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/recipebook"), TECH).setParentResearch(cheatSheet).setTranslatedName("Recipe Book").setIcon(Items.ENCHANTED_BOOK).addBuildingRequirement("sawmill", 3).addItemCost(Items.PAPER, 128, this.provider).addEffect(ResearchConstants.RECIPES, 3).addToList(r);
        AbstractResearchProvider.Research rtm = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rtm"), TECH).setParentResearch(recipeBook).setTranslatedName("RTM").setTranslatedSubtitle("I saw some information on this somewhere...").setIcon(Items.BOOKSHELF).addBuildingRequirement("sawmill", 4).addItemCost(Items.PAPER, 256, this.provider).addEffect(ResearchConstants.RECIPES, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rainman"), TECH).setParentResearch(rtm).setTranslatedName("Rainman").setTranslatedSubtitle("Raindrops are falling on my head...").setIcon(Items.SPLASH_POTION).addItemCost(Items.SALMON_BUCKET, 27, this.provider).addEffect(ResearchConstants.WORKING_IN_RAIN, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/warehousemaster"), TECH).setParentResearch(memoryAid).setTranslatedName("Warehouse Master").setTranslatedSubtitle("So many items to choose from!").setIcon(ModBlocks.blockRack.asItem()).addBuildingRequirement("sawmill", 3).addItemCost(ModBlocks.blockRack.asItem(), 3, this.provider).addEffect(ResearchConstants.RECIPE_MODE, 1).setSortOrder(2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/buildermodes"), TECH).setParentResearch(memoryAid).setTranslatedName("Builder Modes").setTranslatedSubtitle("Possibility Overload!").setIcon(ModBlocks.blockHutBuilder.asItem()).addBuildingRequirement("builder", 3).addItemCost(Items.DIAMOND_AXE, 1, this.provider).addEffect(ResearchConstants.BUILDER_MODE, 1).setSortOrder(3).addToList(r);
        AbstractResearchProvider.Research deepPockets = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/deeppockets"), TECH).setParentResearch(cheatSheet).setTranslatedName("Deep Pockets").setSortOrder(2).setIcon(Items.PINK_SHULKER_BOX).addBuildingRequirement("library", 4).addItemCost(Items.EMERALD, 64, this.provider).addEffect(ResearchConstants.CITIZEN_INV_SLOTS, 1).addToList(r);
        AbstractResearchProvider.Research loaded = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/loaded"), TECH).setParentResearch(deepPockets).setTranslatedName("Loaded").setIcon(Items.RED_SHULKER_BOX).addBuildingRequirement("library", 5).addItemCost(Items.EMERALD, 128, this.provider).addEffect(ResearchConstants.CITIZEN_INV_SLOTS, 2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/heavilyloaded"), TECH).setParentResearch(loaded).setTranslatedName("Heavily Loaded").setIcon(Items.BLUE_SHULKER_BOX).setNoReset().addItemCost(Items.EMERALD, 256, this.provider).addEffect(ResearchConstants.CITIZEN_INV_SLOTS, 3).addToList(r);
        AbstractResearchProvider.Research hot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hot"), TECH).setTranslatedName("Hot!").setSortOrder(6).setIcon(ModBlocks.blockHutSmeltery.asItem()).addBuildingRequirement("miner", 2).addItemCost(Items.LAVA_BUCKET, 4, this.provider).addEffect(((BuildingEntry)ModBuildings.smeltery.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research isThisRedstone = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/isthisredstone"), TECH).setParentResearch(hot).setTranslatedName("Is This Redstone?").setIcon(Items.REDSTONE).addItemCost(Items.REDSTONE, 128, this.provider).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 1).addToList(r);
        AbstractResearchProvider.Research redstonePowered = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/redstonepowered"), TECH).setParentResearch(isThisRedstone).setTranslatedName("Redstone Powered").setTranslatedSubtitle("Like magic, but SCIENCE!").setIcon(Items.REDSTONE_TORCH).addItemCost(Items.REDSTONE, 256, this.provider).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 2).addToList(r);
        AbstractResearchProvider.Research heavyMachinery = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/heavymachinery"), TECH).setParentResearch(redstonePowered).setTranslatedName("Heavy Machinery").setIcon(Items.REDSTONE_BLOCK).addItemCost(Items.REDSTONE, 512, this.provider).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 3).addToList(r);
        AbstractResearchProvider.Research whatIsThisSpeed = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/whatisthisspeed"), TECH).setParentResearch(heavyMachinery).setTranslatedName("What Is This Speed?").setTranslatedSubtitle("We stopped trying to calculate it after a while.").setIcon(Items.COMPARATOR).addItemCost(Items.REDSTONE, 1024, this.provider).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/lightning"), TECH).setParentResearch(whatIsThisSpeed).setTranslatedName("Lightning").setTranslatedSubtitle("BAM! And the block is gone!").setIcon(Items.REPEATER).addItemCost(Items.REDSTONE, 2048, this.provider).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/thoselungs"), TECH).setParentResearch(hot).setTranslatedName("Those Lungs!").setTranslatedSubtitle("You'll definitely be needing those in some form.").setIcon(ModBlocks.blockHutGlassblower.asItem()).addBuildingRequirement("smeltery", 3).addItemCost(Items.GLASS, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.glassblower.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research hittingIron = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hittingiron"), TECH).setTranslatedName("Hitting Iron!").setSortOrder(7).setTranslatedSubtitle("We're still ironing out the details.").setIcon(ModBlocks.blockHutBlacksmith.asItem()).addBuildingRequirement("miner", 3).addItemCost(Items.ANVIL, 1, this.provider).addEffect(((BuildingEntry)ModBuildings.blacksmith.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research strong = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/strong"), TECH).setParentResearch(hittingIron).setTranslatedName("Strong").setIcon(Items.WOODEN_PICKAXE).addBuildingRequirement("blacksmith", 1).addItemCost(Items.DIAMOND, 8, this.provider).addEffect(ResearchConstants.TOOL_DURABILITY, 1).addToList(r);
        AbstractResearchProvider.Research hardened = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hardened"), TECH).setParentResearch(strong).setTranslatedName("Hardened").setIcon(Items.STONE_PICKAXE).addBuildingRequirement("blacksmith", 2).addItemCost(Items.DIAMOND, 16, this.provider).addEffect(ResearchConstants.TOOL_DURABILITY, 2).addToList(r);
        AbstractResearchProvider.Research reinforced = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/reinforced"), TECH).setParentResearch(hardened).setTranslatedName("Reinforced").setIcon(Items.IRON_PICKAXE).addBuildingRequirement("blacksmith", 3).addItemCost(Items.DIAMOND, 32, this.provider).addEffect(ResearchConstants.TOOL_DURABILITY, 3).addToList(r);
        AbstractResearchProvider.Research steelBracing = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/steelbracing"), TECH).setParentResearch(reinforced).setTranslatedName("Steel Bracing").setIcon(Items.GOLDEN_PICKAXE).addBuildingRequirement("blacksmith", 5).addItemCost(Items.DIAMOND, 64, this.provider).addEffect(ResearchConstants.TOOL_DURABILITY, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/diamondcoated"), TECH).setParentResearch(steelBracing).setTranslatedName("Diamond Coated").setIcon(Items.DIAMOND_PICKAXE).addItemCost(Items.DIAMOND, 128, this.provider).addEffect(ResearchConstants.TOOL_DURABILITY, 5).addToList(r);
        AbstractResearchProvider.Research ability = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/ability"), TECH).setParentResearch(hittingIron).setTranslatedName("Ability").setIcon(Items.GLOWSTONE_DUST).addBuildingRequirement("miner", 1).addItemCost(Items.IRON_INGOT, 64, this.provider).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 1).addToList(r);
        AbstractResearchProvider.Research skills = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/skills"), TECH).setParentResearch(ability).setTranslatedName("Skills").setTranslatedSubtitle("Everything in its place.").setIcon(Items.GLOWSTONE).addBuildingRequirement("miner", 2).addItemCost(Items.IRON_INGOT, 128, this.provider).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 2).addToList(r);
        AbstractResearchProvider.Research tools = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/tools"), TECH).setParentResearch(skills).setTranslatedName("Tools").setTranslatedSubtitle("Like breaking stuff, but in reverse!").setIcon(Items.REDSTONE_LAMP).addBuildingRequirement("blacksmith", 4).addItemCost(Items.IRON_INGOT, 256, this.provider).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 3).addToList(r);
        AbstractResearchProvider.Research seemsAutomatic = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/seemsautomatic"), TECH).setParentResearch(tools).setTranslatedName("Seems Automatic").setTranslatedSubtitle("It all happened so fast...").setIcon(Items.BLAZE_POWDER).addBuildingRequirement("blacksmith", 5).addItemCost(Items.IRON_INGOT, 512, this.provider).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/madness"), TECH).setParentResearch(seemsAutomatic).setTranslatedName("Madness!").setIcon(Items.SPECTRAL_ARROW).addItemCost(Items.IRON_INGOT, 1024, this.provider).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 5).addToList(r);
        AbstractResearchProvider.Research veinminer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/veinminer"), TECH).setParentResearch(hittingIron).setTranslatedName("Veinminer").setIcon(Items.IRON_BLOCK).addBuildingRequirement("miner", 1).addItemCost((TagKey<Item>)ItemTags.IRON_ORES, 32, this.provider).addEffect(ResearchConstants.MORE_ORES, 1).addToList(r);
        AbstractResearchProvider.Research goodVeins = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/goodveins"), TECH).setParentResearch(veinminer).setTranslatedName("Good Veins").setIcon(Items.COAL_BLOCK).addBuildingRequirement("miner", 2).addItemCost((TagKey<Item>)ItemTags.IRON_ORES, 64, this.provider).addEffect(ResearchConstants.MORE_ORES, 2).addToList(r);
        AbstractResearchProvider.Research richVeins = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/richveins"), TECH).setParentResearch(goodVeins).setTranslatedName("Rich Veins").setIcon(Items.GOLD_BLOCK).addBuildingRequirement("blacksmith", 4).addItemCost((TagKey<Item>)ItemTags.GOLD_ORES, 32, this.provider).addEffect(ResearchConstants.MORE_ORES, 3).addToList(r);
        AbstractResearchProvider.Research amazingVeins = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/amazingveins"), TECH).setParentResearch(richVeins).setTranslatedName("Amazing Veins").setIcon(Items.LAPIS_BLOCK).addBuildingRequirement("blacksmith", 5).addItemCost((TagKey<Item>)ItemTags.GOLD_ORES, 64, this.provider).addEffect(ResearchConstants.MORE_ORES, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/motherlode"), TECH).setParentResearch(amazingVeins).setTranslatedName("Motherlode").setIcon(Items.DIAMOND_BLOCK).addItemCost((TagKey<Item>)ItemTags.DIAMOND_ORES, 64, this.provider).addEffect(ResearchConstants.MORE_ORES, 5).addToList(r);
        AbstractResearchProvider.Research whatYaNeed = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/whatyaneed"), TECH).setParentResearch(hittingIron).setTranslatedName("What ya Need?").setTranslatedSubtitle("It's not a rhetorical question...").setIcon(ModBlocks.blockHutMechanic.asItem()).addBuildingRequirement("blacksmith", 3).addItemCost(Items.REDSTONE, 64, this.provider).addEffect(((BuildingEntry)ModBuildings.mechanic.get()).getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research enhanced_gates1 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/enhanced_gates1"), TECH).setParentResearch(whatYaNeed).setTranslatedName("Enhanced Gates I").setIcon(ModItems.woodgate).addItemCost(ModItems.woodgate, 64, this.provider).addItemCost(ModItems.ancientTome, 2, this.provider).addItemCost(Items.IRON_BLOCK, 5, this.provider).addEffect(ResearchConstants.MECHANIC_ENHANCED_GATES, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/enhanced_gates2"), TECH).setParentResearch(enhanced_gates1).setTranslatedName("Enhanced Gates II").setIcon(ModItems.irongate).addItemCost(ModItems.irongate, 64, this.provider).addItemCost(ModItems.ancientTome, 2, this.provider).addItemCost(Items.OBSIDIAN, 32, this.provider).addEffect(ResearchConstants.MECHANIC_ENHANCED_GATES, 2).addToList(r);
        return r;
    }

    public Collection<AbstractResearchProvider.Research> getAchievementResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research stringmesh = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/stringmesh"), UNLOCK).setTranslatedName("String Mesh").setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 1).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterstringunlock"), 1).addToList(r);
        AbstractResearchProvider.Research flintmesh = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/flintmesh"), UNLOCK).setTranslatedName("Flint Mesh").setParentResearch(stringmesh).setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 3).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterflintunlock"), 1).addToList(r);
        AbstractResearchProvider.Research ironmesh = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/ironmesh"), UNLOCK).setTranslatedName("Iron Mesh").setParentResearch(flintmesh).setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 4).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterironunlock"), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/diamondmesh"), UNLOCK).setTranslatedName("Diamond Mesh").setParentResearch(ironmesh).setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 5).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterdiamondunlock"), 1).addToList(r);
        return r;
    }
}

