/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CustomArrowEntity
extends Arrow {
    private static final int MAX_LIVE_TIME = 200;
    private static final int GROUND_LIVE_TIME = 40;
    private boolean armorPiercePlayer = false;
    private float waterInertia = 0.6f;
    private Predicate<EntityHitResult> onHitCallback = null;

    public CustomArrowEntity(EntityType<? extends Arrow> type, Level world) {
        super(type, world);
    }

    protected void doPostHurtEffects(LivingEntity target) {
        super.doPostHurtEffects(target);
    }

    protected float getWaterInertia() {
        return this.waterInertia;
    }

    public void setWaterInertia(float waterInertia) {
        this.waterInertia = waterInertia;
    }

    protected void onHitEntity(EntityHitResult traceResult) {
        Entity player;
        double prevDamage = this.getBaseDamage();
        float f = (float)this.getDeltaMovement().length();
        if (f != 0.0f) {
            this.setBaseDamage(prevDamage / (double)f);
        }
        if (this.armorPiercePlayer && (player = traceResult.getEntity()) instanceof Player) {
            Entity shooter = this.getOwner();
            DamageSource source = shooter == null ? this.level().damageSources().arrow((AbstractArrow)this, (Entity)this) : this.level().damageSources().arrow((AbstractArrow)this, shooter);
            player.hurt(source, (float)this.getBaseDamage());
            this.setBaseDamage(0.0);
        }
        super.onHitEntity(traceResult);
        this.setBaseDamage(prevDamage);
        if (this.onHitCallback != null && this.onHitCallback.test(traceResult)) {
            this.onHitCallback = null;
        }
    }

    public void setOnHitCallback(Predicate<EntityHitResult> onHitCallback) {
        this.onHitCallback = onHitCallback;
    }

    public void setPlayerArmorPierce() {
        this.armorPiercePlayer = true;
    }

    public boolean shouldFall() {
        if (this.inGround) {
            AABB aabb = new AABB(this.position(), this.position()).inflate(0.06);
            for (VoxelShape voxelshape : this.level().getBlockCollisions(null, aabb)) {
                if (voxelshape.isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean save(@NotNull CompoundTag nbt) {
        return false;
    }

    public void load(@NotNull CompoundTag nbt) {
        this.discard();
    }

    public void tick() {
        if (this.tickCount > 200) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.inGroundTime > 40) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.tick();
    }
}

