/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.aitasks;

import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMonster;
import com.minecolonies.api.entity.mobs.ICustomAttackSound;
import com.minecolonies.api.entity.mobs.IRangedMobEntity;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.CombatUtils;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.CustomArrowEntity;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class RaiderRangedAI<T extends AbstractEntityMinecoloniesMonster & IRangedMobEntity>
extends AttackMoveAI<T> {
    private static final int ATTACK_DELAY = 60;
    private static final int BOW_HOLDING_DELAY = 40;
    private static final double ARROW_PIERCE_DIFFICULTY = 3.0;
    private static final double COMBAT_MOVEMENT_SPEED = 1.1;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private int flightCounter = 0;

    public RaiderRangedAI(T owner, ITickRateStateMachine<IState> stateMachine) {
        super(owner, stateMachine);
    }

    @Override
    protected boolean isInDistanceForAttack(LivingEntity target) {
        this.flightCounter = EntityUtils.isFlying(target) ? ++this.flightCounter : 0;
        if (this.flightCounter > 5) {
            return true;
        }
        return super.isInAttackDistance(target);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        ((AbstractEntityMinecoloniesMonster)this.user).getNavigation().stop();
        AbstractArrow arrowEntity = CombatUtils.createArrowForShooter((LivingEntity)this.user);
        if (((IRangedMobEntity)((Object)((AbstractEntityMinecoloniesMonster)this.user))).penetrateFluids() && arrowEntity instanceof CustomArrowEntity) {
            CustomArrowEntity customArrowEntity = (CustomArrowEntity)arrowEntity;
            customArrowEntity.setWaterInertia(0.99f);
        }
        arrowEntity.setBaseDamage(((AbstractEntityMinecoloniesMonster)this.user).getAttribute((Holder)RaiderMobUtils.MOB_ATTACK_DAMAGE).getValue());
        if (this.flightCounter > 5 && arrowEntity instanceof CustomArrowEntity) {
            ((CustomArrowEntity)arrowEntity).setPlayerArmorPierce();
            arrowEntity.setRemainingFireTicks(4000);
            arrowEntity.setBaseDamage(10.0);
        }
        if (((AbstractEntityMinecoloniesMonster)this.user).getDifficulty() > 3.0) {
            arrowEntity.setPierceLevel((byte)2);
        }
        CombatUtils.shootArrow(arrowEntity, target, 10.0f);
        ((AbstractEntityMinecoloniesMonster)this.user).swing(InteractionHand.MAIN_HAND);
        ((AbstractEntityMinecoloniesMonster)this.user).stopUsingItem();
        SoundEvent attackSound = SoundEvents.SKELETON_SHOOT;
        if (arrowEntity instanceof ICustomAttackSound) {
            attackSound = ((ICustomAttackSound)arrowEntity).getAttackSound();
        }
        ((AbstractEntityMinecoloniesMonster)this.user).playSound(attackSound, 1.0f, (float)this.getRandomPitch());
    }

    private double getRandomPitch() {
        return 1.0 / (((AbstractEntityMinecoloniesMonster)this.user).getRandom().nextDouble() * 0.4 + 0.8);
    }

    @Override
    protected double getAttackDistance() {
        return 20.0 * Math.max(((AbstractEntityMinecoloniesMonster)this.user).getDifficulty(), 2.0);
    }

    @Override
    protected int getAttackDelay() {
        if (this.flightCounter > 5) {
            return 10;
        }
        return 60;
    }

    @Override
    public boolean canAttack() {
        if (this.nextAttackTime - 40L >= ((AbstractEntityMinecoloniesMonster)this.user).level().getGameTime() && !((AbstractEntityMinecoloniesMonster)this.user).isUsingItem() && !((AbstractEntityMinecoloniesMonster)this.user).getMainHandItem().isEmpty()) {
            ((AbstractEntityMinecoloniesMonster)this.user).startUsingItem(InteractionHand.MAIN_HAND);
        }
        return true;
    }

    @Override
    protected boolean checkForTarget() {
        boolean validTarget = super.checkForTarget();
        if (!validTarget && ((AbstractEntityMinecoloniesMonster)this.user).isUsingItem()) {
            ((AbstractEntityMinecoloniesMonster)this.user).stopUsingItem();
        }
        return validTarget;
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        EntityNavigationUtils.walkToPos((AbstractFastMinecoloniesEntity)this.user, target.blockPosition(), (int)this.getAttackDistance(), false, 1.1);
        return ((AbstractEntityMinecoloniesMonster)this.user).getNavigation().getPathResult();
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof EntityCitizen && !target.isInvisible() || target instanceof Player && !((Player)target).isCreative() && !target.isSpectator();
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return true;
    }
}

