/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.service;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobHealer;
import com.minecolonies.core.datalistener.model.Disease;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.ai.workers.util.Patient;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.core.network.messages.client.StreamParticleEffectMessage;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkHealer
extends AbstractEntityAIInteract<JobHealer, BuildingHospital> {
    private static final double BASE_XP_GAIN = 2.0;
    private static final int REQUEST_COUNT = 16;
    private Patient currentPatient = null;
    private int progressTicks = 0;
    private static final int MAX_PROGRESS_TICKS = 30;
    private ICitizenData remotePatient;
    private Player playerToHeal;

    public EntityAIWorkHealer(@NotNull JobHealer job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<AIWorkerState>(AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 1), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 20), new AITarget<Object>(AIWorkerState.CURE, this::cure, 20), new AITarget<Object>(AIWorkerState.FREE_CURE, this::freeCure, 20), new AITarget<Object>(AIWorkerState.CURE_PLAYER, this::curePlayer, 20), new AITarget<Object>(AIWorkerState.REQUEST_CURE, this::requestCure, 20), new AITarget<Object>(AIWorkerState.WANDER, this::wander, 20));
        this.worker.setCanPickUpLoot(true);
    }

    private IAIState decide() {
        if (!this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        BuildingHospital hospital = (BuildingHospital)this.building;
        for (AbstractEntityCitizen citizen : WorldUtil.getEntitiesWithinBuilding((Level)this.world, AbstractEntityCitizen.class, this.building, cit -> cit.getCitizenData().getCitizenDiseaseHandler().isSick())) {
            hospital.checkOrCreatePatientFile(citizen.getCivilianID());
        }
        for (Patient patient : hospital.getPatients()) {
            ICitizenData data = hospital.getColony().getCitizenManager().getCivilian(patient.getId());
            if (data == null || !data.getEntity().isPresent() || data.getEntity().isPresent() && !data.getEntity().get().getCitizenData().getCitizenDiseaseHandler().isSick()) {
                hospital.removePatientFile(patient);
                continue;
            }
            EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
            Disease disease = citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
            if (patient.getState() == Patient.PatientState.NEW) {
                this.currentPatient = patient;
                return AIWorkerState.REQUEST_CURE;
            }
            if (patient.getState() == Patient.PatientState.REQUESTED) {
                if (disease == null) {
                    this.currentPatient = patient;
                    return AIWorkerState.CURE;
                }
                if (this.testRandomCureChance()) {
                    this.currentPatient = patient;
                    return AIWorkerState.FREE_CURE;
                }
                if (citizen.getInventoryCitizen().hasSpace()) {
                    if (this.hasCureInInventory(disease, (IItemHandler)this.worker.getInventoryCitizen()) || this.hasCureInInventory(disease, ((BuildingHospital)this.building).getItemHandlerCap())) {
                        this.currentPatient = patient;
                        return AIWorkerState.CURE;
                    }
                    ImmutableList list = ((BuildingHospital)this.building).getOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(Stack.class));
                    ImmutableList completed = ((BuildingHospital)this.building).getCompletedRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Stack.class));
                    for (ItemStorage cure : disease.cureItems()) {
                        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Disease.hasCureItem(cure))) continue;
                        if (InventoryUtils.getCountFromBuilding((IBuilding)this.building, Disease.hasCureItem(cure)) >= cure.getAmount()) {
                            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(Disease.hasCureItem(cure), cure.getAmount());
                            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                        }
                        boolean hasCureRequested = false;
                        for (IRequest request : list) {
                            if (!Disease.isCureItem(((Stack)request.getRequest()).getStack(), cure)) continue;
                            hasCureRequested = true;
                            break;
                        }
                        for (IRequest request : completed) {
                            if (!Disease.isCureItem(((Stack)request.getRequest()).getStack(), cure)) continue;
                            hasCureRequested = true;
                            break;
                        }
                        if (hasCureRequested) continue;
                        patient.setState(Patient.PatientState.NEW);
                        break;
                    }
                } else {
                    data.triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.healer.fullinv", (Object[])new Object[0]), ChatPriority.BLOCKING));
                }
            }
            if (patient.getState() != Patient.PatientState.TREATED) continue;
            if (disease == null) {
                this.currentPatient = patient;
                return AIWorkerState.CURE;
            }
            if (this.hasCureInInventory(disease, (IItemHandler)citizen.getInventoryCitizen())) continue;
            patient.setState(Patient.PatientState.NEW);
            return AIWorkerState.DECIDE;
        }
        Iterator<Object> iterator = WorldUtil.getEntitiesWithinBuilding((Level)this.world, Player.class, this.building, player -> player.getHealth() < player.getMaxHealth() - 10.0f - (float)(2 * ((BuildingHospital)this.building).getBuildingLevel())).iterator();
        if (iterator.hasNext()) {
            Player player2;
            this.playerToHeal = player2 = (Player)iterator.next();
            return AIWorkerState.CURE_PLAYER;
        }
        ICitizenData data = ((BuildingHospital)this.building).getColony().getCitizenManager().getRandomCitizen();
        if (data.getEntity().isPresent() && (double)data.getEntity().get().getHealth() < 10.0 && BlockPosUtil.getDistance2D(data.getEntity().get().blockPosition(), ((BuildingHospital)this.building).getPosition()) < (long)(((BuildingHospital)this.building).getBuildingLevel() * 40)) {
            this.remotePatient = data;
            return AIWorkerState.WANDER;
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState requestCure() {
        if (this.currentPatient == null) {
            return AIWorkerState.DECIDE;
        }
        ICitizenData data = ((BuildingHospital)this.building).getColony().getCitizenManager().getCivilian(this.currentPatient.getId());
        if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenData().getCitizenDiseaseHandler().isSick()) {
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
        if (!this.walkToSafePos(citizen.blockPosition())) {
            return AIWorkerState.REQUEST_CURE;
        }
        Disease disease = citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
        if (disease == null) {
            this.currentPatient.setState(Patient.PatientState.REQUESTED);
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        ImmutableList list = ((BuildingHospital)this.building).getOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(Stack.class));
        ImmutableList completed = ((BuildingHospital)this.building).getCompletedRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Stack.class));
        for (ItemStorage cure : disease.cureItems()) {
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Disease.hasCureItem(cure)) || InventoryUtils.getCountFromBuilding((IBuilding)this.building, Disease.hasCureItem(cure)) > 0) continue;
            boolean hasRequest = false;
            for (IRequest request : list) {
                if (!Disease.isCureItem(((Stack)request.getRequest()).getStack(), cure)) continue;
                hasRequest = true;
                break;
            }
            for (IRequest request : completed) {
                if (!Disease.isCureItem(((Stack)request.getRequest()).getStack(), cure)) continue;
                hasRequest = true;
                break;
            }
            if (hasRequest) continue;
            this.worker.getCitizenData().createRequestAsync(new Stack(cure.getItemStack(), 16, 1));
        }
        this.currentPatient.setState(Patient.PatientState.REQUESTED);
        this.currentPatient = null;
        return AIWorkerState.DECIDE;
    }

    private IAIState cure() {
        if (this.currentPatient == null) {
            return AIWorkerState.DECIDE;
        }
        ICitizenData data = ((BuildingHospital)this.building).getColony().getCitizenManager().getCivilian(this.currentPatient.getId());
        if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenData().getCitizenDiseaseHandler().isSick()) {
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
        if (!this.walkToSafePos(data.getEntity().get().blockPosition())) {
            return AIWorkerState.CURE;
        }
        Disease disease = citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
        if (disease == null) {
            this.currentPatient = null;
            citizen.heal(10.0f);
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            return AIWorkerState.DECIDE;
        }
        if (!this.hasCureInInventory(disease, (IItemHandler)this.worker.getInventoryCitizen())) {
            if (this.hasCureInInventory(disease, ((BuildingHospital)this.building).getItemHandlerCap())) {
                for (ItemStorage cure : disease.cureItems()) {
                    if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Disease.hasCureItem(cure)) >= cure.getAmount()) continue;
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(Disease.hasCureItem(cure), 1);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
            }
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        if (!this.hasCureInInventory(disease, (IItemHandler)citizen.getInventoryCitizen())) {
            for (ItemStorage cure : disease.cureItems()) {
                if (InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventoryCitizen(), Disease.hasCureItem(cure)) >= cure.getAmount()) continue;
                if (!citizen.getInventoryCitizen().hasSpace()) {
                    data.triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.healer.fullinv", (Object[])new Object[0]), ChatPriority.BLOCKING));
                    this.currentPatient = null;
                    return AIWorkerState.DECIDE;
                }
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Disease.hasCureItem(cure), cure.getAmount(), (IItemHandler)citizen.getInventoryCitizen());
            }
        }
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.currentPatient.setState(Patient.PatientState.TREATED);
        this.currentPatient = null;
        return AIWorkerState.DECIDE;
    }

    private IAIState freeCure() {
        if (this.currentPatient == null) {
            return AIWorkerState.DECIDE;
        }
        ICitizenData data = ((BuildingHospital)this.building).getColony().getCitizenManager().getCivilian(this.currentPatient.getId());
        if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenData().getCitizenDiseaseHandler().isSick()) {
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
        if (!this.walkToSafePos(citizen.blockPosition())) {
            this.progressTicks = 0;
            return AIWorkerState.FREE_CURE;
        }
        ++this.progressTicks;
        if (this.progressTicks < 30) {
            new StreamParticleEffectMessage(this.worker.position().add(0.0, 2.0, 0.0), citizen.position(), ParticleTypes.HEART, this.progressTicks % 30, 30).sendToTrackingEntity((Entity)this.worker);
            new CircleParticleEffectMessage(this.worker.position().add(0.0, 2.0, 0.0), ParticleTypes.HEART, this.progressTicks).sendToTrackingEntity((Entity)this.worker);
            return this.getState();
        }
        this.progressTicks = 0;
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        citizen.getCitizenData().getCitizenDiseaseHandler().cure();
        this.currentPatient.setState(Patient.PatientState.TREATED);
        this.currentPatient = null;
        return AIWorkerState.DECIDE;
    }

    private IAIState curePlayer() {
        if (this.playerToHeal == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.walkToUnSafePos(this.playerToHeal.blockPosition())) {
            return this.getState();
        }
        this.playerToHeal.heal(this.playerToHeal.getMaxHealth() - this.playerToHeal.getHealth() - 5.0f - (float)((BuildingHospital)this.building).getBuildingLevel());
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.DECIDE;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.CURE;
    }

    private IAIState wander() {
        if (this.remotePatient == null || !this.remotePatient.getEntity().isPresent()) {
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)this.remotePatient.getEntity().get();
        if (!this.walkToUnSafePos(this.remotePatient.getEntity().get().blockPosition())) {
            return this.getState();
        }
        new CircleParticleEffectMessage(this.remotePatient.getEntity().get().position(), ParticleTypes.HEART, 1).sendToTrackingEntity((Entity)this.worker);
        citizen.heal(citizen.getMaxHealth() - citizen.getHealth() - 5.0f - (float)((BuildingHospital)this.building).getBuildingLevel());
        citizen.markDirty(10);
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        this.remotePatient = null;
        return AIWorkerState.START_WORKING;
    }

    private boolean testRandomCureChance() {
        return this.worker.getRandom().nextInt(3600) <= Math.max(1, this.getSecondarySkillLevel() / 20);
    }

    private boolean hasCureInInventory(Disease disease, IItemHandler handler) {
        for (ItemStorage cure : disease.cureItems()) {
            if (InventoryUtils.getItemCountInItemHandler(handler, Disease.hasCureItem(cure)) >= cure.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<BuildingHospital> getExpectedBuildingClass() {
        return BuildingHospital.class;
    }
}

