/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.CombatUtils;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class KnightCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final VisibleCitizenStatus KNIGHT_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/knight_combat.png"), "com.minecolonies.gui.visiblestatus.knight_combat");
    private static final int KNOCKBACK_CHANCE = 5;
    private final AbstractEntityAIGuard parentAI;
    private long lastAoeUseTime = 0L;
    private final int KNOCKBACK_COOLDOWN = 240;
    private final int MIN_TIME_TO_ATTACK = 8;
    private static final double COMBAT_SPEED = 1.0;

    public KnightCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        stateMachine.addTransition(new TickingTransition<IAIState>(CombatAIStates.ATTACKING, () -> true, this::attackProtect, 8));
    }

    protected IAIState attackProtect() {
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), Items.SHIELD);
        if (shieldSlot != -1 && this.target != null && this.target.isAlive() && this.nextAttackTime - ((EntityCitizen)this.user).level().getGameTime() >= 8L && ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0) {
            CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.user, InteractionHand.OFF_HAND, shieldSlot);
            ((EntityCitizen)this.user).startUsingItem(InteractionHand.OFF_HAND);
            ItemStack shieldStack = ((EntityCitizen)this.user).getInventoryCitizen().getHeldItem(InteractionHand.OFF_HAND);
            shieldStack.set(DataComponents.BANNER_PATTERNS, (Object)((EntityCitizen)this.user).getCitizenData().getColony().getColonyFlag());
            ((EntityCitizen)this.user).lookAt((Entity)this.target, 180.0f, 180.0f);
            ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        }
        return null;
    }

    @Override
    public boolean canAttack() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), (EquipmentTypeEntry)ModEquipmentTypes.sword.get(), 0, ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getMaxEquipmentLevel());
        if (weaponSlot != -1) {
            CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.user, InteractionHand.MAIN_HAND, weaponSlot);
            return true;
        }
        return false;
    }

    @Override
    protected void doAttack(LivingEntity target) {
        int fireLevel;
        if (((EntityCitizen)this.user).distanceTo((Entity)target) > 1.0f) {
            this.moveInAttackPosition(target);
        }
        ((EntityCitizen)this.user).swing(InteractionHand.MAIN_HAND);
        ((EntityCitizen)this.user).playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, (float)SoundUtils.getRandomPitch(((EntityCitizen)this.user).getRandom()));
        double damageToBeDealt = this.getAttackDamage();
        DamageSource source = target.level().damageSources().source(DamageSourceKeys.GUARD, (Entity)this.user);
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get()).booleanValue() && target instanceof Player) {
            source = target.level().damageSources().source(DamageSourceKeys.GUARD_PVP, (Entity)this.user);
        }
        if ((fireLevel = ((EntityCitizen)this.user).getItemInHand(InteractionHand.MAIN_HAND).getEnchantmentLevel(Utils.getRegistryValue(Enchantments.FIRE_ASPECT, ((EntityCitizen)this.user).level()))) > 0) {
            target.setRemainingFireTicks(fireLevel * 80 * 20);
        }
        if (((EntityCitizen)this.user).level().getGameTime() - this.lastAoeUseTime > 240L) {
            this.doAoeAttack(source, damageToBeDealt);
        }
        target.hurt(source, (float)damageToBeDealt);
        target.setLastHurtByMob((LivingEntity)this.user);
        if (target instanceof Mob && ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.KNIGHT_TAUNT) > 0.0) {
            ((Mob)target).setTarget((LivingEntity)this.user);
            if (target instanceof IThreatTableEntity) {
                ((IThreatTableEntity)target).getThreatTable().addThreat((LivingEntity)this.user, 5);
            }
        }
        ((EntityCitizen)this.user).stopUsingItem();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(KNIGHT_COMBAT);
        CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)this.user, InteractionHand.MAIN_HAND, 1);
    }

    private void doAoeAttack(DamageSource source, double damageToBeDealt) {
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.KNIGHT_WHIRLWIND) > 0.0 && ((EntityCitizen)this.user).getRandom().nextInt(5) == 0) {
            List entities = ((EntityCitizen)this.user).level().getEntitiesOfClass(LivingEntity.class, ((EntityCitizen)this.user).getBoundingBox().inflate(2.0, 0.5, 2.0));
            for (LivingEntity livingentity : entities) {
                if (livingentity == this.user || !this.isEntityValidTarget(livingentity) || livingentity instanceof ArmorStand) continue;
                livingentity.knockback(2.0, (double)Mth.sin((float)(livingentity.getYRot() * (float)Math.PI)), (double)(-Mth.cos((float)(livingentity.getYRot() * (float)Math.PI))));
                livingentity.hurt(source, (float)(damageToBeDealt / (double)entities.size()));
            }
            ((EntityCitizen)this.user).level().playSound(null, ((EntityCitizen)this.user).getX(), ((EntityCitizen)this.user).getY(), ((EntityCitizen)this.user).getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, ((EntityCitizen)this.user).getSoundSource(), 1.0f, 1.0f);
            double d0 = -Mth.sin((float)(((EntityCitizen)this.user).getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(((EntityCitizen)this.user).getYRot() * ((float)Math.PI / 180)));
            Level level = ((EntityCitizen)this.user).level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, ((EntityCitizen)this.user).getX() + d0, ((EntityCitizen)this.user).getY(0.5), ((EntityCitizen)this.user).getZ() + d1, 2, d0, 0.0, d1, 0.0);
            }
            this.lastAoeUseTime = ((EntityCitizen)this.user).level().getGameTime();
        }
    }

    private double getAttackDamage() {
        double addDmg = 0.0;
        ItemStack heldItem = ((EntityCitizen)this.user).getItemInHand(InteractionHand.MAIN_HAND);
        if (ItemStackUtils.doesItemServeAsWeapon(heldItem)) {
            addDmg = heldItem.getItem() instanceof SwordItem ? (addDmg += ((EntityCitizen)this.user).getAttribute(Attributes.ATTACK_DAMAGE).getValue()) : (addDmg += TinkersToolHelper.getDamage(heldItem));
            addDmg += (double)EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)((EntityCitizen)this.user).level()), (ItemStack)heldItem, (Entity)this.target, (DamageSource)((EntityCitizen)this.user).level().damageSources().mobAttack((LivingEntity)this.user), (float)((float)addDmg));
        }
        addDmg += ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_DAMAGE);
        if ((double)((EntityCitizen)this.user).getHealth() <= (double)((EntityCitizen)this.user).getMaxHealth() * 0.2) {
            addDmg *= 2.0;
        }
        if (ColonyConstants.rand.nextDouble() > 1.0 / (1.0 + ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GUARD_CRIT))) {
            addDmg *= 1.5;
            ((ServerLevel)((EntityCitizen)this.user).level()).getChunkSource().broadcastAndSend((Entity)this.user, (Packet)new ClientboundAnimatePacket((Entity)this.target, 4));
        }
        return addDmg * (Double)((ServerConfiguration)MineColonies.getConfig().getServer()).guardDamageMultiplier.get();
    }

    @Override
    protected double getAttackDistance() {
        return 2.0;
    }

    @Override
    protected int getAttackDelay() {
        int reload = 32 - ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 3;
        return Math.max(reload, 16);
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        EntityNavigationUtils.walkToPos((AbstractFastMinecoloniesEntity)this.user, target.blockPosition(), (int)this.getAttackDistance(), false, this.getCombatMovementSpeed());
        return ((EntityCitizen)this.user).getNavigation().getPathResult();
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.blockPosition(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).getSensing().hasLineOfSight((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)this.user, this.target, 1600);
    }

    @Override
    protected int getSearchRange() {
        return 16;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
        ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("mobs_killed", ((EntityCitizen)this.user).getCitizenColonyHandler().getColonyOrRegister().getDay());
        ComponentContents componentContents = entity.getType().getDescription().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            this.parentAI.building.getModule(BuildingModules.STATS_MODULE).increment("mob_killed;" + translatableContents.getKey());
        }
    }
}

