/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.datalistener.model.Disease;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.CircleParticleEffectMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class EntityAISickTask
implements IStateAI {
    private static final int MIN_DIST_TO_HUT = 5;
    private static final int MIN_DIST_TO_HOSPITAL = 3;
    private static final long MINIMUM_DISTANCE_TO_HOSPITAL = 10L;
    private static final int REQUIRED_TIME_TO_CURE = 60;
    private static final int CHANCE_FOR_RANDOM_CURE = 10;
    private static final int GOING_TO_BED_ATTEMPTS = 20;
    private final ICitizenData citizenData;
    private int waitingTicks = 0;
    private BlockPos usedBed;
    private final EntityCitizen citizen;
    private BlockPos bestHospital;

    public EntityAISickTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.citizenData = citizen.getCitizenData();
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.SICK, this::isSick, () -> DiseaseState.CHECK_FOR_CURE, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.CHECK_FOR_CURE, () -> true, this::checkForCure, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.WANDER, () -> true, this::wander, 200));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.CHECK_FOR_CURE, () -> true, this::checkForCure, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.GO_TO_HUT, () -> true, this::goToHut, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.SEARCH_HOSPITAL, () -> true, this::searchHospital, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.GO_TO_HOSPITAL, () -> true, this::goToHospital, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.WAIT_FOR_CURE, () -> true, this::waitForCure, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.APPLY_CURE, () -> true, this::applyCure, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(DiseaseState.FIND_EMPTY_BED, () -> true, this::findEmptyBed, 20));
    }

    private boolean isSick() {
        if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick() || this.citizen.getCitizenData().getCitizenDiseaseHandler().isHurt()) {
            this.reset();
            return true;
        }
        return false;
    }

    public DiseaseState wander() {
        EntityNavigationUtils.walkToRandomPos(this.citizen, 10, 0.6);
        return DiseaseState.CHECK_FOR_CURE;
    }

    private DiseaseState findEmptyBed() {
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.ZERO)) {
                this.usedBed = null;
            }
        }
        BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
        IColony colony = this.citizen.getCitizenColonyHandler().getColonyOrRegister();
        IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
        if (hospital instanceof BuildingHospital) {
            if (this.usedBed != null && !((BuildingHospital)hospital).getBedList().contains(this.usedBed)) {
                this.usedBed = null;
            }
            if (this.usedBed == null) {
                for (BlockPos pos : ((BuildingHospital)hospital).getBedList()) {
                    Level world = this.citizen.level();
                    BlockState state = world.getBlockState(pos);
                    if (!state.is(BlockTags.BEDS) || ((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue() || !((BedPart)state.getValue((Property)BedBlock.PART)).equals((Object)BedPart.HEAD) || !world.isEmptyBlock(pos.above())) continue;
                    this.citizen.getCitizenData().getCitizenDiseaseHandler().setSleepsAtHospital(true);
                    this.usedBed = pos;
                    ((BuildingHospital)hospital).registerPatient(this.usedBed, this.citizen.getCivilianID());
                    return DiseaseState.FIND_EMPTY_BED;
                }
                if (this.usedBed == null) {
                    return DiseaseState.WAIT_FOR_CURE;
                }
            }
            if (EntityNavigationUtils.walkToPosInBuilding(this.citizen, this.usedBed, hospital, 3)) {
                ++this.waitingTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    ((BuildingHospital)hospital).registerPatient(this.usedBed, 0);
                    this.citizen.getCitizenData().setBedPos(BlockPos.ZERO);
                    this.usedBed = null;
                }
            }
        }
        if (this.waitingTicks > 20) {
            this.waitingTicks = 0;
            return DiseaseState.WAIT_FOR_CURE;
        }
        return DiseaseState.FIND_EMPTY_BED;
    }

    private IState applyCure() {
        if (this.checkForCure() != DiseaseState.APPLY_CURE) {
            return DiseaseState.CHECK_FOR_CURE;
        }
        Disease disease = this.citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
        if (disease == null) {
            return CitizenAIState.IDLE;
        }
        List<ItemStorage> list = disease.cureItems();
        if (!list.isEmpty()) {
            this.citizen.setItemInHand(InteractionHand.MAIN_HAND, list.get(this.citizen.getRandom().nextInt(list.size())).getItemStack());
        }
        this.citizen.swing(InteractionHand.MAIN_HAND);
        this.citizen.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_HARP.value(), 1.0f, (float)SoundUtils.getRandomPentatonic(this.citizen.getRandom()));
        new CircleParticleEffectMessage(this.citizen.position().add(0.0, 2.0, 0.0), ParticleTypes.HAPPY_VILLAGER, this.waitingTicks).sendToTrackingEntity((Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 60) {
            return DiseaseState.APPLY_CURE;
        }
        this.cure();
        return CitizenAIState.IDLE;
    }

    private void cure() {
        Disease disease = this.citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
        if (disease != null) {
            for (ItemStorage cure : disease.cureItems()) {
                int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((IItemHandlerCapProvider)this.citizen, Disease.hasCureItem(cure));
                if (slot == -1) continue;
                this.citizenData.getInventory().extractItem(slot, 1, false);
            }
        }
        if (this.usedBed != null) {
            BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
            IColony colony = this.citizen.getCitizenColonyHandler().getColonyOrRegister();
            IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
            ((BuildingHospital)hospital).registerPatient(this.usedBed, 0);
            this.usedBed = null;
            this.citizen.getCitizenData().setBedPos(BlockPos.ZERO);
        }
        this.citizen.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        this.citizen.getCitizenData().getCitizenDiseaseHandler().cure();
        this.citizen.setHealth(this.citizen.getMaxHealth());
        this.reset();
    }

    private IState waitForCure() {
        IBuilding building;
        BlockPos hospital;
        IColony colony = this.citizenData.getColony();
        this.bestHospital = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
        if (this.bestHospital == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        IState state = this.checkForCure();
        if (state == DiseaseState.APPLY_CURE) {
            return DiseaseState.APPLY_CURE;
        }
        if (state == CitizenAIState.IDLE) {
            this.reset();
            return CitizenAIState.IDLE;
        }
        if (this.citizen.getRandom().nextInt(10000) < 10) {
            this.cure();
            return CitizenAIState.IDLE;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() && (hospital = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class)) != null && (building = colony.getBuildingManager().getBuilding(hospital)) instanceof BuildingHospital && !((BuildingHospital)building).getBedList().contains(this.citizen.getCitizenSleepHandler().getBedLocation())) {
            this.citizen.getCitizenSleepHandler().onWakeUp();
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep() && BlockPosUtil.getDistance2D(this.bestHospital, this.citizen.blockPosition()) > 10L) {
            return DiseaseState.GO_TO_HOSPITAL;
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep()) {
            return DiseaseState.FIND_EMPTY_BED;
        }
        return DiseaseState.WAIT_FOR_CURE;
    }

    private IState goToHut() {
        IBuilding buildingWorker = this.citizenData.getWorkBuilding();
        this.citizen.getCitizenData().getCitizenDiseaseHandler().setSleepsAtHospital(false);
        if (buildingWorker == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() || EntityNavigationUtils.walkToBuilding(this.citizen, buildingWorker)) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        return DiseaseState.GO_TO_HUT;
    }

    private IState goToHospital() {
        this.citizen.getCitizenData().getCitizenDiseaseHandler().setSleepsAtHospital(false);
        if (this.bestHospital == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() || EntityNavigationUtils.walkToPos(this.citizen, this.bestHospital, 3, true)) {
            return DiseaseState.WAIT_FOR_CURE;
        }
        return DiseaseState.SEARCH_HOSPITAL;
    }

    private IState searchHospital() {
        IColony colony = this.citizenData.getColony();
        Disease disease = this.citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
        this.bestHospital = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
        if (this.bestHospital == null) {
            if (disease == null) {
                return CitizenAIState.IDLE;
            }
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatable((String)"com.minecolonies.coremod.ai.nohospital", (Object[])new Object[]{disease.name(), disease.getCureString()}), (Component)Component.translatable((String)"com.minecolonies.coremod.ai.nohospital"), ChatPriority.BLOCKING));
            return DiseaseState.WANDER;
        }
        if (disease != null) {
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatable((String)"com.minecolonies.coremod.ai.waitingforcure", (Object[])new Object[]{disease.name(), disease.getCureString()}), (Component)Component.translatable((String)"com.minecolonies.coremod.ai.waitingforcure"), ChatPriority.BLOCKING));
        }
        return DiseaseState.GO_TO_HOSPITAL;
    }

    private IState checkForCure() {
        Disease disease = this.citizen.getCitizenData().getCitizenDiseaseHandler().getDisease();
        if (disease == null) {
            if ((double)this.citizen.getHealth() > 6.0) {
                this.reset();
                return CitizenAIState.IDLE;
            }
            return DiseaseState.GO_TO_HUT;
        }
        for (ItemStorage cure : disease.cureItems()) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((IItemHandlerCapProvider)this.citizen, Disease.hasCureItem(cure));
            if (slot != -1) continue;
            if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick()) {
                return DiseaseState.GO_TO_HUT;
            }
            this.reset();
            return CitizenAIState.IDLE;
        }
        return DiseaseState.APPLY_CURE;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.citizen.releaseUsingItem();
        this.citizen.stopUsingItem();
        this.citizen.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        this.bestHospital = null;
        this.citizen.getCitizenData().getCitizenDiseaseHandler().setSleepsAtHospital(false);
    }

    public void start() {
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SICK);
    }

    public static enum DiseaseState implements IState
    {
        CHECK_FOR_CURE,
        GO_TO_HUT,
        SEARCH_HOSPITAL,
        GO_TO_HOSPITAL,
        WAIT_FOR_CURE,
        FIND_EMPTY_BED,
        APPLY_CURE,
        WANDER;

    }
}

