/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.datalistener.model.Disease;
import com.minecolonies.core.network.messages.client.colony.GlobalDiseaseSyncMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedRandomList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiseasesListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String KEY_NAME = "name";
    private static final String KEY_RARITY = "rarity";
    private static final String KEY_ITEMS = "items";
    private static WeightedRandomList<Disease> DISEASES = WeightedRandomList.create();

    public DiseasesListener() {
        super(GSON, "colony/diseases");
    }

    public static void sendGlobalDiseasesPackets(ServerPlayer player) {
        RegistryFriendlyByteBuf byteBuf = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), player.level().registryAccess());
        byteBuf.writeInt(DISEASES.unwrap().size());
        for (Disease disease : DISEASES.unwrap()) {
            byteBuf.writeResourceLocation(disease.id());
            Utils.serializeCodecMess(ComponentSerialization.STREAM_CODEC, byteBuf, disease.name());
            byteBuf.writeInt(disease.rarity());
            byteBuf.writeInt(disease.cureItems().size());
            for (ItemStorage cureItem : disease.cureItems()) {
                StandardFactoryController.getInstance().serialize(byteBuf, cureItem);
            }
        }
        new GlobalDiseaseSyncMessage(byteBuf).sendToPlayer(player);
    }

    public static void readGlobalDiseasesPackets(RegistryFriendlyByteBuf byteBuf) {
        ArrayList<Disease> newDiseases = new ArrayList<Disease>();
        int size = byteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = byteBuf.readResourceLocation();
            Component name = (Component)Utils.deserializeCodecMess(ComponentSerialization.STREAM_CODEC, byteBuf);
            int rarity = byteBuf.readInt();
            ArrayList<ItemStorage> cureItems = new ArrayList<ItemStorage>();
            int itemCount = byteBuf.readInt();
            for (int j = 0; j < itemCount; ++j) {
                cureItems.add((ItemStorage)StandardFactoryController.getInstance().deserialize(byteBuf));
            }
            newDiseases.add(new Disease(id, name, rarity, cureItems));
        }
        DISEASES = WeightedRandomList.create(newDiseases);
    }

    @NotNull
    public static List<Disease> getDiseases() {
        return DISEASES.unwrap();
    }

    @Nullable
    public static Disease getDisease(ResourceLocation id) {
        for (Disease disease : DISEASES.unwrap()) {
            if (!disease.id().equals((Object)id)) continue;
            return disease;
        }
        return null;
    }

    @Nullable
    public static Disease getRandomDisease(RandomSource random) {
        return DISEASES.getRandom(random).orElse(null);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ArrayList<Disease> diseases = new ArrayList<Disease>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                return;
            }
            JsonObject object = entry.getValue().getAsJsonObject();
            MutableComponent name = Component.translatable((String)GsonHelper.getAsString((JsonObject)object, (String)KEY_NAME));
            int rarity = GsonHelper.getAsInt((JsonObject)object, (String)KEY_RARITY);
            ArrayList<ItemStorage> cureItems = new ArrayList<ItemStorage>();
            for (JsonElement jsonElement : object.getAsJsonArray(KEY_ITEMS)) {
                if (!jsonElement.isJsonObject()) continue;
                ItemStorage cureItem = new ItemStorage(this.getRegistryLookup(), jsonElement.getAsJsonObject());
                cureItem.setAmount(1);
                cureItems.add(cureItem);
            }
            diseases.add(new Disease(entry.getKey(), (Component)name, rarity, cureItems));
        }
        DISEASES = WeightedRandomList.create(diseases);
    }
}

