/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.ModRecipeTypes;
import com.minecolonies.core.compatibility.jei.RenderHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FloristRecipeCategory
extends JobBasedRecipeCategory<FloristRecipe> {
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;
    private static final int MAX_LOOT_SLOTS = 24;

    public FloristRecipeCategory(@NotNull IGuiHelper guiHelper) {
        super(((JobEntry)ModJobs.florist.get()).produceJob(null), ModRecipeTypes.FLOWERS, new ItemStack(((BuildingEntry)ModBuildings.florist.get()).getBuildingBlock()), guiHelper);
    }

    @Override
    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull FloristRecipe recipe) {
        return Collections.singletonList(Component.translatable((String)"com.minecolonies.coremod.jei.onelevelrestriction", (Object[])new Object[]{recipe.level()}));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull FloristRecipe recipe, @NotNull IFocusGroup focuses) {
        int startX;
        builder.addSlot(RecipeIngredientRole.CATALYST, 149, 26).setSlotName("compost").setBackground((IDrawable)this.slot, -1, -1).addItemStack(new ItemStack((ItemLike)ModItems.compost));
        int initialColumns = 114 / this.slot.getWidth();
        int rows = (recipe.flowers().size() + initialColumns - 1) / initialColumns;
        int columns = (recipe.flowers().size() + rows - 1) / rows;
        int x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
        int y = 117 - rows * this.slot.getHeight() + 1;
        int c = 0;
        for (List<ItemStack> flowers : recipe.flowers()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.chanceSlot, -1, -1).addItemStacks(flowers);
            if (++c >= columns) {
                c = 0;
                x = startX;
                y += this.slot.getHeight();
                continue;
            }
            x += this.slot.getWidth();
        }
    }

    @Override
    public void draw(@NotNull FloristRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, stack, mouseX, mouseY);
        BlockState block = ModBlocks.blockCompostedDirt.defaultBlockState();
        RenderHelper.renderBlock(stack, block, 129.0f, 26.0f, 100.0f, -30.0f, 30.0f, 16.0f);
    }

    @NotNull
    public static List<FloristRecipe> findRecipes() {
        ArrayList<FloristRecipe> recipes = new ArrayList<FloristRecipe>();
        for (int level = 1; level <= 5; ++level) {
            recipes.add(new FloristRecipe(level, FloristRecipeCategory.compactify(BuildingFlorist.getPlantablesForBuildingLevel(level))));
        }
        return recipes;
    }

    private static List<List<ItemStack>> compactify(@NotNull Set<ItemStorage> flowers) {
        ArrayList<List<ItemStack>> slots = new ArrayList<List<ItemStack>>();
        List<ItemStack> flowerList = flowers.stream().map(ItemStorage::getItemStack).toList();
        if (flowerList.size() < 24) {
            for (ItemStack item : flowerList) {
                slots.add(List.of(item));
            }
        } else {
            int itemsPerList = flowerList.size() / 24;
            int extraItems = flowerList.size() % 24;
            int currentIndex = 0;
            for (int i = 0; i < 24; ++i) {
                ArrayList<ItemStack> sublist = new ArrayList<ItemStack>();
                for (int j = 0; j < itemsPerList; ++j) {
                    sublist.add(flowerList.get(currentIndex++));
                }
                if (extraItems > 0) {
                    sublist.add(flowerList.get(currentIndex++));
                    --extraItems;
                }
                slots.add(sublist);
            }
        }
        return slots;
    }

    public record FloristRecipe(int level, @NotNull List<List<ItemStack>> flowers) {
    }
}

