/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic.TreeSidePlantModule;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CocoaPlantModule
extends TreeSidePlantModule {
    public CocoaPlantModule(IField field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public ResourceLocation getRequiredResearchEffect() {
        return ResearchConstants.PLANTATION_JUNGLE;
    }

    @Override
    public BlockState getPlantingBlockState(Level world, BlockPos workPosition, BlockState blockState) {
        return Stream.of(workPosition.north(), workPosition.south(), workPosition.west(), workPosition.east()).filter(position -> world.getBlockState(position).getBlock() == Blocks.JUNGLE_LOG).map(position -> BlockPosUtil.directionFromDelta(position.subtract((Vec3i)workPosition).getX(), position.subtract((Vec3i)workPosition).getY(), position.subtract((Vec3i)workPosition).getZ())).map(direction -> (BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)).findFirst().orElse(blockState);
    }

    @Override
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.axe.get();
    }

    @Override
    protected boolean isValidClearingBlock(BlockState blockState) {
        return blockState.getBlock() != Blocks.COCOA;
    }

    @Override
    protected boolean isValidHarvestBlock(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof CocoaBlock) {
            CocoaBlock cocoa = (CocoaBlock)block;
            return (Integer)blockState.getValue((Property)CocoaBlock.AGE) >= 2;
        }
        return false;
    }
}

