/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.SwitchRecipeCraftingTeachingMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WindowCrafting
extends AbstractContainerScreen<ContainerCrafting> {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("minecolonies", "textures/gui/crafting2x2.png");
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES3X3 = new ResourceLocation("minecolonies", "textures/gui/crafting3x3.png");
    private static final WidgetSprites CRAFTING_SWITCH = new WidgetSprites(new ResourceLocation("minecolonies", "craftingswitch"), new ResourceLocation("minecolonies", "craftingswitch_hover"));
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SWITCH_WIDTH = 20;
    private static final int SWITCH_HEIGHT = 18;
    private static final int SWITCH_X_OFFSET = 148;
    private static final int SWITCH_Y_OFFSET = 34;
    private static final int GUI_COLOR = 0x404040;
    private static final int X_OFFSET = 97;
    private static final int Y_OFFSET = 8;
    private static final int CRAFTING_GRID_SIZE = 4;
    private static final int MAX_CRAFTING_GRID_SIZE = 9;
    private final AbstractBuildingView building;
    private final boolean completeCrafting;
    private final CraftingModuleView module;
    private ImageButton switchButton;

    public WindowCrafting(ContainerCrafting container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.player.level().dimension(), container.getPos());
        this.module = (CraftingModuleView)this.building.getModuleView(container.getModuleId());
        this.completeCrafting = this.module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get());
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    public boolean isCompleteCrafting() {
        return this.completeCrafting;
    }

    protected void init() {
        super.init();
        MutableComponent buttonDisplay = Component.translatableEscape((String)(this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"), (Object[])new Object[0]);
        Button doneButton = Button.builder((Component)buttonDisplay, this::onDoneClicked).pos(this.leftPos + 1, this.topPos + 170).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get())) {
            doneButton.active = false;
        }
        this.switchButton = new ImageButton(this.leftPos + 148, this.topPos + 34, 20, 18, CRAFTING_SWITCH, btn -> new SwitchRecipeCraftingTeachingMessage().sendToServer());
        this.switchButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.switchButton);
    }

    protected void containerTick() {
        super.containerTick();
        this.switchButton.visible = ((ContainerCrafting)this.menu).canSwitchRecipes();
    }

    private void onDoneClicked(Button button) {
        if (this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get())) {
            LinkedList<ItemStorage> input = new LinkedList<ItemStorage>();
            for (int i = 0; i < (this.completeCrafting ? 9 : 4); ++i) {
                ItemStack stack = ((ContainerCrafting)this.menu).craftMatrix.getItem(i);
                ItemStack copy = stack.copy();
                ItemStackUtils.setSize(copy, 1);
                input.add(new ItemStorage(copy));
            }
            ItemStack primaryOutput = ((ContainerCrafting)this.menu).craftResult.getItem(0).copy();
            List<ItemStack> secondaryOutputs = ((ContainerCrafting)this.menu).getRemainingItems();
            if (!ItemStackUtils.isEmpty(primaryOutput)) {
                new AddRemoveRecipeMessage((IBuildingView)this.building, input, this.completeCrafting ? 3 : 2, primaryOutput, secondaryOutputs, false, this.module.getProducer().getRuntimeID()).sendToServer();
            }
        }
    }

    protected void renderLabels(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.drawString(this.font, Component.translatableEscape((String)"container.crafting", (Object[])new Object[0]).getString(), 97, 8, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = this.completeCrafting ? CRAFTING_TABLE_GUI_TEXTURES3X3 : CRAFTING_TABLE_GUI_TEXTURES;
        stack.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics stack, int x, int y, float z) {
        super.render(stack, x, y, z);
        this.renderTooltip(stack, x, y);
    }
}

