/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.tileentities.TileEntityRack;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FoodUtils {
    public static final Predicate<ItemStack> EDIBLE = itemStack -> ItemStackUtils.ISFOOD.test((ItemStack)itemStack) && !ItemStackUtils.ISCOOKABLE.test((ItemStack)itemStack);

    public static boolean canEat(ItemStack stack, IBuilding homeBuilding, IBuilding workBuilding) {
        if (!EDIBLE.test(stack)) {
            return false;
        }
        int homeBuildingLevel = homeBuilding == null ? 0 : homeBuilding.getBuildingLevel();
        return FoodUtils.canEatLevel(stack, homeBuildingLevel) && (workBuilding == null || workBuilding.canEat(stack));
    }

    public static boolean canEatLevel(ItemStack stack, int buildingLevel) {
        if (buildingLevel < 3) {
            return stack.getItem().getFoodProperties(stack, null) != null;
        }
        FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, null);
        return foodProperties != null && foodProperties.nutrition() >= buildingLevel + 1;
    }

    public static int getBuildingLevelForFood(ItemStack resource) {
        return Math.max(2, Math.min(resource.getFoodProperties(null).nutrition() - 1, 5));
    }

    public static double getFoodValue(ItemStack foodStack, @Nullable FoodProperties itemFood, int housingLevel, double researchBonus) {
        if (itemFood == null) {
            return 0.0;
        }
        double saturationNerf = foodStack.getItem() instanceof IMinecoloniesFoodItem ? 1.0 : 1.0 / (double)(housingLevel + 1);
        return (double)itemFood.nutrition() * saturationNerf * (1.0 + researchBonus) / 2.0;
    }

    public static double getFoodValue(ItemStack foodStack, AbstractEntityCitizen citizen) {
        FoodProperties itemFood = foodStack.getItem().getFoodProperties(foodStack, (LivingEntity)citizen);
        int housingLevel = citizen.getCitizenData().getHomeBuilding() == null ? 0 : citizen.getCitizenData().getHomeBuilding().getBuildingLevel();
        double researchBonus = citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION);
        return FoodUtils.getFoodValue(foodStack, itemFood, housingLevel, researchBonus);
    }

    public static int getBestFoodForCitizen(InventoryCitizen inventoryCitizen, ICitizenData citizenData, @Nullable Set<ItemStorage> menu) {
        int bestScore = Integer.MAX_VALUE;
        int bestSlot = -1;
        Item bestItem = null;
        ICitizenFoodHandler foodHandler = citizenData.getCitizenFoodHandler();
        ICitizenFoodHandler.CitizenFoodStats foodStats = foodHandler.getFoodHappinessStats();
        int diversityRequirement = FoodUtils.getMinFoodDiversityRequirement(citizenData.getHomeBuilding() == null ? 0 : citizenData.getHomeBuilding().getBuildingLevel());
        int qualityRequirement = FoodUtils.getMinFoodQualityRequirement(citizenData.getHomeBuilding() == null ? 0 : citizenData.getHomeBuilding().getBuildingLevel());
        for (int i = 0; i < inventoryCitizen.getSlots(); ++i) {
            ItemStorage invStack = new ItemStorage(inventoryCitizen.getStackInSlot(i));
            if (menu != null && !menu.contains(invStack) || !FoodUtils.canEat(invStack.getItemStack(), citizenData.getHomeBuilding(), citizenData.getWorkBuilding())) continue;
            boolean isMinecolfood = invStack.getItem() instanceof IMinecoloniesFoodItem;
            int localScore = foodHandler.checkLastEaten(invStack.getItem()) * (isMinecolfood ? 2 : 1);
            if (menu == null && foodHandler.getLastEaten() == invStack.getItem()) continue;
            if (localScore < 0 && isMinecolfood || localScore < 0 && foodStats.quality() > qualityRequirement * 2 || isMinecolfood && foodStats.diversity() > diversityRequirement * 2) {
                return i;
            }
            if (localScore >= bestScore) continue;
            bestScore = localScore;
            bestSlot = i;
            bestItem = invStack.getItem();
        }
        if (menu == null && (bestScore >= 0 && foodStats.diversity() <= diversityRequirement || !(bestItem instanceof IMinecoloniesFoodItem) && foodStats.quality() <= qualityRequirement)) {
            return -1;
        }
        return bestSlot;
    }

    public static ItemStorage checkForFoodInBuilding(ICitizenData citizenData, @Nullable Set<ItemStorage> menu, IBuilding building) {
        int bestScore = Integer.MAX_VALUE;
        ItemStorage bestStorage = null;
        Level world = building.getColony().getWorld();
        int homeBuildingLevel = citizenData.getHomeBuilding() == null ? 0 : citizenData.getHomeBuilding().getBuildingLevel();
        ICitizenFoodHandler.CitizenFoodStats foodStats = citizenData.getCitizenFoodHandler().getFoodHappinessStats();
        int diversityRequirement = FoodUtils.getMinFoodDiversityRequirement(citizenData.getHomeBuilding() == null ? 0 : citizenData.getHomeBuilding().getBuildingLevel());
        int qualityRequirement = FoodUtils.getMinFoodQualityRequirement(citizenData.getHomeBuilding() == null ? 0 : citizenData.getHomeBuilding().getBuildingLevel());
        boolean criticalDiversity = foodStats.diversity() <= diversityRequirement;
        boolean criticalQuality = foodStats.quality() <= qualityRequirement;
        ICitizenFoodHandler foodHandler = citizenData.getCitizenFoodHandler();
        for (BlockPos pos : building.getContainers()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.getBlockEntity(pos)) instanceof TileEntityRack)) continue;
            TileEntityRack rackEntity = (TileEntityRack)entity;
            for (ItemStorage storage : rackEntity.getAllContent().keySet()) {
                if (menu != null && !menu.contains(storage) || !FoodUtils.canEat(storage.getItemStack(), citizenData.getHomeBuilding(), citizenData.getWorkBuilding())) continue;
                boolean isMinecolfood = storage.getItem() instanceof IMinecoloniesFoodItem;
                int localScore = foodHandler.checkLastEaten(storage.getItem());
                if (localScore < 0 && isMinecolfood && (criticalDiversity || criticalQuality)) {
                    return new ItemStorage(storage.getItemStack().copy());
                }
                if (localScore > bestScore) continue;
                if (isMinecolfood && !criticalQuality && MathUtils.RANDOM.nextInt(Math.max(1, ((IMinecoloniesFoodItem)storage.getItem()).getTier() + 2 - homeBuildingLevel)) <= 0) {
                    bestScore = localScore;
                    bestStorage = storage;
                    continue;
                }
                bestScore = localScore * (isMinecolfood ? 2 : 1);
                bestStorage = storage;
                if (!(localScore < 0 && isMinecolfood || localScore < 0 && foodStats.quality() > qualityRequirement * 2) && (!isMinecolfood || foodStats.diversity() <= diversityRequirement * 2)) continue;
                return new ItemStorage(storage.getItemStack().copy());
            }
        }
        if (bestStorage == null) {
            return null;
        }
        return new ItemStorage(bestStorage.getItemStack().copy());
    }

    public static int getMinFoodQualityRequirement(int buildingLevel) {
        return Math.max(0, buildingLevel - 2);
    }

    public static int getMinFoodDiversityRequirement(int buildingLevel) {
        return buildingLevel;
    }

    public static ItemStack consumeFoodStack(ItemStack foodStack, AbstractEntityCitizen citizen) {
        FoodProperties food = foodStack.getFoodProperties((LivingEntity)citizen);
        if (food != null) {
            ItemStack consumedStack = foodStack.finishUsingItem(citizen.level(), (LivingEntity)citizen);
            Optional returned = food.usingConvertsTo();
            if (returned.isPresent()) {
                return ((ItemStack)returned.get()).copy();
            }
            if (foodStack.getItem() instanceof HoneyBottleItem) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            if (consumedStack.getItem() != foodStack.getItem()) {
                return consumedStack;
            }
        }
        return ItemStack.EMPTY;
    }
}

