/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.effects.registry;

import com.minecolonies.api.research.effects.IResearchEffect;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ResearchEffectEntry {
    private final Function<CompoundTag, IResearchEffect<?>> readFromNBT;
    private final ResourceLocation registryName;

    public IResearchEffect<?> readFromNBT(CompoundTag nbt) {
        return this.readFromNBT.apply(nbt);
    }

    private ResearchEffectEntry(Function<CompoundTag, IResearchEffect<?>> readFromNBT, ResourceLocation registryName) {
        this.readFromNBT = readFromNBT;
        this.registryName = registryName;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public static final class Builder {
        private Function<CompoundTag, IResearchEffect<?>> readFromNBT;
        private ResourceLocation registryName;

        public Builder setReadFromNBT(Function<CompoundTag, IResearchEffect<?>> readFromNBT) {
            this.readFromNBT = readFromNBT;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public ResearchEffectEntry createResearchEffectEntry() {
            Objects.requireNonNull(this.readFromNBT);
            Objects.requireNonNull(this.registryName);
            return new ResearchEffectEntry(this.readFromNBT, this.registryName);
        }
    }
}

