/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.google.common.collect.Lists;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.statemachine.states.EntityState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.other.MinecoloniesMinecart;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityCitizen
extends AbstractCivilianEntity
implements MenuProvider,
IItemHandlerCapProvider {
    public static final int ENTITY_AI_TICKRATE = 5;
    private static final double CITIZEN_SWIM_BONUS = 2.0;
    public static final EntityDataAccessor<Integer> DATA_LEVEL = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_TEXTURE = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_IS_FEMALE = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_COLONY_ID = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_CITIZEN_ID = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_MODEL = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_RENDER_METADATA = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_IS_ASLEEP = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_CHILD = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<BlockPos> DATA_BED_POS = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<String> DATA_STYLE = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_TEXTURE_SUFFIX = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_JOB = SynchedEntityData.defineId(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private ResourceLocation modelId = ModModelTypes.SETTLER_ID;
    private int textureId;
    private String renderMetadata = "";
    private boolean female;
    private ResourceLocation texture;
    private boolean textureDirty = true;
    private AbstractAdvancedPathNavigate pathNavigate;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;
    private boolean isEquipmentDirty = true;
    protected ITickRateStateMachine<IState> entityStateController = new TickRateStateMachine<EntityState>(EntityState.INIT, e -> Log.getLogger().warn("Citizen " + this.getDisplayName().getString() + " id:" + (this.getCitizenData() != null ? this.getCitizenData().getId() : -1) + "from colony: " + this.getCitizenColonyHandler().getColonyId() + " state controller exception", (Throwable)e), 5);

    public AbstractEntityCitizen(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 100.0);
    }

    public GoalSelector getTasks() {
        return this.goalSelector;
    }

    public int getTicksExisted() {
        return this.tickCount;
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public boolean isControlledByLocalInstance() {
        return this.isEffectiveAi();
    }

    public float calculateDamageAfterAbsorbs(DamageSource source, float damage) {
        float newDamage = this.getDamageAfterArmorAbsorb(source, damage);
        return this.getDamageAfterMagicAbsorb(source, newDamage);
    }

    @NotNull
    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.level().isClientSide()) {
            if (this.getPose() == Pose.SLEEPING) {
                SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this), this.blockPosition(), EventType.OFF_TO_BED, this.getCitizenData(), 100.0);
            } else if (this.getCitizenData() != null && this.getCitizenData().isIdleAtJob()) {
                SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this), this.blockPosition(), EventType.MISSING_EQUIPMENT, this.getCitizenData(), 100.0);
            } else {
                SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this), this.blockPosition(), EventType.INTERACTION, this.getCitizenData(), 100.0);
            }
        }
        return super.interactAt(player, vec, hand);
    }

    public boolean isNoAi() {
        return false;
    }

    public void setTexture() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).isClientSide) {
            return;
        }
        IModelType modelType = IModelTypeRegistry.getInstance().getModelType(this.getModelType());
        if (modelType == null) {
            Log.getLogger().error("Null model type for: " + String.valueOf(this.getModelType()) + " of: " + String.valueOf(this));
            this.textureDirty = false;
            return;
        }
        this.texture = modelType.getTexture(this);
        this.textureDirty = false;
    }

    public abstract ICitizenDataView getCitizenDataView();

    @NotNull
    public ResourceLocation getTexture() {
        if (this.texture == null || this.textureDirty || !this.texture.getPath().contains((CharSequence)this.getEntityData().get(DATA_STYLE)) || !this.texture.getPath().contains((CharSequence)this.getEntityData().get(DATA_TEXTURE_SUFFIX))) {
            this.setTexture();
        }
        return this.texture;
    }

    public void setTextureDirty() {
        this.textureDirty = true;
    }

    public ResourceLocation getModelType() {
        return this.modelId;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TEXTURE_SUFFIX, (Object)"_b");
        builder.define(DATA_TEXTURE, (Object)0);
        builder.define(DATA_LEVEL, (Object)0);
        builder.define(DATA_STYLE, (Object)"default");
        builder.define(DATA_IS_FEMALE, (Object)0);
        builder.define(DATA_MODEL, (Object)ModModelTypes.SETTLER_ID.toString());
        builder.define(DATA_RENDER_METADATA, (Object)"");
        builder.define(DATA_IS_ASLEEP, (Object)false);
        builder.define(DATA_IS_CHILD, (Object)false);
        builder.define(DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
        builder.define(DATA_JOB, (Object)"");
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.pathNavigate == null) {
            this.pathNavigate = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.navigation = this.pathNavigate;
            this.pathNavigate.setCanFloat(true);
            this.pathNavigate.setSwimSpeedFactor(2.0);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler().withTeleportOnFullStuck().withTeleportSteps(5));
        }
        return this.pathNavigate;
    }

    @Override
    public void pushEntities() {
        if (this.collisionCounter > 50) {
            return;
        }
        super.pushEntities();
    }

    @Override
    public void push(@NotNull Entity entityIn) {
        if ((this.collisionCounter += 2) > 50) {
            if (this.collisionCounter > 100) {
                this.collisionCounter = 0;
            }
            return;
        }
        if (this.getVehicle() instanceof MinecoloniesMinecart) {
            return;
        }
        super.push(entityIn);
    }

    @Override
    public void onPlayerCollide(Player player) {
        if (this.getCitizenData() == null) {
            super.onPlayerCollide(player);
            return;
        }
        IJob<?> job = this.getCitizenData().getJob();
        if (job == null || !job.isGuard()) {
            super.onPlayerCollide(player);
        } else {
            this.push((Entity)player);
        }
    }

    public boolean isPushable() {
        if (this.getVehicle() instanceof MinecoloniesMinecart) {
            return false;
        }
        return super.isPushable();
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 5 == 0) {
            this.entityStateController.tick();
        }
        this.updateSwingTime();
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
    }

    public void setOwnRotation(float yaw, float pitch) {
        this.setRot(yaw, pitch);
    }

    public void setModelId(ResourceLocation model) {
        this.modelId = model;
    }

    public void setRenderMetadata(String renderMetadata) {
        if (renderMetadata.equals(this.getRenderMetadata())) {
            return;
        }
        this.renderMetadata = renderMetadata;
        this.entityData.set(DATA_RENDER_METADATA, (Object)this.getRenderMetadata());
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void setTextureId(int textureId) {
        this.textureId = textureId;
        this.entityData.set(DATA_TEXTURE, (Object)textureId);
    }

    public String getRenderMetadata() {
        return this.renderMetadata;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public int getOffsetTicks() {
        return this.tickCount + 7 * this.getId();
    }

    public boolean isBlocking() {
        return this.getUseItem().getItem() instanceof ShieldItem;
    }

    public int getRecentlyHit() {
        return this.lastHurtByPlayerTime;
    }

    public boolean checkCanDropLoot() {
        return this.shouldDropExperience();
    }

    public abstract ILocation getLocation();

    public abstract ICitizenData getCitizenData();

    @NotNull
    public abstract InventoryCitizen getInventoryCitizen();

    @NotNull
    public abstract IItemHandler getItemHandlerCitizen();

    public abstract void setIsChild(boolean var1);

    public abstract void playMoveAwaySound();

    public abstract void decreaseSaturationForAction();

    public abstract void decreaseSaturationForContinuousAction();

    public abstract ICitizenExperienceHandler getCitizenExperienceHandler();

    public abstract ICitizenInventoryHandler getCitizenInventoryHandler();

    public abstract void setCitizenInventoryHandler(ICitizenInventoryHandler var1);

    public abstract ICitizenColonyHandler getCitizenColonyHandler();

    public abstract void setCitizenColonyHandler(ICitizenColonyHandler var1);

    public abstract ICitizenJobHandler getCitizenJobHandler();

    public abstract ICitizenSleepHandler getCitizenSleepHandler();

    public abstract float getRotationYaw();

    public abstract float getRotationPitch();

    public abstract boolean isDead();

    public abstract void setCitizenSleepHandler(ICitizenSleepHandler var1);

    public abstract void setCitizenJobHandler(ICitizenJobHandler var1);

    public abstract void setCitizenExperienceHandler(ICitizenExperienceHandler var1);

    public abstract void callForHelp(Entity var1, int var2);

    public void detectEquipmentUpdates() {
        if (this.isEquipmentDirty && this.tickCount % 20 == this.randomVariance) {
            this.isEquipmentDirty = false;
            ArrayList list = Lists.newArrayListWithCapacity((int)6);
            list.add(new Pair((Object)EquipmentSlot.CHEST, (Object)this.getItemBySlot(EquipmentSlot.CHEST)));
            list.add(new Pair((Object)EquipmentSlot.FEET, (Object)this.getItemBySlot(EquipmentSlot.FEET)));
            list.add(new Pair((Object)EquipmentSlot.HEAD, (Object)this.getItemBySlot(EquipmentSlot.HEAD)));
            list.add(new Pair((Object)EquipmentSlot.LEGS, (Object)this.getItemBySlot(EquipmentSlot.LEGS)));
            list.add(new Pair((Object)EquipmentSlot.OFFHAND, (Object)this.getItemBySlot(EquipmentSlot.OFFHAND)));
            list.add(new Pair((Object)EquipmentSlot.MAINHAND, (Object)this.getItemBySlot(EquipmentSlot.MAINHAND)));
            ((ServerLevel)this.level()).getChunkSource().broadcast((Entity)this, (Packet)new ClientboundSetEquipmentPacket(this.getId(), (List)list));
        }
    }

    public void setItemSlot(EquipmentSlot slot, @NotNull ItemStack newItem) {
        ItemStack previous;
        if (!this.level().isClientSide && !ItemStackUtils.compareItemStacksIgnoreStackSize(previous = this.getItemBySlot(slot), newItem, false, true)) {
            this.markEquipmentDirty();
        }
        super.setItemSlot(slot, newItem);
    }

    public void onArmorRemove(ItemStack stack, EquipmentSlot equipmentSlot) {
        AttributeMap attributemap = this.getAttributes();
        stack.forEachModifier(equipmentSlot, (attributeHolder, modifier) -> {
            AttributeInstance attributeinstance = attributemap.getInstance(attributeHolder);
            if (attributeinstance != null) {
                attributeinstance.removeModifier(modifier);
            }
            EnchantmentHelper.stopLocationBasedEffects((ItemStack)stack, (LivingEntity)this, (EquipmentSlot)equipmentSlot);
        });
    }

    public void onArmorAdd(ItemStack stack, EquipmentSlot equipmentSlot) {
        stack.forEachModifier(equipmentSlot, (attributeHolder, modifier) -> {
            Level patt0$temp;
            AttributeInstance attributeinstance = this.getAttributes().getInstance(attributeHolder);
            if (attributeinstance != null) {
                attributeinstance.removeModifier(modifier.id());
                attributeinstance.addTransientModifier(modifier);
            }
            if ((patt0$temp = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)patt0$temp;
                EnchantmentHelper.runLocationChangedEffects((ServerLevel)serverlevel, (ItemStack)stack, (LivingEntity)this, (EquipmentSlot)equipmentSlot);
            }
        });
    }

    public void markEquipmentDirty() {
        this.isEquipmentDirty = true;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public ITickRateStateMachine<IState> getEntityStateController() {
        return this.entityStateController;
    }

    public boolean isSleeping() {
        return this.getCitizenSleepHandler().isAsleep();
    }

    @Override
    @Nullable
    public IItemHandler getItemHandlerCap(Direction facing) {
        ICitizenData data = this.getCitizenData();
        return data == null ? null : data.getInventory();
    }

    public int getTeamColor() {
        if (this.getCitizenColonyHandler().getColony() == null) {
            return super.getTeamColor();
        }
        return this.getCitizenColonyHandler().getColony().getTeamColonyColor().getColor();
    }

    @NotNull
    public Component getDisplayName() {
        if (this.getCitizenColonyHandler().getColony() == null) {
            return super.getDisplayName();
        }
        Component component = this.getName();
        if (component instanceof MutableComponent) {
            MutableComponent mutableComponent = (MutableComponent)component;
            return mutableComponent.withStyle(this.getCitizenColonyHandler().getColony().getTeamColonyColor()).withStyle(style -> style.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
        }
        return super.getDisplayName();
    }
}

