/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.ImmutableItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    protected final boolean shouldIgnoreDamageValue;
    protected final boolean shouldIgnoreNBTValue;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack, int amount, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = amount;
    }

    public ItemStorage(@NotNull ItemStack stack, int amount, boolean ignoreDamageValue, boolean ignoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreNBTValue;
        this.amount = amount;
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = false;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(@NotNull Item item) {
        this(item.getDefaultInstance());
    }

    public ItemStorage(@NotNull HolderLookup.Provider provider, @NotNull JsonObject jObject) {
        if (jObject.has("count")) {
            this.amount = jObject.get("count").getAsInt();
            jObject = jObject.deepCopy();
            jObject.remove("count");
        } else {
            this.amount = 1;
        }
        if (jObject.has("id")) {
            String matchType;
            this.stack = (ItemStack)Utils.deserializeCodecMessFromJson(ItemStack.OPTIONAL_CODEC, provider, (JsonElement)jObject);
            this.shouldIgnoreNBTValue = jObject.has("matchType") ? (matchType = jObject.get("matchType").getAsString()).equals("ignore") : false;
            this.shouldIgnoreDamageValue = true;
        } else {
            this.stack = ItemStack.EMPTY;
            this.amount = 0;
            this.shouldIgnoreDamageValue = true;
            this.shouldIgnoreNBTValue = true;
        }
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.shouldIgnoreDamageValue;
    }

    public boolean ignoreNBT() {
        return this.shouldIgnoreNBTValue;
    }

    public String toString() {
        ItemStack stack = this.stack.copy();
        stack.setCount(this.amount);
        return stack.toString();
    }

    public int hashCode() {
        return Objects.hash(this.stack.getItem());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemStorage)) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return ItemStackUtils.compareItemStacksIgnoreStackSize(that.getItemStack(), this.getItemStack(), !this.shouldIgnoreDamageValue && !that.shouldIgnoreDamageValue, !this.shouldIgnoreNBTValue && !that.shouldIgnoreNBTValue);
    }

    public boolean matchDefinitionEquals(ItemStorage that) {
        return this.shouldIgnoreDamageValue == that.shouldIgnoreDamageValue && this.shouldIgnoreNBTValue == that.shouldIgnoreNBTValue;
    }

    @NotNull
    public Item getItem() {
        return this.stack.getItem();
    }

    public int getDamageValue() {
        return this.stack.getDamageValue();
    }

    public int getRemainingDurablityValue() {
        return this.stack.getMaxDamage() - this.stack.getDamageValue();
    }

    public boolean isEmpty() {
        return ItemStackUtils.isEmpty(this.stack) || this.amount <= 0;
    }

    public ItemStorage copy() {
        ItemStorage newInstance = new ItemStorage(this.stack.copy(), this.shouldIgnoreDamageValue, this.shouldIgnoreNBTValue);
        newInstance.setAmount(this.amount);
        return newInstance;
    }

    public ImmutableItemStorage toImmutable() {
        return new ImmutableItemStorage(this);
    }
}

