/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.colonyEvents.registry;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.util.Log;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class ColonyEventTypeRegistryEntry {
    private final TriFunction<IColony, CompoundTag, HolderLookup.Provider, IColonyEvent> eventCreator;
    private final ResourceLocation registryName;

    public ColonyEventTypeRegistryEntry(@NotNull TriFunction<IColony, CompoundTag, HolderLookup.Provider, IColonyEvent> eventCreator, @NotNull ResourceLocation registryID) {
        if (registryID.getPath().isEmpty()) {
            Log.getLogger().warn("Created empty registry empty for event, supply a name for it!");
        }
        this.eventCreator = eventCreator;
        this.registryName = registryID;
    }

    public IColonyEvent deserializeEvent(@Nonnull IColony colony, @NotNull HolderLookup.Provider provider, @Nonnull CompoundTag compound) {
        return (IColonyEvent)this.eventCreator.apply((Object)colony, (Object)compound, (Object)provider);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

