/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockGate
extends DoorBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final String IRON_GATE = "gate_iron";
    public static final String WOODEN_GATE = "gate_wood";
    private final int maxWidth;
    private final int maxHeight;
    private final float hardness;
    protected static final VoxelShape E_W_SHAPE = Shapes.box((double)0.3, (double)0.0, (double)0.0, (double)0.7, (double)1.0, (double)1.0);
    protected static final VoxelShape N_S_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.3, (double)1.0, (double)1.0, (double)0.7);
    private final String name;

    public AbstractBlockGate(String name, float hardness, int maxWidth, int maxHeight) {
        super(BlockSetType.SPRUCE, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(hardness, hardness * 5.0f).noOcclusion());
        this.registerDefaultState(this.defaultBlockState());
        this.name = name;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.hardness = hardness;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        this.toggleGate(worldIn, pos, ((Direction)state.getValue((Property)FACING)).getClockWise());
        worldIn.levelEvent(player, (Boolean)state.getValue((Property)OPEN) != false ? 1005 : 1011, pos, 0);
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        int count = this.removeGate(worldIn, pos, ((Direction)state.getValue((Property)FACING)).getClockWise());
        for (int i = 0; i < count; ++i) {
            Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public int removeGate(Level world, BlockPos startPos, Direction facing) {
        BlockPos current;
        BlockPos lowerLeftCorner = this.findLowerLeftCorner((BlockGetter)world, facing, startPos);
        int amount = 0;
        for (int hor = 0; hor < this.maxWidth && world.getBlockState(current = lowerLeftCorner.relative(facing, hor)).getBlock() == this; ++hor) {
            BlockPos currentPos;
            for (int vert = 0; vert < this.maxHeight && world.getBlockState(currentPos = current.above(vert)).getBlock() == this; ++vert) {
                ++amount;
                world.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 35);
            }
        }
        return amount;
    }

    @Deprecated
    public float getBlockHardness(BlockState blockState, BlockGetter worldIn, BlockPos pos) {
        BlockPos hPos;
        if (worldIn == null) {
            return 10.0f;
        }
        Direction facing = ((Direction)blockState.getValue((Property)FACING)).getClockWise();
        BlockPos start = this.findLowerLeftCorner(worldIn, facing, pos);
        int count = 0;
        for (int hor = 0; hor < this.maxWidth && worldIn.getBlockState(hPos = start.relative(facing, hor)).getBlock() == this; ++hor) {
            BlockPos worldPos;
            BlockState state;
            for (int vert = 0; vert < this.maxHeight && (state = worldIn.getBlockState(worldPos = hPos.offset(0, vert, 0))).getBlock() == this; ++vert) {
                ++count;
            }
        }
        return (float)count * this.hardness;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos tPos = pos.offset(-1, -1, -1);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    if (worldIn.getBlockState(tPos.offset(x, y, z)).getBlock() != this) continue;
                    return false;
                }
            }
        }
        BlockPos blockpos = pos.below();
        BlockState blockstate = worldIn.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos checkPos;
        BlockState checkState;
        int hor;
        Direction facing = ((Direction)state.getValue((Property)FACING)).getClockWise();
        this.fillYStates(worldIn, pos, state, stack);
        int canPlace = this.maxWidth - 1;
        for (hor = 1; hor < this.maxWidth && (checkState = worldIn.getBlockState(checkPos = pos.relative(facing.getOpposite(), hor))).isAir() && canPlace > 0 && worldIn.getBlockState(checkPos.relative(facing.getOpposite())).getBlock() != this; --canPlace, ++hor) {
            if (stack.getCount() > 1) {
                stack.setCount(stack.getCount() - 1);
                worldIn.setBlockAndUpdate(checkPos, state);
            }
            this.fillYStates(worldIn, checkPos, state, stack);
        }
        if (canPlace <= 0) {
            return;
        }
        for (hor = 1; hor < this.maxWidth && (checkState = worldIn.getBlockState(checkPos = pos.relative(facing, hor))).getBlock() != this && checkState.isAir() && canPlace > 0 && worldIn.getBlockState(checkPos.relative(facing)).getBlock() != this; --canPlace, ++hor) {
            if (stack.getCount() > 1) {
                stack.setCount(stack.getCount() - 1);
                worldIn.setBlockAndUpdate(checkPos, state);
            }
            this.fillYStates(worldIn, checkPos, state, stack);
        }
    }

    private void fillYStates(Level world, BlockPos base, BlockState state, ItemStack stack) {
        BlockPos checkPos;
        BlockState checkState;
        for (int vert = 1; vert < this.maxHeight && (checkState = world.getBlockState(checkPos = base.offset(0, vert, 0))).isAir() && world.getBlockState(checkPos.above()).getBlock() != this; ++vert) {
            if (stack.getCount() <= 1) continue;
            stack.setCount(stack.getCount() - 1);
            world.setBlockAndUpdate(checkPos, state);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShapeForState(state);
    }

    private VoxelShape getShapeForState(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case EAST: 
            case WEST: {
                return E_W_SHAPE;
            }
        }
        return N_S_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return Shapes.empty();
        }
        return this.getShapeForState(state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getShapeForState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }

    private BlockPos findLowerLeftCorner(BlockGetter world, Direction facing, BlockPos blockPos) {
        BlockPos tePos = blockPos;
        for (int vert = 0; vert < this.maxHeight; ++vert) {
            BlockPos tempPos = tePos.offset(0, -vert, 0);
            if (world.getBlockState(tempPos.below()).getBlock() == this) continue;
            tePos = tempPos;
            break;
        }
        for (int hor = 0; hor < this.maxWidth; ++hor) {
            if (world.getBlockState(tePos.relative(facing.getOpposite(), hor + 1)).getBlock() == this) continue;
            tePos = tePos.relative(facing.getOpposite(), hor);
            break;
        }
        return tePos;
    }

    public void setOpen(@Nullable Entity p_153166_, Level worldIn, BlockState state, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.getBlockState(pos);
        if (blockstate.getBlock() == this && (Boolean)blockstate.getValue((Property)OPEN) != open) {
            this.toggleGate(worldIn, pos, ((Direction)blockstate.getValue((Property)FACING)).getClockWise());
        }
    }

    public void toggleGate(Level world, BlockPos clickedBlock, Direction facing) {
        BlockPos hPos;
        BlockPos lowerLeftCorner = this.findLowerLeftCorner((BlockGetter)world, facing, clickedBlock);
        boolean opening = (Boolean)world.getBlockState(lowerLeftCorner).getValue((Property)BlockStateProperties.OPEN) == false;
        for (int hor = 0; hor < this.maxWidth && world.getBlockState(hPos = lowerLeftCorner.relative(facing, hor)).getBlock() == this; ++hor) {
            BlockPos worldPos;
            BlockState state;
            for (int vert = 0; vert < this.maxHeight && (state = world.getBlockState(worldPos = hPos.offset(0, vert, 0))).getBlock() == this; ++vert) {
                if (world.getBlockState(worldPos.above()).getBlock() != this) {
                    WorldUtil.setBlockState((LevelAccessor)world, worldPos, (BlockState)state.setValue((Property)DoorBlock.HINGE, (Comparable)(opening ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT)), 2);
                    continue;
                }
                WorldUtil.setBlockState((LevelAccessor)world, worldPos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(opening)), 2);
            }
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, @NotNull BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = worldIn.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)OPEN)) {
            this.setOpen(null, worldIn, state, pos, powered);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        if (blockpos.getY() < 255 && context.getLevel().getBlockState(blockpos.above()).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        }
        return null;
    }

    public AbstractBlockGate registerBlock(Registry<Block> registry) {
        Registry.register(registry, (ResourceLocation)new ResourceLocation("minecolonies", this.name), (Object)((Object)this));
        return this;
    }

    public void registerBlockItem(Registry<Item> registry, Item.Properties properties) {
        Registry.register(registry, (ResourceLocation)new ResourceLocation("minecolonies", this.name), (Object)new BlockItem((Block)this, properties));
    }
}

