/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import com.mcwwindows.kikoz.util.WindowPart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GothicWindow
extends WindowBase {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final VoxelShape EAST = Shapes.or((VoxelShape)GothicWindow.box((double)3.0, (double)0.0, (double)-1.0, (double)13.0, (double)16.0, (double)17.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.or((VoxelShape)GothicWindow.box((double)-1.0, (double)0.0, (double)3.0, (double)17.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);

    public GothicWindow(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)PART, (Comparable)((Object)WindowPart.BASE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case WEST: {
                return EAST;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return NORTH;
            }
        }
        return NORTH;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.WindowState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    public void openDoor(Level worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == this.asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (item == ItemInit.HAMMER.get()) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)PART));
            return ItemInteractionResult.SUCCESS;
        }
        this.openWindow(worldIn, pos, (Boolean)state.getValue((Property)OPEN) == false, (Direction)state.getValue((Property)FACING));
        worldIn.playSound(null, pos, (SoundEvent)SoundsInit.BARS_OPEN.get(), SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.cycle((Property)OPEN);
        worldIn.setBlock(pos, state, 10);
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    private void openWindow(Level world, BlockPos pos, boolean bool, Direction dir) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() == this && (Boolean)state.getValue((Property)OPEN) != bool && ((Direction)state.getValue((Property)FACING)).equals((Object)dir)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(bool)));
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = pos.offset(x, y, z);
                        this.openWindow(world, newPos, bool, dir);
                    }
                }
            }
        }
    }
}

