/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.NoiseRouterTarget;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.util.DensityFunctionWrapper;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.DensityFunction;

public record WrapNoiseRouterModifier(int priority, ResourceKey<Level> dimension, NoiseRouterTarget target, Holder<DensityFunction> wrapperFunction) implements Modifier
{
    public static final MapCodec<WrapNoiseRouterModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("priority", (Object)1000).forGetter(WrapNoiseRouterModifier::priority), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(WrapNoiseRouterModifier::dimension), (App)NoiseRouterTarget.CODEC.fieldOf("target").forGetter(WrapNoiseRouterModifier::target), (App)DensityFunction.CODEC.fieldOf("wrapper_function").forGetter(WrapNoiseRouterModifier::wrapperFunction)).apply((Applicative)instance, WrapNoiseRouterModifier::new));

    @Override
    public void applyModifier() {
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.NONE;
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }

    public static DensityFunction modifyDensityFunction(NoiseRouterTarget target, DensityFunction wrapped, List<WrapNoiseRouterModifier> modifiers) {
        List<DensityFunction> orderedFunctions = modifiers.stream().filter(modifier -> modifier.target == target).sorted(Comparator.comparingInt(WrapNoiseRouterModifier::priority)).map(modifier -> (DensityFunction)modifier.wrapperFunction().value()).toList();
        if (orderedFunctions.isEmpty()) {
            return wrapped;
        }
        DensityFunction mergedFunction = wrapped;
        for (DensityFunction function : orderedFunctions) {
            mergedFunction = DensityFunctionWrapper.wrap(mergedFunction, function);
        }
        return mergedFunction;
    }
}

